/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.ArrayIterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.ReverseArrayIterator;
import org.neo4j.kernel.Traversal;

public final class PathImpl
implements Path {
    private final Node start;
    private final Relationship[] path;
    private final Node end;

    private static String relToString(Relationship rel) {
        return rel.getStartNode() + "--" + rel.getType() + "-->" + rel.getEndNode();
    }

    private PathImpl(Builder left, Builder right) {
        int i;
        Node endNode = null;
        this.path = new Relationship[left.size + (right == null ? 0 : right.size)];
        if (right != null) {
            int total = i + right.size;
            for (i = left.size; i < total; ++i) {
                this.path[i] = right.relationship;
                right = right.previous;
            }
            assert (right.relationship == null) : "right Path.Builder size error";
            endNode = right.start;
        }
        for (i = left.size - 1; i >= 0; --i) {
            this.path[i] = left.relationship;
            left = left.previous;
        }
        assert (left.relationship == null) : "left Path.Builder size error";
        this.start = left.start;
        this.end = endNode;
    }

    public static Path singular(Node start) {
        return new Builder(start).build();
    }

    public Node startNode() {
        return this.start;
    }

    public Node endNode() {
        if (this.end != null) {
            return this.end;
        }
        Node stepNode = null;
        Iterator<Node> i$ = this.nodes().iterator();
        while (i$.hasNext()) {
            Node node;
            stepNode = node = i$.next();
        }
        return stepNode;
    }

    public Relationship lastRelationship() {
        return this.path != null && this.path.length > 0 ? this.path[this.path.length - 1] : null;
    }

    public Iterable<Node> nodes() {
        return this.nodeIterator(this.start);
    }

    public Iterable<Node> reverseNodes() {
        return this.nodeIterator(this.end);
    }

    private Iterable<Node> nodeIterator(final Node start) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    Node current;
                    int index;
                    {
                        this.current = start;
                        this.index = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index <= PathImpl.this.path.length;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Node next() {
                        if (this.current == null) {
                            throw new NoSuchElementException();
                        }
                        Node next = null;
                        if (this.index < PathImpl.this.path.length) {
                            next = PathImpl.this.path[this.index].getOtherNode(this.current);
                        }
                        ++this.index;
                        try {
                            Node node = this.current;
                            return node;
                        }
                        finally {
                            this.current = next;
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Iterable<Relationship> relationships() {
        return new Iterable<Relationship>(){

            @Override
            public Iterator<Relationship> iterator() {
                return new ArrayIterator((Object[])PathImpl.this.path);
            }
        };
    }

    public Iterable<Relationship> reverseRelationships() {
        return new Iterable<Relationship>(){

            @Override
            public Iterator<Relationship> iterator() {
                return new ReverseArrayIterator((Object[])PathImpl.this.path);
            }
        };
    }

    public Iterator<PropertyContainer> iterator() {
        return new Iterator<PropertyContainer>(){
            Iterator<? extends PropertyContainer> current;
            Iterator<? extends PropertyContainer> next;
            {
                this.current = PathImpl.this.nodes().iterator();
                this.next = PathImpl.this.relationships().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.current.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PropertyContainer next() {
                try {
                    PropertyContainer propertyContainer = this.current.next();
                    return propertyContainer;
                }
                finally {
                    Iterator<? extends PropertyContainer> temp = this.current;
                    this.current = this.next;
                    this.next = temp;
                }
            }

            @Override
            public void remove() {
                this.next.remove();
            }
        };
    }

    public int length() {
        return this.path.length;
    }

    public int hashCode() {
        if (this.path.length == 0) {
            return this.start.hashCode();
        }
        return Arrays.hashCode(this.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Path) {
            Path other = (Path)obj;
            if (!this.start.equals(other.startNode())) {
                return false;
            }
            return IteratorUtil.iteratorsEqual(this.relationships().iterator(), other.relationships().iterator());
        }
        return false;
    }

    public String toString() {
        return Traversal.defaultPathToString((Path)this);
    }

    public static final class Builder {
        private final Builder previous;
        private final Node start;
        private final Relationship relationship;
        private final int size;

        public Builder(Node start) {
            if (start == null) {
                throw new NullPointerException();
            }
            this.start = start;
            this.previous = null;
            this.relationship = null;
            this.size = 0;
        }

        private Builder(Builder prev, Relationship rel) {
            this.start = prev.start;
            this.previous = prev;
            this.relationship = rel;
            this.size = prev.size + 1;
        }

        public Node getStartNode() {
            return this.start;
        }

        public Path build() {
            return new PathImpl(this, null);
        }

        public Builder push(Relationship relationship) {
            if (relationship == null) {
                throw new NullPointerException();
            }
            return new Builder(this, relationship);
        }

        public Path build(Builder other) {
            return new PathImpl(this, other);
        }

        public String toString() {
            if (this.previous == null) {
                return this.start.toString();
            }
            return PathImpl.relToString(this.relationship) + ":" + this.previous.toString();
        }
    }
}

