/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import java.util.Iterator;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphalgo.impl.util.BestFirstSelectorFactory;
import org.neo4j.graphalgo.impl.util.WeightedPathIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.InitialBranchState;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.TraversalMetadata;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.StandardExpander;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;

public class Dijkstra
implements PathFinder<WeightedPath> {
    private static final TraversalDescription TRAVERSAL = Traversal.traversal().uniqueness((UniquenessFactory)Uniqueness.NONE);
    private final PathExpander expander;
    private final InitialBranchState stateFactory;
    private final CostEvaluator<Double> costEvaluator;
    private Traverser lastTraverser;
    private final boolean stopAfterLowestCost;

    public Dijkstra(PathExpander expander, CostEvaluator<Double> costEvaluator) {
        this(expander, InitialBranchState.NO_STATE, costEvaluator, true);
    }

    public Dijkstra(PathExpander expander, InitialBranchState stateFactory, CostEvaluator<Double> costEvaluator) {
        this(expander, stateFactory, costEvaluator, true);
    }

    public Dijkstra(RelationshipExpander expander, CostEvaluator<Double> costEvaluator) {
        this(StandardExpander.toPathExpander((RelationshipExpander)expander), costEvaluator, true);
    }

    public Dijkstra(PathExpander expander, CostEvaluator<Double> costEvaluator, boolean stopAfterLowestCost) {
        this(expander, InitialBranchState.NO_STATE, costEvaluator, stopAfterLowestCost);
    }

    public Dijkstra(PathExpander expander, InitialBranchState stateFactory, CostEvaluator<Double> costEvaluator, boolean stopAfterLowestCost) {
        this.expander = expander;
        this.costEvaluator = costEvaluator;
        this.stateFactory = stateFactory;
        this.stopAfterLowestCost = stopAfterLowestCost;
    }

    public Dijkstra(RelationshipExpander expander, CostEvaluator<Double> costEvaluator, boolean stopAfterLowestCost) {
        this(StandardExpander.toPathExpander((RelationshipExpander)expander), costEvaluator, stopAfterLowestCost);
    }

    @Override
    public Iterable<WeightedPath> findAllPaths(Node start, Node end) {
        final Traverser traverser = this.traverser(start, end, BestFirstSelectorFactory.pathInterest(true, this.stopAfterLowestCost));
        return new Iterable<WeightedPath>(){

            @Override
            public Iterator<WeightedPath> iterator() {
                return new WeightedPathIterator(traverser.iterator(), Dijkstra.this.costEvaluator, Dijkstra.this.stopAfterLowestCost);
            }
        };
    }

    private Traverser traverser(Node start, Node end, BestFirstSelectorFactory.PathInterest interest) {
        this.lastTraverser = TRAVERSAL.expand(this.expander, this.stateFactory).order((BranchOrderingPolicy)new SelectorFactory(interest, this.costEvaluator)).evaluator(Evaluators.includeWhereEndNodeIs((Node[])new Node[]{end})).traverse(start);
        return this.lastTraverser;
    }

    @Override
    public WeightedPath findSinglePath(Node start, Node end) {
        return (WeightedPath)IteratorUtil.firstOrNull((Iterator)((Object)new WeightedPathIterator(this.traverser(start, end, BestFirstSelectorFactory.PathInterest.singleLowest).iterator(), this.costEvaluator, true)));
    }

    @Override
    public TraversalMetadata metadata() {
        return this.lastTraverser.metadata();
    }

    private static class SelectorFactory
    extends BestFirstSelectorFactory<Double, Double> {
        private final CostEvaluator<Double> evaluator;

        SelectorFactory(BestFirstSelectorFactory.PathInterest interest, CostEvaluator<Double> evaluator) {
            super(interest);
            this.evaluator = evaluator;
        }

        @Override
        protected Double calculateValue(TraversalBranch next) {
            return next.length() == 0 ? 0.0 : this.evaluator.getCost(next.lastRelationship(), Direction.OUTGOING);
        }

        @Override
        protected Double addPriority(TraversalBranch source, Double currentAggregatedValue, Double value) {
            return this.withDefault(currentAggregatedValue, 0.0) + this.withDefault(value, 0.0);
        }

        private <T> T withDefault(T valueOrNull, T valueIfNull) {
            return valueOrNull != null ? valueOrNull : valueIfNull;
        }

        @Override
        protected Double getStartData() {
            return 0.0;
        }
    }
}

