/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import java.util.Iterator;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphalgo.impl.util.BestFirstSelectorFactory;
import org.neo4j.graphalgo.impl.util.StopAfterWeightIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.InitialStateFactory;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.TraversalMetadata;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.StandardExpander;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;

public class Dijkstra
implements PathFinder<WeightedPath> {
    private static final TraversalDescription TRAVERSAL = Traversal.traversal().uniqueness((UniquenessFactory)Uniqueness.NONE);
    private final PathExpander expander;
    private final InitialStateFactory stateFactory;
    private final CostEvaluator<Double> costEvaluator;
    private Traverser lastTraverser;

    public Dijkstra(PathExpander expander, CostEvaluator<Double> costEvaluator) {
        this(expander, InitialStateFactory.NO_STATE, costEvaluator);
    }

    public Dijkstra(PathExpander expander, InitialStateFactory stateFactory, CostEvaluator<Double> costEvaluator) {
        this.expander = expander;
        this.costEvaluator = costEvaluator;
        this.stateFactory = stateFactory;
    }

    public Dijkstra(RelationshipExpander expander, CostEvaluator<Double> costEvaluator) {
        this(StandardExpander.toPathExpander((RelationshipExpander)expander), costEvaluator);
    }

    @Override
    public Iterable<WeightedPath> findAllPaths(Node start, Node end) {
        this.lastTraverser = TRAVERSAL.expand(this.expander, this.stateFactory).order((BranchOrderingPolicy)new SelectorFactory(this.costEvaluator)).evaluator(Evaluators.includeWhereEndNodeIs((Node[])new Node[]{end})).traverse(start);
        return new Iterable<WeightedPath>(){

            @Override
            public Iterator<WeightedPath> iterator() {
                return new StopAfterWeightIterator(Dijkstra.this.lastTraverser.iterator(), Dijkstra.this.costEvaluator);
            }
        };
    }

    @Override
    public WeightedPath findSinglePath(Node start, Node end) {
        return (WeightedPath)IteratorUtil.firstOrNull(this.findAllPaths(start, end));
    }

    @Override
    public TraversalMetadata metadata() {
        return this.lastTraverser.metadata();
    }

    private static class SelectorFactory
    extends BestFirstSelectorFactory<Double, Double> {
        private final CostEvaluator<Double> evaluator;

        SelectorFactory(CostEvaluator<Double> evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        protected Double calculateValue(TraversalBranch next) {
            return next.length() == 0 ? 0.0 : this.evaluator.getCost(next.lastRelationship(), Direction.OUTGOING);
        }

        @Override
        protected Double addPriority(TraversalBranch source, Double currentAggregatedValue, Double value) {
            return this.withDefault(currentAggregatedValue, 0.0) + this.withDefault(value, 0.0);
        }

        private <T> T withDefault(T valueOrNull, T valueIfNull) {
            return valueOrNull != null ? valueOrNull : valueIfNull;
        }

        @Override
        protected Double getStartData() {
            return 0.0;
        }
    }
}

