/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.centrality;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.impl.centrality.EigenvectorCentrality;
import org.neo4j.graphalgo.impl.util.MatrixUtil;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EigenvectorCentralityArnoldi
implements EigenvectorCentrality {
    protected Direction relationDirection;
    protected CostEvaluator<Double> costEvaluator;
    protected Set<Node> nodeSet;
    protected Set<Relationship> relationshipSet;
    protected double precision = 0.001;
    protected boolean doneCalculation = false;
    protected Map<Node, Double> values;
    protected int totalIterations = 0;
    private int maxIterations = Integer.MAX_VALUE;

    public EigenvectorCentralityArnoldi(Direction relationDirection, CostEvaluator<Double> costEvaluator, Set<Node> nodeSet, Set<Relationship> relationshipSet, double precision) {
        this.relationDirection = relationDirection;
        this.costEvaluator = costEvaluator;
        this.nodeSet = nodeSet;
        this.relationshipSet = relationshipSet;
        this.precision = precision;
    }

    @Override
    public Double getCentrality(Node node) {
        this.calculate();
        return this.values.get(node);
    }

    @Override
    public void reset() {
        this.doneCalculation = false;
    }

    @Override
    public void calculate() {
        if (this.doneCalculation) {
            return;
        }
        this.doneCalculation = true;
        this.values = new HashMap<Node, Double>();
        this.totalIterations = 0;
        Random random = new Random(System.currentTimeMillis());
        for (Node node : this.nodeSet) {
            this.values.put(node, random.nextDouble());
        }
        this.normalize(this.values);
        this.runIterations(this.maxIterations);
    }

    private boolean timeToStop(Map<Node, Double> oldValues, Map<Node, Double> newValues) {
        for (Node node : oldValues.keySet()) {
            if (newValues.get(node) == null) {
                return false;
            }
            if (oldValues.get(node) == 0.0) {
                if (!(Math.abs(newValues.get(node)) > this.precision)) continue;
                return false;
            }
            double factor = newValues.get(node) / oldValues.get(node);
            if (!((factor = Math.abs(factor)) - this.precision > 1.0) && !(factor + this.precision < 1.0)) continue;
            return false;
        }
        return true;
    }

    public int runIterations(int maxNrIterations) {
        int localIterations;
        if (maxNrIterations <= 0) {
            return 0;
        }
        for (localIterations = 0; localIterations < maxNrIterations; localIterations += this.runInternalArnoldi(3)) {
            Map<Node, Double> oldValues = this.values;
            if (!this.timeToStop(oldValues, this.values)) continue;
            break;
        }
        if (this.values.get(this.nodeSet.iterator().next()) < 0.0) {
            for (Node node : this.nodeSet) {
                this.values.put(node, -this.values.get(node).doubleValue());
            }
        }
        return localIterations;
    }

    protected int runInternalArnoldi(int iterations) {
        ArrayList<Node> nodes = new ArrayList<Node>(this.nodeSet.size());
        for (Node node : this.nodeSet) {
            nodes.add(node);
        }
        MatrixUtil.DoubleMatrix hMatrix = new MatrixUtil.DoubleMatrix();
        MatrixUtil.DoubleMatrix qMatrix = new MatrixUtil.DoubleMatrix();
        for (int i = 0; i < nodes.size(); ++i) {
            qMatrix.set(0, i, this.values.get(nodes.get(i)));
        }
        int localIterations = 1;
        while (true) {
            ++this.totalIterations;
            HashMap<Node, Double> newValues = new HashMap<Node, Double>();
            for (Relationship relationship : this.relationshipSet) {
                if (this.relationDirection.equals((Object)Direction.BOTH) || this.relationDirection.equals((Object)Direction.OUTGOING)) {
                    this.processRelationship(newValues, relationship, false);
                }
                if (!this.relationDirection.equals((Object)Direction.BOTH) && !this.relationDirection.equals((Object)Direction.INCOMING)) continue;
                this.processRelationship(newValues, relationship, true);
            }
            for (int j = 0; j < localIterations; ++j) {
                int i;
                MatrixUtil.DoubleVector qj = qMatrix.getRow(j);
                double product = 0.0;
                for (i = 0; i < nodes.size(); ++i) {
                    Double d1 = (Double)newValues.get(nodes.get(i));
                    Double d2 = qj.get(i);
                    if (d1 == null || d2 == null) continue;
                    product += d1 * d2;
                }
                hMatrix.set(j, localIterations - 1, product);
                if (product == 0.0) continue;
                for (i = 0; i < nodes.size(); ++i) {
                    Double qValue;
                    Node node = (Node)nodes.get(i);
                    Double value = (Double)newValues.get(node);
                    if (value == null) {
                        value = 0.0;
                    }
                    if ((qValue = qj.get(i)) == null) continue;
                    newValues.put(node, value - product * qValue);
                }
            }
            double normalizeFactor = this.normalize(newValues);
            this.values = newValues;
            MatrixUtil.DoubleVector qVector = new MatrixUtil.DoubleVector();
            for (int i = 0; i < nodes.size(); ++i) {
                qVector.set(i, (Double)newValues.get(nodes.get(i)));
            }
            qMatrix.setRow(localIterations, qVector);
            if (normalizeFactor == 0.0 || localIterations >= this.nodeSet.size() || localIterations >= iterations) break;
            hMatrix.set(localIterations, localIterations - 1, normalizeFactor);
            ++localIterations;
        }
        Random random = new Random(System.currentTimeMillis());
        MatrixUtil.DoubleVector vector = new MatrixUtil.DoubleVector();
        for (int i = 0; i < this.nodeSet.size(); ++i) {
            vector.set(i, random.nextDouble());
        }
        MatrixUtil.normalize(vector);
        boolean powerDone = false;
        int its = 0;
        double powerPrecision = 0.1;
        while (!powerDone) {
            MatrixUtil.DoubleVector newVector = MatrixUtil.multiply(hMatrix, vector);
            MatrixUtil.normalize(newVector);
            powerDone = true;
            for (Integer index : vector.getIndices()) {
                double factor;
                if (newVector.get(index) == null || !((factor = Math.abs(newVector.get(index) / vector.get(index))) - powerPrecision > 1.0) && !(factor + powerPrecision < 1.0)) continue;
                powerDone = false;
                break;
            }
            vector = newVector;
            if (++its <= 100) continue;
            break;
        }
        MatrixUtil.DoubleVector ritzVector = new MatrixUtil.DoubleVector();
        for (int r = 0; r < this.nodeSet.size(); ++r) {
            for (int c = 0; c < localIterations; ++c) {
                ritzVector.incrementValue(r, vector.get(c) * qMatrix.get(c, r));
            }
        }
        for (int i = 0; i < this.nodeSet.size(); ++i) {
            this.values.put((Node)nodes.get(i), ritzVector.get(i));
        }
        this.normalize(this.values);
        return localIterations;
    }

    protected void processRelationship(Map<Node, Double> newValues, Relationship relationship, boolean backwards) {
        Node endNode;
        Double newValue;
        Node startNode = relationship.getStartNode();
        if (backwards) {
            startNode = relationship.getEndNode();
        }
        if ((newValue = newValues.get(endNode = relationship.getOtherNode(startNode))) == null) {
            newValue = 0.0;
        }
        if (this.values.get(startNode) != null) {
            newValue = newValue + this.values.get(startNode) * this.costEvaluator.getCost(relationship, backwards ? Direction.INCOMING : Direction.OUTGOING);
        }
        newValues.put(endNode, newValue);
    }

    protected double normalize(Map<Node, Double> vector) {
        double sum = 0.0;
        for (Node node : vector.keySet()) {
            Double d = vector.get(node);
            if (d == null) {
                d = 0.0;
                vector.put(node, 0.0);
            }
            sum += d * d;
        }
        if ((sum = Math.sqrt(sum)) > 0.0) {
            for (Node node : vector.keySet()) {
                vector.put(node, vector.get(node) / sum);
            }
        }
        return sum;
    }

    public int getTotalIterations() {
        return this.totalIterations;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }
}

