/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.shortestpath;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static List<Node> constructSinglePathToNodeAsNodes(Node node, Map<Node, List<Relationship>> predecessors, boolean includeNode, boolean backwards) {
        List<PropertyContainer> singlePathToNode = Util.constructSinglePathToNode(node, predecessors, includeNode, backwards);
        Iterator<PropertyContainer> iterator = singlePathToNode.iterator();
        if (backwards && !includeNode && iterator.hasNext()) {
            iterator.next();
        }
        LinkedList<Node> path = new LinkedList<Node>();
        while (iterator.hasNext()) {
            path.addLast((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            iterator.next();
        }
        return path;
    }

    public static List<Relationship> constructSinglePathToNodeAsRelationships(Node node, Map<Node, List<Relationship>> predecessors, boolean backwards) {
        List<PropertyContainer> singlePathToNode = Util.constructSinglePathToNode(node, predecessors, true, backwards);
        Iterator<PropertyContainer> iterator = singlePathToNode.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        LinkedList<Relationship> path = new LinkedList<Relationship>();
        while (iterator.hasNext()) {
            path.addLast((Relationship)iterator.next());
            if (!iterator.hasNext()) continue;
            iterator.next();
        }
        return path;
    }

    public static List<PropertyContainer> constructSinglePathToNode(Node node, Map<Node, List<Relationship>> predecessors, boolean includeNode, boolean backwards) {
        LinkedList<PropertyContainer> path = new LinkedList<PropertyContainer>();
        if (includeNode) {
            if (backwards) {
                path.addLast((PropertyContainer)node);
            } else {
                path.addFirst((PropertyContainer)node);
            }
        }
        Node currentNode = node;
        List<Relationship> currentPreds = predecessors.get(currentNode);
        while (currentPreds != null && currentPreds.size() != 0) {
            Relationship currentRelationship = currentPreds.get(0);
            currentNode = currentRelationship.getOtherNode(currentNode);
            if (backwards) {
                path.addLast((PropertyContainer)currentRelationship);
                path.addLast((PropertyContainer)currentNode);
            } else {
                path.addFirst((PropertyContainer)currentRelationship);
                path.addFirst((PropertyContainer)currentNode);
            }
            currentPreds = predecessors.get(currentNode);
        }
        return path;
    }

    public static List<List<Node>> constructAllPathsToNodeAsNodes(Node node, Map<Node, List<Relationship>> predecessors, boolean includeNode, boolean backwards) {
        return new LinkedList<List<Node>>(Util.constructAllPathsToNodeAsNodeLinkedLists(node, predecessors, includeNode, backwards));
    }

    protected static List<LinkedList<Node>> constructAllPathsToNodeAsNodeLinkedLists(Node node, Map<Node, List<Relationship>> predecessors, boolean includeNode, boolean backwards) {
        LinkedList<LinkedList<Node>> paths = new LinkedList<LinkedList<Node>>();
        List<Relationship> current = predecessors.get(node);
        if (current != null) {
            for (Relationship relationship : current) {
                Node n = relationship.getOtherNode(node);
                paths.addAll(Util.constructAllPathsToNodeAsNodeLinkedLists(n, predecessors, true, backwards));
            }
        }
        if (paths.isEmpty()) {
            paths.add(new LinkedList());
        }
        if (includeNode) {
            for (LinkedList linkedList : paths) {
                if (backwards) {
                    linkedList.addFirst(node);
                    continue;
                }
                linkedList.addLast(node);
            }
        }
        return paths;
    }

    public static List<List<PropertyContainer>> constructAllPathsToNode(Node node, Map<Node, List<Relationship>> predecessors, boolean includeNode, boolean backwards) {
        return new LinkedList<List<PropertyContainer>>(Util.constructAllPathsToNodeAsLinkedLists(node, predecessors, includeNode, backwards));
    }

    protected static List<LinkedList<PropertyContainer>> constructAllPathsToNodeAsLinkedLists(Node node, Map<Node, List<Relationship>> predecessors, boolean includeNode, boolean backwards) {
        LinkedList<LinkedList<PropertyContainer>> paths = new LinkedList<LinkedList<PropertyContainer>>();
        List<Relationship> current = predecessors.get(node);
        if (current != null) {
            for (Relationship relationship : current) {
                Node n = relationship.getOtherNode(node);
                List<LinkedList<PropertyContainer>> newPaths = Util.constructAllPathsToNodeAsLinkedLists(n, predecessors, true, backwards);
                paths.addAll(newPaths);
                for (LinkedList<PropertyContainer> path : newPaths) {
                    if (backwards) {
                        path.addFirst((PropertyContainer)relationship);
                        continue;
                    }
                    path.addLast((PropertyContainer)relationship);
                }
            }
        }
        if (paths.isEmpty()) {
            paths.add(new LinkedList());
        }
        if (includeNode) {
            for (LinkedList linkedList : paths) {
                if (backwards) {
                    linkedList.addFirst(node);
                    continue;
                }
                linkedList.addLast(node);
            }
        }
        return paths;
    }

    public static List<List<Relationship>> constructAllPathsToNodeAsRelationships(Node node, Map<Node, List<Relationship>> predecessors, boolean backwards) {
        return new LinkedList<List<Relationship>>(Util.constructAllPathsToNodeAsRelationshipLinkedLists(node, predecessors, backwards));
    }

    protected static List<LinkedList<Relationship>> constructAllPathsToNodeAsRelationshipLinkedLists(Node node, Map<Node, List<Relationship>> predecessors, boolean backwards) {
        LinkedList<LinkedList<Relationship>> paths = new LinkedList<LinkedList<Relationship>>();
        List<Relationship> current = predecessors.get(node);
        if (current != null) {
            for (Relationship r : current) {
                Node n = r.getOtherNode(node);
                List<LinkedList<Relationship>> newPaths = Util.constructAllPathsToNodeAsRelationshipLinkedLists(n, predecessors, backwards);
                paths.addAll(newPaths);
                for (LinkedList<Relationship> path : newPaths) {
                    if (backwards) {
                        path.addFirst(r);
                        continue;
                    }
                    path.addLast(r);
                }
            }
        }
        if (paths.isEmpty()) {
            paths.add(new LinkedList());
        }
        return paths;
    }

    public static Map<Node, List<Relationship>> reversedPredecessors(Map<Node, List<Relationship>> predecessors) {
        HashMap<Node, List<Relationship>> result = new HashMap<Node, List<Relationship>>();
        Set<Node> keys = predecessors.keySet();
        for (Node node : keys) {
            List<Relationship> preds = predecessors.get(node);
            for (Relationship relationship : preds) {
                Node otherNode = relationship.getOtherNode(node);
                LinkedList<Relationship> otherPreds = (LinkedList<Relationship>)result.get(otherNode);
                if (otherPreds == null) {
                    otherPreds = new LinkedList<Relationship>();
                    result.put(otherNode, otherPreds);
                }
                otherPreds.add(relationship);
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PathCounter {
        Map<Node, List<Relationship>> predecessors;
        Map<Node, Integer> pathCounts = new HashMap<Node, Integer>();

        public PathCounter(Map<Node, List<Relationship>> predecessors) {
            this.predecessors = predecessors;
        }

        public int getNumberOfPathsToNode(Node node) {
            Integer i = this.pathCounts.get(node);
            if (i != null) {
                return i;
            }
            List<Relationship> preds = this.predecessors.get(node);
            if (preds == null || preds.size() == 0) {
                return 1;
            }
            int result = 0;
            for (Relationship relationship : preds) {
                result += this.getNumberOfPathsToNode(relationship.getOtherNode(node));
            }
            this.pathCounts.put(node, result);
            return result;
        }
    }
}

