/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.impl.util.PathImpl;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.NestingIterator;
import org.neo4j.helpers.collection.PrefetchingIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortestPath
implements PathFinder<Path> {
    private final int maxDepth;
    private final RelationshipExpander relExpander;
    private final HitDecider hitDecider;
    private static final HitDecider YES_HIT_DECIDER = new HitDecider(){

        public boolean isHit(int depth) {
            return true;
        }
    };

    public ShortestPath(int maxDepth, RelationshipExpander relExpander) {
        this(maxDepth, relExpander, false);
    }

    public ShortestPath(int maxDepth, RelationshipExpander relExpander, boolean findPathsOnMaxDepthOnly) {
        this.maxDepth = maxDepth;
        this.relExpander = relExpander;
        this.hitDecider = findPathsOnMaxDepthOnly ? new DepthHitDecider(maxDepth) : YES_HIT_DECIDER;
    }

    @Override
    public Iterable<Path> findAllPaths(Node start, Node end) {
        return this.internalPaths(start, end, false);
    }

    @Override
    public Path findSinglePath(Node start, Node end) {
        Iterator<Path> paths = this.internalPaths(start, end, true).iterator();
        return paths.hasNext() ? paths.next() : null;
    }

    private Iterable<Path> internalPaths(Node start, Node end, boolean stopAsap) {
        if (start.equals(end)) {
            return Arrays.asList(PathImpl.singular(start));
        }
        Hits hits = new Hits();
        HashSet<Long> sharedVisitedRels = new HashSet<Long>();
        MutableInteger sharedFrozenDepth = new MutableInteger(-1);
        MutableBoolean sharedStop = new MutableBoolean();
        MutableInteger sharedCurrentDepth = new MutableInteger(0);
        DirectionData startData = new DirectionData(start, sharedVisitedRels, sharedFrozenDepth, sharedStop, sharedCurrentDepth, stopAsap, this.relExpander);
        DirectionData endData = new DirectionData(end, sharedVisitedRels, sharedFrozenDepth, sharedStop, sharedCurrentDepth, stopAsap, this.relExpander.reversed());
        while (startData.hasNext() || endData.hasNext()) {
            this.goOneStep(startData, endData, hits, stopAsap, startData);
            this.goOneStep(endData, startData, hits, stopAsap, startData);
        }
        Collection<Hit> least = hits.least();
        return least != null ? ShortestPath.hitsToPaths(least, start, end) : Collections.emptyList();
    }

    private void goOneStep(DirectionData directionData, DirectionData otherSide, Hits hits, boolean stopAsEarlyAsPossible, DirectionData startSide) {
        if (!directionData.hasNext()) {
            return;
        }
        Node nextNode = (Node)directionData.next();
        LevelData otherSideHit = (LevelData)otherSide.visitedNodes.get(nextNode);
        if (otherSideHit != null) {
            int depth = directionData.currentDepth + otherSideHit.depth;
            if (!this.hitDecider.isHit(depth)) {
                return;
            }
            if (directionData.sharedFrozenDepth.value == -1) {
                directionData.sharedFrozenDepth.value = depth;
            }
            if (depth <= directionData.sharedFrozenDepth.value) {
                directionData.haveFoundSomething = true;
                if (depth < directionData.sharedFrozenDepth.value) {
                    directionData.sharedFrozenDepth.value = depth;
                    otherSide.stop = true;
                    if (stopAsEarlyAsPossible) {
                        directionData.sharedStop.value = true;
                    }
                }
                DirectionData startSideData = directionData == startSide ? directionData : otherSide;
                DirectionData endSideData = directionData == startSide ? otherSide : directionData;
                hits.add(new Hit(startSideData, endSideData, nextNode), depth);
            }
        }
    }

    protected Collection<Node> filterNextLevelNodes(Collection<Node> nextNodes) {
        return nextNodes;
    }

    private static Iterable<Path> hitsToPaths(Collection<Hit> depthHits, Node start, Node end) {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (Hit hit : depthHits) {
            Iterable<LinkedList<Relationship>> startPaths = ShortestPath.getPaths(hit, hit.start);
            Iterable<LinkedList<Relationship>> endPaths = ShortestPath.getPaths(hit, hit.end);
            for (LinkedList<Relationship> startPath : startPaths) {
                PathImpl.Builder startBuilder = ShortestPath.toBuilder(start, startPath);
                for (LinkedList<Relationship> endPath : endPaths) {
                    PathImpl.Builder endBuilder = ShortestPath.toBuilder(end, endPath);
                    Path path = startBuilder.build(endBuilder);
                    paths.add(path);
                }
            }
        }
        return paths;
    }

    private static Iterable<LinkedList<Relationship>> getPaths(Hit hit, DirectionData data) {
        LevelData levelData = (LevelData)data.visitedNodes.get(hit.connectingNode);
        if (levelData.depth == 0) {
            ArrayList<LinkedList<Relationship>> result = new ArrayList<LinkedList<Relationship>>();
            result.add(new LinkedList());
            return result;
        }
        ArrayList<PathData> set = new ArrayList<PathData>();
        GraphDatabaseService graphDb = data.startNode.getGraphDatabase();
        for (long rel : levelData.relsToHere) {
            set.add(new PathData(hit.connectingNode, new LinkedList<Relationship>(Arrays.asList(graphDb.getRelationshipById(rel)))));
        }
        for (int i = 0; i < levelData.depth - 1; ++i) {
            ArrayList<PathData> nextSet = new ArrayList<PathData>();
            for (PathData entry : set) {
                int counter = 0;
                Node otherNode = ((Relationship)entry.rels.getFirst()).getOtherNode(entry.node);
                LevelData otherLevelData = (LevelData)data.visitedNodes.get(otherNode);
                for (long rel : otherLevelData.relsToHere) {
                    LinkedList rels = counter++ == 0 ? entry.rels : new LinkedList(entry.rels);
                    rels.addFirst(graphDb.getRelationshipById(rel));
                    nextSet.add(new PathData(otherNode, rels));
                }
            }
            set = nextSet;
        }
        return new IterableWrapper<LinkedList<Relationship>, PathData>(set){

            protected LinkedList<Relationship> underlyingObjectToObject(PathData object) {
                return object.rels;
            }
        };
    }

    private static PathImpl.Builder toBuilder(Node startNode, LinkedList<Relationship> rels) {
        PathImpl.Builder builder = new PathImpl.Builder(startNode);
        for (Relationship rel : rels) {
            builder = builder.push(rel);
        }
        return builder;
    }

    private static class DepthHitDecider
    implements HitDecider {
        private final int depth;

        DepthHitDecider(int depth) {
            this.depth = depth;
        }

        public boolean isHit(int depth) {
            return this.depth == depth;
        }
    }

    private static interface HitDecider {
        public boolean isHit(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathData {
        private final LinkedList<Relationship> rels;
        private final Node node;

        PathData(Node node, LinkedList<Relationship> rels) {
            this.rels = rels;
            this.node = node;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Hits {
        private Map<Integer, Collection<Hit>> hits = new HashMap<Integer, Collection<Hit>>();
        private int lowestDepth;

        private Hits() {
        }

        void add(Hit hit, int atDepth) {
            Collection<Hit> depthHits = this.hits.get(atDepth);
            if (depthHits == null) {
                depthHits = new HashSet<Hit>();
                this.hits.put(atDepth, depthHits);
            }
            depthHits.add(hit);
            if (this.lowestDepth == 0 || atDepth < this.lowestDepth) {
                this.lowestDepth = atDepth;
            }
        }

        Collection<Hit> least() {
            return this.hits.get(this.lowestDepth);
        }
    }

    private static class LevelData {
        private long[] relsToHere;
        private int depth;

        LevelData(Relationship relToHere, int depth) {
            if (relToHere != null) {
                this.addRel(relToHere);
            }
            this.depth = depth;
        }

        void addRel(Relationship rel) {
            long[] newRels = null;
            if (this.relsToHere == null) {
                newRels = new long[1];
            } else {
                newRels = new long[this.relsToHere.length + 1];
                System.arraycopy(this.relsToHere, 0, newRels, 0, this.relsToHere.length);
            }
            newRels[newRels.length - 1] = rel.getId();
            this.relsToHere = newRels;
        }
    }

    private static class MutableBoolean {
        private boolean value;

        private MutableBoolean() {
        }
    }

    private static class MutableInteger {
        private static final int NULL = -1;
        private int value;

        MutableInteger(int initialValue) {
            this.value = initialValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DirectionData
    extends PrefetchingIterator<Node> {
        private final Node startNode;
        private int currentDepth;
        private Iterator<Relationship> nextRelationships;
        private final Collection<Node> nextNodes = new ArrayList<Node>();
        private Map<Node, LevelData> visitedNodes = new HashMap<Node, LevelData>();
        private Node lastParentTraverserNode;
        private final MutableInteger sharedFrozenDepth;
        private final MutableBoolean sharedStop;
        private final MutableInteger sharedCurrentDepth;
        private boolean haveFoundSomething;
        private boolean stop;
        private final boolean stopAsap;
        private final RelationshipExpander expander;

        DirectionData(Node startNode, Collection<Long> sharedVisitedRels, MutableInteger sharedFrozenDepth, MutableBoolean sharedStop, MutableInteger sharedCurrentDepth, boolean stopAsap, RelationshipExpander expander) {
            this.startNode = startNode;
            this.visitedNodes.put(startNode, new LevelData(null, 0));
            this.nextNodes.add(startNode);
            this.sharedFrozenDepth = sharedFrozenDepth;
            this.sharedStop = sharedStop;
            this.sharedCurrentDepth = sharedCurrentDepth;
            this.stopAsap = stopAsap;
            this.expander = expander;
            this.prepareNextLevel();
        }

        private void prepareNextLevel() {
            ArrayList<Node> nodesToIterate = new ArrayList<Node>(ShortestPath.this.filterNextLevelNodes(this.nextNodes));
            this.nextNodes.clear();
            this.nextRelationships = new NestingIterator<Relationship, Node>(nodesToIterate.iterator()){

                protected Iterator<Relationship> createNestedIterator(Node node) {
                    DirectionData.this.lastParentTraverserNode = node;
                    return DirectionData.this.expander.expand(node).iterator();
                }
            };
            ++this.currentDepth;
            this.sharedCurrentDepth.value = this.sharedCurrentDepth.value + 1;
        }

        protected Node fetchNextOrNull() {
            Node result;
            boolean createdLevelData;
            do {
                Relationship nextRel;
                if ((nextRel = this.fetchNextRelOrNull()) == null) {
                    return null;
                }
                result = nextRel.getOtherNode(this.lastParentTraverserNode);
                LevelData levelData = this.visitedNodes.get(result);
                createdLevelData = false;
                if (levelData == null) {
                    levelData = new LevelData(nextRel, this.currentDepth);
                    this.visitedNodes.put(result, levelData);
                    createdLevelData = true;
                }
                if (this.currentDepth < levelData.depth) {
                    throw new RuntimeException("This shouldn't happen... I think");
                }
                if (this.stopAsap || this.currentDepth != levelData.depth || createdLevelData) continue;
                levelData.addRel(nextRel);
            } while (!createdLevelData);
            this.nextNodes.add(result);
            return result;
        }

        private boolean canGoDeeper() {
            return this.sharedFrozenDepth.value == -1 && this.sharedCurrentDepth.value < ShortestPath.this.maxDepth;
        }

        private Relationship fetchNextRelOrNull() {
            boolean hasComeTooFarEmptyHanded;
            boolean stopped = this.stop || this.sharedStop.value;
            boolean bl = hasComeTooFarEmptyHanded = this.sharedFrozenDepth.value != -1 && this.sharedCurrentDepth.value > this.sharedFrozenDepth.value && !this.haveFoundSomething;
            if (stopped || hasComeTooFarEmptyHanded) {
                return null;
            }
            if (!this.nextRelationships.hasNext() && this.canGoDeeper()) {
                this.prepareNextLevel();
            }
            return this.nextRelationships.hasNext() ? this.nextRelationships.next() : null;
        }
    }

    private static class Hit {
        private final DirectionData start;
        private final DirectionData end;
        private final Node connectingNode;

        Hit(DirectionData start, DirectionData end, Node connectingNode) {
            this.start = start;
            this.end = end;
            this.connectingNode = connectingNode;
        }

        public int hashCode() {
            return this.connectingNode.hashCode();
        }

        public boolean equals(Object obj) {
            Hit o = (Hit)obj;
            return this.connectingNode.equals(o.connectingNode);
        }
    }
}

