/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.impl.util.LiteDepthFirstSelector;
import org.neo4j.graphalgo.impl.util.PathImpl;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.BranchSelector;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExactDepthPathFinder
implements PathFinder<Path> {
    private final RelationshipExpander expander;
    private final int onDepth;
    private final int startThreshold;

    public ExactDepthPathFinder(RelationshipExpander expander, int onDepth, int startThreshold) {
        this.expander = expander;
        this.onDepth = onDepth;
        this.startThreshold = startThreshold;
    }

    @Override
    public Iterable<Path> findAllPaths(final Node start, final Node end) {
        return new Iterable<Path>(){

            @Override
            public Iterator<Path> iterator() {
                return ExactDepthPathFinder.this.paths(start, end);
            }
        };
    }

    @Override
    public Path findSinglePath(Node start, Node end) {
        Iterator<Path> paths = this.paths(start, end);
        return paths.hasNext() ? paths.next() : null;
    }

    private Iterator<Path> paths(final Node start, final Node end) {
        TraversalDescription base = Traversal.description().uniqueness((UniquenessFactory)Uniqueness.RELATIONSHIP_PATH).order(new BranchOrderingPolicy(){

            public BranchSelector create(TraversalBranch startSource) {
                return new LiteDepthFirstSelector(startSource, ExactDepthPathFinder.this.startThreshold);
            }
        });
        final int firstHalf = this.onDepth / 2;
        Traverser startTraverser = base.prune(Traversal.pruneAfterDepth((int)firstHalf)).expand(this.expander).filter((Predicate)new Predicate<Path>(){

            public boolean accept(Path item) {
                return item.length() == firstHalf;
            }
        }).traverse(start);
        final int secondHalf = this.onDepth - firstHalf;
        Traverser endTraverser = base.prune(Traversal.pruneAfterDepth((int)secondHalf)).expand(this.expander.reversed()).filter((Predicate)new Predicate<Path>(){

            public boolean accept(Path item) {
                return item.length() == secondHalf;
            }
        }).traverse(end);
        final Iterator startIterator = startTraverser.iterator();
        final Iterator endIterator = endTraverser.iterator();
        final HashMap visits = new HashMap();
        return new PrefetchingIterator<Path>(){

            protected Path fetchNextOrNull() {
                Path[] found = null;
                while (found == null && (startIterator.hasNext() || endIterator.hasNext())) {
                    found = ExactDepthPathFinder.this.goOneStep(start, startIterator, visits);
                    if (found != null) continue;
                    found = ExactDepthPathFinder.this.goOneStep(end, endIterator, visits);
                }
                return found != null ? ExactDepthPathFinder.this.toPath(found, start) : null;
            }
        };
    }

    private Path toPath(Path[] found, Node start) {
        Path startPath = found[0];
        Path endPath = found[1];
        if (!startPath.startNode().equals(start)) {
            Path tmpPath = startPath;
            startPath = endPath;
            endPath = tmpPath;
        }
        return this.toBuilder(startPath).build(this.toBuilder(endPath));
    }

    private PathImpl.Builder toBuilder(Path path) {
        PathImpl.Builder builder = new PathImpl.Builder(path.startNode());
        for (Relationship rel : path.relationships()) {
            builder = builder.push(rel);
        }
        return builder;
    }

    private Path[] goOneStep(Node node, Iterator<Path> visitor, Map<Node, Visit> visits) {
        if (!visitor.hasNext()) {
            return null;
        }
        Path position = visitor.next();
        Visit visit = visits.get(position.endNode());
        if (visit != null) {
            if (visitor != visit.visitor) {
                return new Path[]{visit.position, position};
            }
        } else {
            visits.put(position.endNode(), new Visit(position, visitor));
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Visit {
        private final Path position;
        private final Iterator<Path> visitor;

        Visit(Path position, Iterator<Path> visitor) {
            this.position = position;
            this.visitor = visitor;
        }
    }
}

