/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

import java.util.function.Function;
import org.neo4j.gqlstatus.SimpleMessageFormat;

final class FormatParameters
implements SimpleMessageFormat {
    private final String message;
    private final int[] offsets;
    private final Function<Object, String> formatter;

    FormatParameters(String message, int[] offsets, Function<Object, String> formatter) {
        assert (FormatParameters.isOffsetsInBounds(message, offsets));
        this.message = message;
        this.offsets = offsets;
        this.formatter = formatter;
    }

    private static boolean isOffsetsInBounds(String message, int[] offsets) {
        int length = message.length();
        for (int i = 0; i < offsets.length; ++i) {
            if (offsets[i] > length) {
                return false;
            }
            if (i <= 0 || offsets[i] >= offsets[i - 1]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String format(Object[] args) {
        int estimatedParamSize = 24 * this.offsets.length;
        return this.format(new StringBuilder(this.message.length() + estimatedParamSize), args).toString();
    }

    @Override
    public StringBuilder format(StringBuilder builder, Object[] args) {
        if (args == null) {
            args = new Object[]{};
        }
        int lastOffset = 0;
        for (int i = 0; i < this.offsets.length; ++i) {
            int currentOffset = this.offsets[i];
            builder.append(this.message, lastOffset, currentOffset);
            builder.append(this.formatter.apply(i < args.length ? args[i] : null));
            lastOffset = currentOffset;
        }
        if (lastOffset < this.message.length()) {
            builder.append(this.message, lastOffset, this.message.length());
        }
        return builder;
    }

    @Override
    public int parameterCount() {
        return this.offsets.length;
    }
}

