/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

import java.util.ArrayList;
import java.util.function.Function;
import org.neo4j.gqlstatus.FormatParameters;
import org.neo4j.gqlstatus.StaticMessage;

public interface SimpleMessageFormat {
    public static final Function<Object, String> TO_STRING_FORMATTER = new Function<Object, String>(){

        @Override
        public String apply(Object o) {
            return String.valueOf(o);
        }
    };

    public String format(Object[] var1);

    public StringBuilder format(StringBuilder var1, Object[] var2);

    public int parameterCount();

    public static SimpleMessageFormat compile(String template) {
        return SimpleMessageFormat.compile(template, TO_STRING_FORMATTER);
    }

    public static SimpleMessageFormat compile(String template, Function<Object, String> formatter) {
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        StringBuilder message = new StringBuilder();
        String substitution = "%s";
        int offset = 0;
        int prevOffset = 0;
        while ((offset = template.indexOf("%s", offset)) != -1) {
            message.append(template, prevOffset, offset);
            offsets.add(message.length());
            prevOffset = offset += "%s".length();
        }
        if (offsets.isEmpty()) {
            return new StaticMessage(template);
        }
        if (prevOffset < template.length()) {
            message.append(template, prevOffset, template.length());
        }
        return new FormatParameters(message.toString(), offsets.stream().mapToInt(o -> o).toArray(), formatter);
    }
}

