/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

import org.neo4j.annotations.api.PublicApi;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorMessageHolder;

@PublicApi
public abstract class GqlRuntimeException
extends RuntimeException
implements ErrorGqlStatusObject {
    private final ErrorGqlStatusObject innerGqlStatusObject;
    private final String oldMessage;

    protected GqlRuntimeException(String message, Throwable cause) {
        super(message, cause);
        this.innerGqlStatusObject = null;
        this.oldMessage = message;
    }

    protected GqlRuntimeException(ErrorGqlStatusObject gqlStatusObject, String message, Throwable cause) {
        super(ErrorMessageHolder.getMessage(gqlStatusObject, message), cause);
        this.innerGqlStatusObject = gqlStatusObject;
        this.oldMessage = message;
    }

    protected GqlRuntimeException(String message) {
        this(message, null);
    }

    protected GqlRuntimeException(ErrorGqlStatusObject gqlStatusObject, String message) {
        this(gqlStatusObject, message, null);
    }

    protected GqlRuntimeException(ErrorGqlStatusObject gqlStatusObject, Exception ex) {
        super(ErrorMessageHolder.getMessage(gqlStatusObject, ex.getMessage()));
        this.innerGqlStatusObject = gqlStatusObject;
        this.oldMessage = ErrorMessageHolder.getOldCauseMessage(ex);
    }

    protected GqlRuntimeException(String message, boolean suppression, boolean stacktrace) {
        super(message, null, suppression, stacktrace);
        this.innerGqlStatusObject = null;
        this.oldMessage = message;
    }

    protected GqlRuntimeException(ErrorGqlStatusObject gqlStatusObject, String message, boolean suppression, boolean stacktrace) {
        super(ErrorMessageHolder.getMessage(gqlStatusObject, message), null, suppression, stacktrace);
        this.innerGqlStatusObject = gqlStatusObject;
        this.oldMessage = message;
    }

    @Override
    public String legacyMessage() {
        return this.oldMessage;
    }

    @Override
    public ErrorGqlStatusObject gqlStatusObject() {
        return this.innerGqlStatusObject;
    }
}

