/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

import java.util.HashMap;
import java.util.Map;

public class DiagnosticRecord {
    private static final String CURRENT_SCHEMA_DEFAULT = "/";
    private static final String OPERATION_DEFAULT = "";
    private static final String OPERATION_CODE_DEFAULT = "0";
    private final Map<String, Object> innerDiagnosticRecord = new HashMap<String, Object>();

    public DiagnosticRecord(String severity, String classification, int offset, int line, int column, Map<String, Object> statusParameters) {
        this.innerDiagnosticRecord.put("CURRENT_SCHEMA", CURRENT_SCHEMA_DEFAULT);
        this.innerDiagnosticRecord.put("OPERATION", OPERATION_DEFAULT);
        this.innerDiagnosticRecord.put("OPERATION_CODE", OPERATION_CODE_DEFAULT);
        this.innerDiagnosticRecord.put("_severity", severity);
        this.innerDiagnosticRecord.put("_classification", classification);
        this.innerDiagnosticRecord.put("_position", Map.of("offset", offset, "line", line, "column", column));
        this.innerDiagnosticRecord.put("_status_parameters", statusParameters);
    }

    public DiagnosticRecord(String severity, String classification, int offset, int line, int column) {
        this.innerDiagnosticRecord.put("CURRENT_SCHEMA", CURRENT_SCHEMA_DEFAULT);
        this.innerDiagnosticRecord.put("OPERATION", OPERATION_DEFAULT);
        this.innerDiagnosticRecord.put("OPERATION_CODE", OPERATION_CODE_DEFAULT);
        this.innerDiagnosticRecord.put("_severity", severity);
        this.innerDiagnosticRecord.put("_classification", classification);
        this.innerDiagnosticRecord.put("_position", Map.of("offset", offset, "line", line, "column", column));
    }

    public DiagnosticRecord() {
        this.innerDiagnosticRecord.put("CURRENT_SCHEMA", CURRENT_SCHEMA_DEFAULT);
        this.innerDiagnosticRecord.put("OPERATION", OPERATION_DEFAULT);
        this.innerDiagnosticRecord.put("OPERATION_CODE", OPERATION_CODE_DEFAULT);
    }

    public void setStatusParameters(Map<String, Object> statusParameters) {
        this.innerDiagnosticRecord.put("_status_parameters", statusParameters);
    }

    public int hashCode() {
        return this.innerDiagnosticRecord.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiagnosticRecord that = (DiagnosticRecord)o;
        return this.innerDiagnosticRecord.equals(that.innerDiagnosticRecord);
    }

    public Map<String, Object> asMap() {
        return this.innerDiagnosticRecord;
    }
}

