/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

import java.util.List;
import java.util.Map;
import org.neo4j.gqlstatus.GqlParams;

public class SimpleMessageFormatter {
    public static String format(String template, String substitution, int[] offsets, Object[] params) {
        return SimpleMessageFormatter.format(null, null, template, substitution, offsets, params);
    }

    public static String format(GqlParams.GqlParam[] statusParameterKeys, Map<GqlParams.ListParam, GqlParams.JoinStyle> joinStyles, String template, String substitution, int[] offsets, Object[] params) {
        StringBuilder message = new StringBuilder();
        int currentParam = 0;
        int prevOffset = 0;
        for (int offset : offsets) {
            message.append(template, prevOffset, offset);
            String formattedParam = SimpleMessageFormatter.processParam(statusParameterKeys, joinStyles, params, currentParam++);
            message.append(formattedParam);
            prevOffset = offset += substitution.length();
        }
        if (prevOffset < template.length()) {
            message.append(template, prevOffset, template.length());
        }
        return message.toString();
    }

    private static String processParam(GqlParams.GqlParam[] statusParameterKeys, Map<GqlParams.ListParam, GqlParams.JoinStyle> joinStyles, Object[] params, int currentParam) {
        if (params == null) {
            return "null";
        }
        if (statusParameterKeys == null) {
            return String.valueOf(params[currentParam]);
        }
        GqlParams.GqlParam paramKey = statusParameterKeys[currentParam];
        if (paramKey instanceof GqlParams.ListParam) {
            GqlParams.ListParam key = (GqlParams.ListParam)paramKey;
            Object object = params[currentParam];
            if (object instanceof List) {
                List list = (List)object;
                GqlParams.JoinStyle joinStyle = joinStyles.get(paramKey);
                if (list.isEmpty()) {
                    return "nothing";
                }
                return key.process(list, joinStyle);
            }
        }
        return paramKey.process(params[currentParam]);
    }
}

