/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.neo4j.gqlstatus.CommonGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.DiagnosticRecord;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfo;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;

public class ErrorGqlStatusObjectImplementation
extends CommonGqlStatusObjectImplementation
implements ErrorGqlStatusObject {
    private boolean isCause = false;
    private ErrorGqlStatusObject cause;
    private final Map<GqlParams.GqlParam, Object> paramMap;
    private final GqlStatusInfoCodes gqlStatusInfoCode;

    private ErrorGqlStatusObjectImplementation(GqlStatusInfoCodes gqlStatusInfoCode, Map<GqlParams.GqlParam, Object> parameters, ErrorGqlStatusObject cause, DiagnosticRecord diagnosticRecord) {
        super((GqlStatusInfo)gqlStatusInfoCode, diagnosticRecord, parameters);
        this.gqlStatusInfoCode = gqlStatusInfoCode;
        this.cause = cause;
        this.paramMap = this.replaceNulls(parameters);
    }

    private Map<GqlParams.GqlParam, Object> replaceNulls(Map<GqlParams.GqlParam, Object> parameters) {
        return parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() == null ? "null" : e.getValue()));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ErrorGqlStatusObjectImplementation) {
            ErrorGqlStatusObjectImplementation gql = (ErrorGqlStatusObjectImplementation)obj;
            if (Objects.equals(this.gqlStatusInfoCode, gql.gqlStatusInfoCode) && Objects.equals(this.diagnosticRecord, gql.diagnosticRecord) && Objects.equals(this.cause, gql.cause) && Objects.equals(this.paramMap, gql.paramMap)) {
                return true;
            }
        }
        return false;
    }

    public static Builder from(GqlStatusInfoCodes gqlStatusInfo) {
        return new Builder(gqlStatusInfo);
    }

    @Override
    public Optional<ErrorGqlStatusObject> cause() {
        return Optional.ofNullable(this.cause);
    }

    public boolean isCause() {
        return this.isCause;
    }

    @Override
    public ErrorGqlStatusObject gqlStatusObject() {
        return this;
    }

    public void setCause(ErrorGqlStatusObject cause) {
        this.cause = cause;
    }

    public void markAsCause() {
        this.isCause = true;
    }

    @Override
    public void adjustPosition(int oldOffset, int oldLine, int oldColumn, int newOffset, int newLine, int newCol) {
        super.adjustPosition(oldOffset, oldLine, oldColumn, newOffset, newLine, newCol);
        this.cause().ifPresent(gqlStatusObjectCause -> {
            if (gqlStatusObjectCause instanceof ErrorGqlStatusObjectImplementation) {
                ErrorGqlStatusObjectImplementation errorGqlStatusObjectImplementation = (ErrorGqlStatusObjectImplementation)gqlStatusObjectCause;
                errorGqlStatusObjectImplementation.adjustPosition(oldOffset, oldLine, oldColumn, newOffset, newLine, newCol);
            }
        });
    }

    @Override
    public String getMessage() {
        String gqlMessagePart = this.gqlStatusInfoCode.getMessage(this.paramMap);
        if (!gqlMessagePart.isEmpty()) {
            return String.format("%s: %s", this.gqlStatus(), gqlMessagePart);
        }
        return this.gqlStatus();
    }

    @Override
    public String legacyMessage() {
        return "";
    }

    public String toString() {
        return this.recToString();
    }

    private String recToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("Status: ");
        sb.append(this.gqlStatusInfoCode.getStatusString().trim());
        sb.append("\n");
        sb.append("Message: ");
        sb.append(this.insertMessageParameters(this.paramMap).trim());
        sb.append("\n");
        sb.append("Subcondition: ");
        sb.append(this.gqlStatusInfoCode.getSubCondition().trim());
        if (this.cause != null) {
            sb.append("\n");
            sb.append("Caused by:");
            return sb.append(ErrorGqlStatusObjectImplementation.indent(4, this.cause.toString())).toString();
        }
        return sb.toString();
    }

    public static String indent(int n, String input) {
        String indent = " ".repeat(n);
        String[] lines = input.split("\n");
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(indent).append(line).append("\n");
        }
        if (!sb.isEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static class Builder {
        private ErrorGqlStatusObject cause = null;
        private Map<GqlParams.GqlParam, Object> paramMap = new HashMap<GqlParams.GqlParam, Object>();
        private final GqlStatusInfoCodes gqlStatusInfoCode;
        private final DiagnosticRecord.Builder diagnosticRecordBuilder = DiagnosticRecord.from();

        private Builder(GqlStatusInfoCodes gqlStatusInfo) {
            this.gqlStatusInfoCode = gqlStatusInfo;
        }

        public Builder withParam(GqlParams.StringParam param, String value) {
            if (value != null) {
                this.paramMap.put(param, value);
            }
            return this;
        }

        public Builder withParam(GqlParams.BooleanParam param, boolean value) {
            this.paramMap.put(param, value);
            return this;
        }

        public Builder withParam(GqlParams.NumberParam param, Number value) {
            if (value != null) {
                this.paramMap.put(param, value);
            }
            return this;
        }

        public Builder withParam(GqlParams.ListParam param, List<?> value) {
            if (value != null) {
                this.paramMap.put(param, value);
            }
            return this;
        }

        public Builder withCause(ErrorGqlStatusObject cause) {
            if (cause instanceof ErrorGqlStatusObjectImplementation) {
                ErrorGqlStatusObjectImplementation c = (ErrorGqlStatusObjectImplementation)cause;
                c.markAsCause();
            }
            this.cause = cause;
            return this;
        }

        public Builder withClassification(GqlClassification classification) {
            return this;
        }

        public Builder atPosition(int offset, int line, int col) {
            assert (line < 1 || line == 1 && col == offset + 1 || line > 1 && offset > col);
            this.diagnosticRecordBuilder.atPosition(offset, line, col);
            return this;
        }

        public ErrorGqlStatusObject build() {
            this.diagnosticRecordBuilder.withClassification(this.gqlStatusInfoCode.getClassification());
            DiagnosticRecord diagnosticRecord = this.diagnosticRecordBuilder.build();
            return new ErrorGqlStatusObjectImplementation(this.gqlStatusInfoCode, this.paramMap, this.cause, diagnosticRecord);
        }
    }
}

