/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.neo4j.gqlstatus.ErrorClassification;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.NotificationClassification;

public class DiagnosticRecord
implements Serializable {
    static final Map<String, Object> DEFAULT_DIAGNOSTIC_RECORD = new DiagnosticRecord().asMap();
    private static final String CURRENT_SCHEMA_DEFAULT = "/";
    private static final String OPERATION_DEFAULT = "";
    private static final String OPERATION_CODE_DEFAULT = "0";
    private final Map<String, Object> innerDiagnosticRecord = new HashMap<String, Object>();

    public static Builder from() {
        return new Builder();
    }

    public DiagnosticRecord(String severity, GqlClassification classification, int offset, int line, int column, Map<String, Object> statusParameters) {
        this.innerDiagnosticRecord.put("CURRENT_SCHEMA", CURRENT_SCHEMA_DEFAULT);
        this.innerDiagnosticRecord.put("OPERATION", OPERATION_DEFAULT);
        this.innerDiagnosticRecord.put("OPERATION_CODE", OPERATION_CODE_DEFAULT);
        this.innerDiagnosticRecord.put("_severity", severity);
        DiagnosticRecord.addClassificationToMap(classification, this.innerDiagnosticRecord);
        this.innerDiagnosticRecord.put("_position", Map.of("offset", offset, "line", line, "column", column));
    }

    public DiagnosticRecord(String severity, GqlClassification classification, int offset, int line, int column) {
        this.innerDiagnosticRecord.put("CURRENT_SCHEMA", CURRENT_SCHEMA_DEFAULT);
        this.innerDiagnosticRecord.put("OPERATION", OPERATION_DEFAULT);
        this.innerDiagnosticRecord.put("OPERATION_CODE", OPERATION_CODE_DEFAULT);
        this.innerDiagnosticRecord.put("_severity", severity);
        DiagnosticRecord.addClassificationToMap(classification, this.innerDiagnosticRecord);
        this.innerDiagnosticRecord.put("_position", Map.of("offset", offset, "line", line, "column", column));
    }

    public DiagnosticRecord() {
        this.innerDiagnosticRecord.put("CURRENT_SCHEMA", CURRENT_SCHEMA_DEFAULT);
        this.innerDiagnosticRecord.put("OPERATION", OPERATION_DEFAULT);
        this.innerDiagnosticRecord.put("OPERATION_CODE", OPERATION_CODE_DEFAULT);
    }

    private DiagnosticRecord(Map<String, Object> jsonMap) {
        Optional<Object> CURRENT_SCHEMA = Optional.ofNullable(jsonMap.get("CURRENT_SCHEMA"));
        Optional<Object> OPERATION = Optional.ofNullable(jsonMap.get("OPERATION"));
        Optional<Object> OPERATION_CODE = Optional.ofNullable(jsonMap.get("OPERATION_CODE"));
        Optional<Object> _severity = Optional.ofNullable(jsonMap.get("_severity"));
        Optional<Object> _classification = Optional.ofNullable(jsonMap.get("_classification"));
        Optional<Object> _position = Optional.ofNullable(jsonMap.get("_position"));
        Optional<Object> _status_parameters = Optional.ofNullable(jsonMap.get("_status_parameters"));
        this.innerDiagnosticRecord.put("CURRENT_SCHEMA", CURRENT_SCHEMA.orElse(CURRENT_SCHEMA_DEFAULT));
        this.innerDiagnosticRecord.put("OPERATION", OPERATION.orElse(OPERATION_DEFAULT));
        this.innerDiagnosticRecord.put("OPERATION_CODE", OPERATION_CODE.orElse(OPERATION_CODE_DEFAULT));
        _severity.ifPresent(s -> this.innerDiagnosticRecord.put("_severity", s));
        _classification.ifPresent(c -> this.innerDiagnosticRecord.put("_classification", c));
        _position.ifPresent(p -> this.innerDiagnosticRecord.put("_position", p));
    }

    public void setStatusParameters(Map<String, Object> statusParameters) {
    }

    boolean hasPosition() {
        return this.innerDiagnosticRecord.containsKey("_position");
    }

    Map<String, Integer> getPositionMap() {
        return (Map)this.innerDiagnosticRecord.get("_position");
    }

    public void updatePosition(int offset, int line, int column) {
        this.innerDiagnosticRecord.put("_position", Map.of("offset", offset, "line", line, "column", column));
    }

    public int hashCode() {
        return this.innerDiagnosticRecord.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiagnosticRecord that = (DiagnosticRecord)o;
        return this.innerDiagnosticRecord.equals(that.innerDiagnosticRecord);
    }

    public Map<String, Object> asMap() {
        return Collections.unmodifiableMap(this.innerDiagnosticRecord);
    }

    private static void addClassificationToMap(GqlClassification classification, Map<String, Object> map) {
        if (classification != ErrorClassification.UNKNOWN && classification != NotificationClassification.UNKNOWN) {
            map.put("_classification", String.valueOf(classification));
        }
    }

    public Optional<String> asJson() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            String json = mapper.writeValueAsString(this.innerDiagnosticRecord);
            return Optional.of(json);
        }
        catch (JsonProcessingException e) {
            return Optional.empty();
        }
    }

    public static Optional<DiagnosticRecord> fromJson(String json) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map parsed = (Map)mapper.readValue(json, Map.class);
            return Optional.of(new DiagnosticRecord(parsed));
        }
        catch (JsonProcessingException e) {
            return Optional.empty();
        }
    }

    public static class Builder {
        private final Map<String, Object> innerDiagnosticRecord = new HashMap<String, Object>();

        private Builder() {
            this.innerDiagnosticRecord.put("CURRENT_SCHEMA", DiagnosticRecord.CURRENT_SCHEMA_DEFAULT);
            this.innerDiagnosticRecord.put("OPERATION", DiagnosticRecord.OPERATION_DEFAULT);
            this.innerDiagnosticRecord.put("OPERATION_CODE", DiagnosticRecord.OPERATION_CODE_DEFAULT);
        }

        public Builder atPosition(int offset, int line, int column) {
            this.innerDiagnosticRecord.put("_position", Map.of("offset", offset, "line", line, "column", column));
            return this;
        }

        public Builder withClassification(GqlClassification classification) {
            DiagnosticRecord.addClassificationToMap(classification, this.innerDiagnosticRecord);
            return this;
        }

        public Builder withSeverity(String severity) {
            this.innerDiagnosticRecord.put("_severity", severity);
            return this;
        }

        public DiagnosticRecord build() {
            return new DiagnosticRecord(this.innerDiagnosticRecord);
        }
    }
}

