/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.util;

import com.fasterxml.jackson.databind.JsonNode;
import org.neo4j.genai.vector.MalformedGenAIResponseException;

public class CheckedAccessors {
    private CheckedAccessors() {
    }

    public static class Json {
        private Json() {
        }

        public static JsonNode getExpectedFrom(String provider, JsonNode json, String property) throws MalformedGenAIResponseException {
            try {
                if (!json.isObject()) {
                    throw Json.isNotObjectNode("provided json node");
                }
                return json.required(property);
            }
            catch (IllegalArgumentException e) {
                throw Json.doesNotExist(provider, property, e);
            }
        }

        public static JsonNode getExpectedFrom(String provider, JsonNode json, String ... properties) throws MalformedGenAIResponseException {
            Object parent = "provided json node";
            for (String property : properties) {
                if (!json.isObject()) {
                    throw Json.isNotObjectNode((String)parent);
                }
                json = Json.getExpectedFrom(provider, json, property);
                parent = "'" + property + "'";
            }
            return json;
        }

        private static MalformedGenAIResponseException isNotObjectNode(String parent) {
            return new MalformedGenAIResponseException("Expected %s to be an object".formatted(parent));
        }

        private static MalformedGenAIResponseException doesNotExist(String provider, String property, Throwable cause) {
            return new MalformedGenAIResponseException("'%s' is expected to exist in the response from %s".formatted(property, provider), cause);
        }
    }
}

