/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends FilterInputStream {
    private final long expected;
    private long count;

    public LimitedInputStream(InputStream in, long expected) {
        super(in);
        this.expected = expected;
    }

    @Override
    public int read() throws IOException {
        return this.check(super.read());
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.check(super.read(b, off, len));
    }

    private int check(int read) throws IOException {
        if ((this.count += (long)read) > this.expected) {
            throw new IOException("Stream reads exceeded maximum expected number of bytes %d B".formatted(this.expected));
        }
        return read;
    }
}

