/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableInt;
import org.neo4j.genai.util.CheckedAccessors;
import org.neo4j.genai.vector.MalformedGenAIResponseException;
import org.neo4j.genai.vector.VectorEncoding;

public class JsonResponseParser {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<float[]> VECTOR_TYPE_REFERENCE = new TypeReference<float[]>(){};

    public static Stream<VectorEncoding.BatchRow> parseResponse(String name, String topLevelKey, String[] properties, List<String> resources, InputStream inputStream, int[] nullIndexes) throws MalformedGenAIResponseException {
        JsonNode tree;
        try {
            tree = OBJECT_MAPPER.readTree(inputStream);
        }
        catch (IOException e) {
            throw new MalformedGenAIResponseException("Unexpected error occurred while parsing the API response", e);
        }
        JsonNode predictions = JsonResponseParser.getExpectedFrom(name, tree, topLevelKey);
        if (!predictions.isArray()) {
            throw new MalformedGenAIResponseException("Expected response to contain an array of embeddings");
        }
        if (predictions.size() != resources.size()) {
            throw new MalformedGenAIResponseException("Expected to receive %d embeddings; however got %d".formatted(resources.size(), predictions.size()));
        }
        MutableInt offset = new MutableInt();
        return IntStream.range(0, resources.size() + nullIndexes.length).mapToObj(index -> {
            VectorEncoding.BatchRow batchRow;
            block13: {
                if (Arrays.binarySearch(nullIndexes, index) >= 0) {
                    offset.increment();
                    return new VectorEncoding.BatchRow(index, null, null);
                }
                int offsetIndex = index - offset.intValue();
                JsonNode embedding = JsonResponseParser.getExpectedFrom(name, predictions.get(offsetIndex), properties);
                if (!embedding.isArray()) {
                    throw new MalformedGenAIResponseException("Expected embedding to be an array");
                }
                JsonParser parser = embedding.traverse((ObjectCodec)OBJECT_MAPPER);
                try {
                    batchRow = new VectorEncoding.BatchRow(index, (String)resources.get(offsetIndex), (float[])parser.readValueAs(VECTOR_TYPE_REFERENCE));
                    if (parser == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new MalformedGenAIResponseException("Unexpected error occurred while parsing the embedding", e);
                        }
                    }
                    catch (Throwable throwable3) {
                        throw new RuntimeException(throwable3);
                    }
                }
                parser.close();
            }
            return batchRow;
        });
    }

    private static JsonNode getExpectedFrom(String name, JsonNode json, String ... properties) throws MalformedGenAIResponseException {
        return CheckedAccessors.Json.getExpectedFrom(name, json, properties);
    }
}

