/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.api.multimap.list.MutableListMultimap;
import org.eclipse.collections.impl.factory.Multimaps;
import org.neo4j.genai.util.Client;
import org.neo4j.genai.util.GenAIProcedureException;
import org.neo4j.genai.util.LimitedInputStream;
import org.neo4j.genai.vector.MalformedGenAIResponseException;
import org.neo4j.genai.vector.VectorEncoding;

public class HttpClient
implements Client {
    private static final String USER_AGENT = "Neo4j-GenAIProcedures/" + VectorEncoding.VERSION;

    public Multimap<String, String> prepareRequestProperties(String host, Multimap<String, String> properties) {
        MutableListMultimap requestProperties = Multimaps.mutable.list.with((Object)"Host", (Object)host, (Object)"User-Agent", (Object)USER_AGENT);
        requestProperties.putAll(properties);
        return requestProperties.toImmutable();
    }

    @Override
    public InputStream sendRequest(URI uri, Multimap<String, String> properties, Client.Payload payload) throws IOException, GenAIProcedureException {
        return this.sendRequest(this.openConnection(uri, this.prepareRequestProperties(uri.getHost(), properties)), payload);
    }

    InputStream sendRequest(HttpURLConnection connection, Client.Payload payload) throws IOException, GenAIProcedureException {
        connection.setDoOutput(true);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8));){
            payload.writeTo(writer);
        }
        int responseCode = connection.getResponseCode();
        if (responseCode == 401) {
            throw new GenAIProcedureException("Not authorized to make API request; check your credentials.");
        }
        if (responseCode != 200) {
            String responseMessage = connection.getResponseMessage();
            String responseBody = new String(connection.getErrorStream().readAllBytes(), StandardCharsets.UTF_8);
            throw new MalformedGenAIResponseException("Unexpected HTTP response code: %d %s - %s".formatted(responseCode, responseMessage, responseBody));
        }
        InputStream responseStream = connection.getInputStream();
        long contentLength = connection.getContentLengthLong();
        return contentLength > 0L ? new LimitedInputStream(responseStream, contentLength) : responseStream;
    }

    private HttpURLConnection openConnection(URI uri, Multimap<String, String> properties) throws IOException {
        URLConnection uRLConnection = uri.toURL().openConnection();
        if (!(uRLConnection instanceof HttpURLConnection)) {
            throw new IllegalArgumentException("Not a HTTP(S) URI: %s".formatted(uri));
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        connection.setRequestMethod("POST");
        connection.setInstanceFollowRedirects(true);
        properties.forEachKeyValue(connection::setRequestProperty);
        return connection;
    }
}

