/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.vector.providers.openai;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.OptionalLong;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.MutableMap;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.genai.util.HttpService;
import org.neo4j.genai.util.JsonUtils;
import org.neo4j.genai.util.MalformedGenAIResponseException;
import org.neo4j.genai.vector.VectorEncoding;
import org.neo4j.util.VisibleForTesting;

public abstract class OpenAIBasedEncoder
implements VectorEncoding.Provider.Encoder {
    private static final String ENCODING_FORMAT = "float";
    private final URI endpoint;
    private final String providerName;
    private final OptionalLong dimensions;

    protected HttpRequest.Builder customize(HttpRequest.Builder builder) {
        return builder;
    }

    protected void extendPayload(MutableMap<String, Object> payload) {
    }

    protected OpenAIBasedEncoder(String providerName, URI endpoint, OptionalLong dimensions) {
        this.providerName = providerName;
        this.endpoint = endpoint;
        this.dimensions = dimensions;
    }

    @Override
    public float[] encode(HttpService httpService, String data) {
        return this.encode(httpService, List.of(data), ArrayUtils.EMPTY_INT_ARRAY).findFirst().orElseThrow().vector();
    }

    @Override
    public Stream<VectorEncoding.BatchRow> encode(HttpService httpService, List<String> resources, int[] nullIndexes) {
        return httpService.request(this.endpoint, builder -> this.customize(builder.headers("Content-Type", "application/json; charset=" + String.valueOf(StandardCharsets.UTF_8), "Accept", "application/json").POST(HttpService.pipe((ThrowingConsumer<OutputStream, IOException>)((ThrowingConsumer)outputStream -> this.writeRequestPayload((OutputStream)outputStream, resources))))).build(), inputStream -> this.parseResponse(resources, (InputStream)inputStream, nullIndexes));
    }

    private Stream<VectorEncoding.BatchRow> parseResponse(List<String> resources, InputStream inputStream, int[] nullIndexes) {
        return OpenAIBasedEncoder.parseResponse(this.providerName, resources, inputStream, nullIndexes);
    }

    @VisibleForTesting
    public static Stream<VectorEncoding.BatchRow> parseResponse(String providerName, List<String> resources, InputStream inputStream, int[] nullIndexes) throws MalformedGenAIResponseException {
        String[] properties = new String[]{"embedding"};
        return JsonUtils.parseResponse(providerName, "data", properties, resources, inputStream, nullIndexes);
    }

    private Object buildPayload(List<String> resources) {
        MutableMap payload = Maps.mutable.of((Object)"input", resources, (Object)"encoding_format", (Object)ENCODING_FORMAT);
        this.dimensions.ifPresent(d -> payload.put((Object)"dimensions", (Object)d));
        this.extendPayload((MutableMap<String, Object>)payload);
        return payload;
    }

    private void writeRequestPayload(OutputStream out, List<String> resources) {
        try {
            JsonUtils.getObjectMapper().writeValue(out, this.buildPayload(resources));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

