/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.util.provider;

import java.util.Arrays;
import java.util.List;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.multimap.list.ImmutableListMultimap;
import org.neo4j.genai.ai.text.completion.TextCompletion;
import org.neo4j.genai.util.provider.NamedProvider;
import org.neo4j.util.Preconditions;

public interface GlobalProviders {
    public <T extends NamedProvider> ImmutableList<T> providers(Class<T> var1);

    default public <T extends NamedProvider> List<String> providerNames(Class<T> type) {
        return this.providers(type).stream().map(NamedProvider::name).toList();
    }

    public static GlobalProviders from(NamedProvider ... providers) {
        Preconditions.checkArgument((boolean)GlobalProviders.namesAreUnique(providers), (String)"Provider names are not unique");
        final ImmutableListMultimap providersByType = Lists.immutable.of((Object[])providers).groupBy(GlobalProviders::findType);
        return new GlobalProviders(){

            @Override
            public <T extends NamedProvider> ImmutableList<T> providers(Class<T> type) {
                return providersByType.get(type).collect(type::cast);
            }
        };
    }

    private static Class findType(NamedProvider provider) {
        if (provider instanceof TextCompletion.Provider) {
            return TextCompletion.Provider.class;
        }
        throw new IllegalArgumentException("Unknown provider type: " + String.valueOf(provider.getClass()));
    }

    private static boolean namesAreUnique(NamedProvider ... providers) {
        String[] names = (String[])Arrays.stream(providers).map(NamedProvider::name).toArray(String[]::new);
        Arrays.sort(names, String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < names.length - 1; ++i) {
            if (String.CASE_INSENSITIVE_ORDER.compare(names[i], names[i + 1]) != 0) continue;
            return false;
        }
        return true;
    }
}

