/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.dbs;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.collections.api.factory.primitive.IntObjectMaps;
import org.eclipse.collections.api.factory.primitive.IntSets;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.neo4j.genai.dbs.CollectionNotFoundException;
import org.neo4j.genai.dbs.EntityMappingConfig;
import org.neo4j.genai.dbs.InvalidUsageException;
import org.neo4j.genai.dbs.ProviderResolver;
import org.neo4j.genai.dbs.RequestConfig;
import org.neo4j.genai.dbs.RowMappingConfig;
import org.neo4j.genai.dbs.VectorDatabaseProvider;
import org.neo4j.genai.dbs.VectorDatabaseRequest;
import org.neo4j.genai.util.GenAIProcedureException;
import org.neo4j.genai.util.HttpService;
import org.neo4j.genai.util.monitor.Monitors;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Internal;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.Sensitive;
import org.neo4j.service.Services;

public class VectorDatabases {
    private static final List<ProviderResolver> PROVIDER_RESOLVER = Services.loadAll(ProviderResolver.class).stream().sorted(Comparator.comparing(ProviderResolver::getOrder)).toList();
    private static final IntSet HTTP_OK = IntSets.immutable.of(200);
    @Context
    public Monitors monitors;
    @Context
    public Transaction tx;
    @Context
    public ProcedureCallContext procedureCallContext;
    @Context
    public HttpService httpService;

    @Internal
    @Procedure(name="genai.vector.external.listProviders")
    @Description(value="Lists the available vector database providers.")
    public Stream<ProviderDTO> listProviders() {
        return ProviderResolver.KNOWN_PROVIDERS.keySet().stream().map(ProviderDTO::new);
    }

    @Internal
    @Procedure(value="genai.vector.external.info")
    @Description(value="Get information about an existing collection or throws an error if it does not exist.\n\nIn Neo4j-Browser you can declare the configuration parameter as shown in the following examples.\nAuthorization can be configured either through a simple `token` entry in the config map like this:\n```\n:param configuration => ({token: 'your-api-key'})\n```\n\nOr if your vendor has an usual format, via a map entry under the key `Headers` in the configuration parameter.\nThe example uses a bearer token:\n```\n:param configuration => ({Headers: {Authorization: 'Bearer whatever'}})\n```\n")
    public Stream<InfoDTO> info(@Name(value="url") String url, @Name(value="collection") String collection, @Sensitive @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        VectorDatabaseProvider provider = this.getVectorDatabaseProvider(url);
        this.monitors.vectorDb().info(provider.getName());
        String finalHost = this.translateDefaultHost(provider, VectorDatabaseProvider.Command.GET_COLLECTION_METADATA, url, collection, configuration);
        VectorDatabaseRequest request = provider.createRequestFor(VectorDatabaseProvider.Command.GET_COLLECTION_METADATA, finalHost, collection, configuration, Map.of());
        return Stream.of((InfoDTO)this.httpService.request(request.target(), request.requestCustomizer(), request.responseTransformer(), HTTP_OK, (IntObjectMap<Supplier<GenAIProcedureException>>)IntObjectMaps.immutable.of(404, () -> new CollectionNotFoundException(collection)), provider.getProviderSpecificStatusHandler(collection)));
    }

    private VectorDatabaseProvider getVectorDatabaseProvider(String url) {
        for (ProviderResolver resolver : PROVIDER_RESOLVER) {
            Optional<VectorDatabaseProvider> resolvedProvider = resolver.resolve(url);
            if (!resolvedProvider.isPresent()) continue;
            return resolvedProvider.get();
        }
        throw new GenAIProcedureException("Resolving the host '%s' to a provider was not possible".formatted(url));
    }

    @Internal
    @Procedure(value="genai.vector.external.createCollection")
    @Description(value="Creates a named collection.\n\nIn Neo4j-Browser you can declare the configuration parameter as shown in the following examples.\nAuthorization can be configured either through a simple `token` entry in the config map like this:\n```\n:param configuration => ({token: 'your-api-key'})\n```\n\nOr if your vendor has an usual format, via a map entry under the key `Headers` in the configuration parameter.\nThe example uses a bearer token:\n```\n:param configuration => ({Headers: {Authorization: 'Bearer whatever'}})\n```\n")
    public Stream<StatusDTO> createCollection(@Name(value="url") String url, @Name(value="collection") String collection, @Name(value="similarity") String similarity, @Name(value="size") Long size, @Sensitive @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        Map<String, Object> additionalArguments = Map.of("similarity", similarity, "size", size);
        VectorDatabaseProvider provider = this.getVectorDatabaseProvider(url);
        this.monitors.vectorDb().createCollection(provider.getName());
        String finalHost = this.translateDefaultHost(provider, VectorDatabaseProvider.Command.CREATE_COLLECTION, url, collection, configuration);
        VectorDatabaseRequest request = provider.createRequestFor(VectorDatabaseProvider.Command.CREATE_COLLECTION, finalHost, collection, configuration, additionalArguments);
        return Stream.of((StatusDTO)this.httpService.request(request.target(), request.requestCustomizer(), request.responseTransformer(), (IntSet)IntSets.immutable.of(new int[]{200, 201}), (IntObjectMap<Supplier<GenAIProcedureException>>)IntObjectMaps.immutable.empty(), provider.getProviderSpecificStatusHandler(collection)));
    }

    @Internal
    @Procedure(value="genai.vector.external.deleteCollection")
    @Description(value="Deletes a named collection.\n\nIn Neo4j-Browser you can declare the configuration parameter as shown in the following examples.\nAuthorization can be configured either through a simple `token` entry in the config map like this:\n```\n:param configuration => ({token: 'your-api-key'})\n```\n\nOr if your vendor has an usual format, via a map entry under the key `Headers` in the configuration parameter.\nThe example uses a bearer token:\n```\n:param configuration => ({Headers: {Authorization: 'Bearer whatever'}})\n```\n")
    public Stream<StatusDTO> deleteCollection(@Name(value="url") String url, @Name(value="collection") String collection, @Sensitive @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        VectorDatabaseProvider provider = this.getVectorDatabaseProvider(url);
        this.monitors.vectorDb().deleteCollection(provider.getName());
        String finalHost = this.translateDefaultHost(provider, VectorDatabaseProvider.Command.DELETE_COLLECTION, url, collection, configuration);
        VectorDatabaseRequest request = provider.createRequestFor(VectorDatabaseProvider.Command.DELETE_COLLECTION, finalHost, collection, configuration, Map.of());
        return Stream.of((StatusDTO)this.httpService.request(request.target(), request.requestCustomizer(), request.responseTransformer(), (IntSet)IntSets.immutable.of(new int[]{200, 202, 204}), (IntObjectMap<Supplier<GenAIProcedureException>>)IntObjectMaps.immutable.empty(), provider.getProviderSpecificStatusHandler(collection)));
    }

    @Internal
    @Procedure(value="genai.vector.external.delete")
    @Description(value="Deletes the vectors with the specified `ids` from the given collection\n\nIn Neo4j-Browser you can declare the configuration parameter as shown in the following examples.\nAuthorization can be configured either through a simple `token` entry in the config map like this:\n```\n:param configuration => ({token: 'your-api-key'})\n```\n\nOr if your vendor has an usual format, via a map entry under the key `Headers` in the configuration parameter.\nThe example uses a bearer token:\n```\n:param configuration => ({Headers: {Authorization: 'Bearer whatever'}})\n```\n")
    public Stream<StatusDTO> delete(@Name(value="url") String url, @Name(value="collection") String collection, @Name(value="ids") List<Object> ids, @Sensitive @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        VectorDatabaseProvider provider = this.getVectorDatabaseProvider(url);
        this.monitors.vectorDb().deleteVector(provider.getName());
        String finalHost = this.translateDefaultHost(provider, VectorDatabaseProvider.Command.DELETE, url, collection, configuration);
        VectorDatabaseRequest request = provider.createRequestFor(VectorDatabaseProvider.Command.DELETE, finalHost, collection, configuration, Map.of("ids", ids));
        return Stream.of((StatusDTO)this.httpService.request(request.target(), request.requestCustomizer(), request.responseTransformer(), (IntSet)IntSets.immutable.of(new int[]{200, 204})));
    }

    @Internal
    @Procedure(value="genai.vector.external.get")
    @Description(value="Retrieves the vectors with the specified `ids` from the given collection.\n\nIn Neo4j-Browser you can declare the configuration parameter as shown in the following examples.\nAuthorization can be configured either through a simple `token` entry in the config map like this:\n```\n:param configuration => ({token: 'your-api-key'})\n```\n\nOr if your vendor has an usual format, via a map entry under the key `Headers` in the configuration parameter.\nThe example uses a bearer token:\n```\n:param configuration => ({Headers: {Authorization: 'Bearer whatever'}})\n```\n")
    public Stream<EmbeddingResult> get(@Name(value="url") String url, @Name(value="collection") String collection, @Name(value="ids") List<Object> ids, @Sensitive @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.getAndUpdate0(url, collection, ids, configuration, true);
    }

    @Internal
    @Procedure(value="genai.vector.external.getAndUpdate", mode=Mode.WRITE)
    @Description(value="Retrieves the vectors with the specified `ids` from the given collection and updates existing Neo4j entities(Nodes or relationships).\nIn Neo4j-Browser you can declare the configuration parameter as shown in the following examples.\n\nThe mapping between vectors and entities is configured via a map entry under the key `mapping` in the configuration parameter.\n```\n:param configuration => ({mapping: {embeddingKey: 'the_property_storing_the_vector', nodeLabel: 'TheLabel', entityKey: 'the_property_storing_the_mapping_key', metadataKey: ' the_property_stored_with_the_vector_in_the_vendor_db_matching_the_entity_key'}})\n```\n\nAuthorization can be configured either through a simple `token` entry in the config map like this:\n```\n:param configuration => ({token: 'your-api-key'})\n```\n\nOr if your vendor has an usual format, via a map entry under the key `Headers` in the configuration parameter.\nThe example uses a bearer token:\n```\n:param configuration => ({Headers: {Authorization: 'Bearer whatever'}})\n```\n\n*NOTE* The name of this procedure is subject to change.\n")
    public Stream<EmbeddingResult> getAndUpdate(@Name(value="url") String url, @Name(value="collection") String collection, @Name(value="ids") List<Object> ids, @Sensitive @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.getAndUpdate0(url, collection, ids, configuration, null);
    }

    private Stream<EmbeddingResult> getAndUpdate0(String url, String collection, List<Object> ids, Map<String, Object> configuration, Boolean forceReadOnly) {
        RowMappingConfig rowMappingConfig = RowMappingConfig.of(configuration);
        EntityMappingConfig mappingConfig = EntityMappingConfig.of(RowMappingConfig.Keys.MAPPING.get(Map.class, configuration), forceReadOnly);
        ProcedureArguments procedureArguments = ProcedureArguments.of(configuration, this.procedureCallContext);
        VectorDatabaseProvider provider = this.getVectorDatabaseProvider(url);
        this.monitors.vectorDb().getVector(provider.getName());
        String finalHost = this.translateDefaultHost(provider, VectorDatabaseProvider.Command.GET, url, collection, configuration);
        if (provider.supportsMultipleGet()) {
            VectorDatabaseRequest request2 = provider.createRequestFor(VectorDatabaseProvider.Command.GET, finalHost, collection, configuration, Map.of("ids", ids, "procedureArguments", procedureArguments, "rowMappingConfig", rowMappingConfig));
            return ((Stream)this.httpService.request(request2.target(), request2.requestCustomizer(), request2.responseTransformer())).map(m -> this.toEmbeddingResult((Map<String, Object>)m, procedureArguments, rowMappingConfig, mappingConfig));
        }
        return ids.stream().map(id -> provider.createRequestFor(VectorDatabaseProvider.Command.GET, finalHost, collection, configuration, Map.of("id", id, "procedureArguments", procedureArguments, "rowMappingConfig", rowMappingConfig))).map(request -> (Map)this.httpService.request(request.target(), request.requestCustomizer(), request.responseTransformer())).map(m -> this.toEmbeddingResult((Map<String, Object>)m, procedureArguments, rowMappingConfig, mappingConfig));
    }

    @Internal
    @Procedure(value="genai.vector.external.upsert")
    @Description(value="Creates or updates the vectors in the given collection.\nDepending on the provider, this procedure will issue more than one request.\nIn Neo4j-Browser you can declare the configuration parameter as shown in the following examples.\n\nVectors need to be specified like this:\n```\n:param vector => ({id: 'optional_id', vector: [0.1, 0.2, 0.3], metadata: {field1: 'value1', field2: 'value2'}})\n```\n\nAuthorization can be configured either through a simple `token` entry in the config map like this:\n```\n:param configuration => ({token: 'your-api-key'})\n```\n\nOr if your vendor has an usual format, via a map entry under the key `Headers` in the configuration parameter.\nThe example uses a bearer token:\n```\n:param configuration => ({Headers: {Authorization: 'Bearer whatever'}})\n```\n")
    public Stream<StatusDTO> upsert(@Name(value="url") String url, @Name(value="collection") String collection, @Name(value="vectors") List<Map<String, Object>> vectors, @Sensitive @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        VectorDatabaseProvider provider = this.getVectorDatabaseProvider(url);
        this.monitors.vectorDb().upsert(provider.getName());
        String finalHost = this.translateDefaultHost(provider, VectorDatabaseProvider.Command.UPSERT, url, collection, configuration);
        if (provider.supportsMultipleUpserts()) {
            Map<String, Object> additionalArguments = Map.of("vectors", vectors);
            VectorDatabaseRequest request = provider.createRequestFor(VectorDatabaseProvider.Command.UPSERT, finalHost, collection, configuration, additionalArguments);
            return Stream.of((StatusDTO)this.httpService.request(request.target(), request.requestCustomizer(), request.responseTransformer()));
        }
        for (Map<String, Object> vector : vectors) {
            try {
                VectorDatabaseRequest request = provider.createRequestFor(VectorDatabaseProvider.Command.UPSERT, finalHost, collection, configuration, Map.of("vector", vector));
                this.httpService.request(request.target(), request.requestCustomizer(), request.responseTransformer());
            }
            catch (GenAIProcedureException ex) {
                VectorDatabaseRequest request = provider.handleFailedUpsertRequest(ex, finalHost, collection, configuration, Map.of("vector", vector));
                this.httpService.request(request.target(), request.requestCustomizer(), request.responseTransformer());
            }
        }
        return Stream.of(StatusDTO.ok(null));
    }

    @Internal
    @Procedure(value="genai.vector.external.query")
    @Description(value="Queries the closes vectors near the given vector in the named collection.\nIn Neo4j-Browser you can declare the configuration parameter as shown in the following examples.\n\nAuthorization can be configured either through a simple `token` entry in the config map like this:\n```\n:param configuration => ({token: 'your-api-key'})\n```\n\nOr if your vendor has an usual format, via a map entry under the key `Headers` in the configuration parameter.\nThe example uses a bearer token:\n```\n:param configuration => ({Headers: {Authorization: 'Bearer whatever'}})\n```\n")
    public Stream<EmbeddingResult> query(@Name(value="url") String url, @Name(value="collection") String collection, @Name(value="vector") List<Double> vector, @Name(value="filter", defaultValue="null") Object filter, @Name(value="limit", defaultValue="10") long limit, @Sensitive @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        return this.queryAndUpdate0(url, collection, vector, filter, limit, configuration, true);
    }

    @Internal
    @Procedure(value="genai.vector.external.queryAndUpdate", mode=Mode.WRITE)
    @Description(value="    Queries the closes vectors near the given vector in the named collection and updates existing Neo4j entities(Nodes or relationships).\n    In Neo4j-Browser you can declare the configuration parameter as shown in the following examples.\n\n    The mapping between vectors and entities is configured via a map entry under the key `mapping` in the configuration parameter.\n    ```\n    :param configuration => ({mapping: {embeddingKey: 'the_property_storing_the_vector', nodeLabel: 'TheLabel', entityKey: 'the_property_storing_the_mapping_key', metadataKey: ' the_property_stored_with_the_vector_in_the_vendor_db_matching_the_entity_key'}})\n    ```\n\n    Authorization can be configured either through a simple `token` entry in the config map like this:\n    ```\n    :param configuration => ({token: 'your-api-key'})\n    ```\n\n    Or if your vendor has an usual format, via a map entry under the key `Headers` in the configuration parameter.\n    The example uses a bearer token:\n    ```\n    :param configuration => ({Headers: {Authorization: 'Bearer whatever'}})\n    ```\n\n    *NOTE* The name of this procedure is subject to change.\n")
    public Stream<EmbeddingResult> queryAndUpdate(@Name(value="url") String url, @Name(value="collection") String collection, @Name(value="vector") List<Double> vector, @Name(value="filter", defaultValue="null") Object filter, @Name(value="limit", defaultValue="10") long limit, @Sensitive @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.queryAndUpdate0(url, collection, vector, filter, limit, configuration, null);
    }

    private Stream<EmbeddingResult> queryAndUpdate0(String url, String collection, List<Double> vector, Object filter, long limit, Map<String, Object> configuration, Boolean forceReadOnly) {
        RowMappingConfig rowMappingConfig = RowMappingConfig.of(configuration);
        EntityMappingConfig mappingConfig = EntityMappingConfig.of(RowMappingConfig.Keys.MAPPING.get(Map.class, configuration), forceReadOnly);
        List procedureResultFields = this.procedureCallContext.outputFields().toList();
        ProcedureArguments procedureArguments = ProcedureArguments.of(configuration, this.procedureCallContext);
        Map<String, Object> additionalArguments = Map.of("rowMappingConfig", rowMappingConfig, "vector", vector, "filter", Optional.ofNullable(filter), "limit", limit, "procedureResultFields", procedureResultFields, "procedureArguments", procedureArguments);
        VectorDatabaseProvider provider = this.getVectorDatabaseProvider(url);
        this.monitors.vectorDb().query(provider.getName());
        String finalHost = this.translateDefaultHost(provider, VectorDatabaseProvider.Command.QUERY, url, collection, configuration);
        VectorDatabaseRequest request = provider.createRequestFor(VectorDatabaseProvider.Command.QUERY, finalHost, collection, configuration, additionalArguments);
        return ((Stream)this.httpService.request(request.target(), request.requestCustomizer(), request.responseTransformer())).map(m -> this.toEmbeddingResult((Map<String, Object>)m, procedureArguments, rowMappingConfig, mappingConfig));
    }

    private EmbeddingResult toEmbeddingResult(Map<String, Object> m, ProcedureArguments procedureArguments, RowMappingConfig embeddingConfig, EntityMappingConfig mappingConfig) {
        Object id = procedureArguments.allResults() ? m.get(embeddingConfig.idKey()) : null;
        List embedding = procedureArguments.hasVector() ? (List)m.get(embeddingConfig.vectorKey()) : null;
        Map metadata = procedureArguments.hasMetadata() ? (Map)m.get(embeddingConfig.metadataKey()) : null;
        Double score = (Double)m.get(embeddingConfig.scoreKey());
        String text = procedureArguments.allResults() ? (String)m.get(embeddingConfig.textKey()) : null;
        Entity entity = VectorDatabases.handleMapping(this.tx, mappingConfig, metadata, embedding);
        return new EmbeddingResult(id, score, embedding, metadata, text, mappingConfig.nodeLabel() == null ? null : (Node)entity, mappingConfig.nodeLabel() != null ? null : (Relationship)entity);
    }

    private static Entity handleMapping(Transaction tx, EntityMappingConfig mapping, Map<String, Object> metadata, List<Double> embedding) {
        if (mapping.entityKey() == null) {
            return null;
        }
        if (metadata == null || metadata.isEmpty()) {
            throw new InvalidUsageException("To use mapping config, the metadata should not be empty. Make sure you execute `YIELD metadata` on the procedure");
        }
        if (mapping.nodeLabel() != null) {
            return VectorDatabases.handleMappingNode(tx, mapping, metadata, embedding);
        }
        if (mapping.relType() != null) {
            return VectorDatabases.handleMappingRel(tx, mapping, metadata, embedding);
        }
        throw new InvalidUsageException("Mapping conf has to contain either label or type key");
    }

    private static Entity handleMappingNode(Transaction transaction, EntityMappingConfig mapping, Map<String, Object> metadata, List<Double> embedding) {
        Object propValue = metadata.get(mapping.metadataKey());
        if (propValue == null) {
            return null;
        }
        Node node = transaction.findNode(Label.label((String)mapping.nodeLabel()), mapping.entityKey(), propValue);
        if (mapping.readOnly()) {
            return node;
        }
        if (mapping.mode() == EntityMappingConfig.MappingMode.CREATE_IF_MISSING && node == null) {
            node = transaction.createNode(new Label[]{Label.label((String)mapping.nodeLabel())});
            node.setProperty(mapping.entityKey(), propValue);
        }
        VectorDatabases.setPropertiesOnEntity(mapping, metadata, embedding, (Entity)node);
        return node;
    }

    private static Entity handleMappingRel(Transaction transaction, EntityMappingConfig mapping, Map<String, Object> metadata, List<Double> embedding) {
        Object propValue = metadata.get(mapping.metadataKey());
        if (propValue == null) {
            return null;
        }
        Relationship rel = transaction.findRelationship(RelationshipType.withName((String)mapping.relType()), mapping.entityKey(), propValue);
        if (!mapping.readOnly()) {
            VectorDatabases.setPropertiesOnEntity(mapping, metadata, embedding, (Entity)rel);
        }
        return rel;
    }

    private static void setPropertiesOnEntity(EntityMappingConfig mapping, Map<String, Object> properties, List<Double> embedding, Entity entity) {
        if (entity == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (entry.getValue() == null) continue;
            entity.setProperty(entry.getKey(), entry.getValue());
        }
        if (mapping.embeddingKey() == null) {
            return;
        }
        if (embedding == null) {
            String embeddingErrMsg = "The embedding value is null. Make sure you execute `YIELD embedding` on the procedure and you configured `%s: true`".formatted(RequestConfig.Keys.ALL_RESULTS.key());
            throw new InvalidUsageException(embeddingErrMsg);
        }
        float[] floats = VectorDatabases.listOfNumbersToFloatArray(embedding);
        entity.setProperty(mapping.embeddingKey(), (Object)floats);
    }

    private static float[] listOfNumbersToFloatArray(List<? extends Number> embedding) {
        float[] floats = new float[embedding.size()];
        int i = 0;
        for (Number number : embedding) {
            floats[i] = number.floatValue();
            ++i;
        }
        return floats;
    }

    private String translateDefaultHost(VectorDatabaseProvider provider, VectorDatabaseProvider.Command command, String defaultHost, String collection, Map<String, Object> configuration) {
        return provider.getCollectionSpecificHost(command, defaultHost, collection, configuration).map(r -> (String)this.httpService.request(r.target(), r.requestCustomizer(), r.responseTransformer())).orElse(defaultHost);
    }

    public record InfoDTO(String status, Map<String, Object> vendor) {
        public InfoDTO {
            vendor = vendor == null ? Map.of() : vendor;
        }

        public static InfoDTO of(Map<String, Object> vendor) {
            return new InfoDTO("ok", vendor == null ? Map.of() : vendor);
        }
    }

    public record StatusDTO(String status, Map<String, Object> vendor) {
        public StatusDTO {
            vendor = vendor == null ? Map.of() : vendor;
        }

        public static StatusDTO ok(Map<String, Object> vendor) {
            return new StatusDTO("ok", vendor);
        }

        public static StatusDTO failure(Map<String, Object> vendor) {
            return new StatusDTO("failure", vendor);
        }

        public static StatusDTO unknown(Map<String, Object> vendor) {
            return new StatusDTO("unknown", vendor);
        }
    }

    public record ProcedureArguments(boolean allResults, boolean hasVector, boolean hasMetadata) {
        static ProcedureArguments of(Map<String, Object> configuration, ProcedureCallContext procedureCallContext) {
            RequestConfig requestConfig = RequestConfig.of(configuration);
            List outputFields = procedureCallContext.outputFields().toList();
            boolean allResults = requestConfig.allResults();
            boolean hasVector = outputFields.contains("vector") && allResults;
            boolean hasMetadata = outputFields.contains("metadata");
            return new ProcedureArguments(allResults, hasVector, hasMetadata);
        }
    }

    public record EmbeddingResult(Object id, Double score, List<Double> vector, Map<String, Object> metadata, String text, Node node, Relationship rel) {
    }

    private record OptionalTokenAndConfig(String token, Map<String, Object> configuration) {
        static OptionalTokenAndConfig of(Map<String, Object> configuration) {
            String token = (String)configuration.get("token");
            if (token == null) {
                return new OptionalTokenAndConfig(token, configuration);
            }
            HashMap<String, Object> newConfig = new HashMap<String, Object>(configuration);
            newConfig.remove("token");
            return new OptionalTokenAndConfig(token, newConfig);
        }
    }

    public record ProviderDTO(String name) {
    }
}

