/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.ai.text.completion.provider;

import java.net.URI;
import java.util.Map;
import org.eclipse.collections.api.map.MutableMap;
import org.neo4j.genai.ai.text.completion.TextCompletion;
import org.neo4j.genai.ai.text.completion.provider.OpenAiBase;
import org.neo4j.genai.util.HttpService;
import org.neo4j.util.VisibleForTesting;

public class OpenAi
implements TextCompletion.Provider {
    private static final String DEFAULT_BASE_URL = "https://api.openai.com";
    private static final String DEFAULT_API_PATH = "/v1/responses";
    private final URI endpoint;

    public OpenAi() {
        this(DEFAULT_BASE_URL);
    }

    @VisibleForTesting
    public OpenAi(String baseUrl) {
        this.endpoint = URI.create(baseUrl + DEFAULT_API_PATH);
    }

    @Override
    public String name() {
        return "OpenAI";
    }

    public Class<Parameters> paramType() {
        return Parameters.class;
    }

    @Override
    public TextCompletion.Provider.Implementation implementation(HttpService httpService) {
        return new Implementation(this.name(), this.endpoint, httpService, this.paramType());
    }

    public static class Parameters {
        public String token;
        public String model;
        public Map<String, Object> vendorOptions = Map.of();
    }

    record Implementation(String name, URI endpoint, HttpService httpService, Class<Parameters> paramType) implements OpenAiBase<Parameters>
    {
        @Override
        public String[] authHeader(Parameters params) {
            return new String[]{"Authorization", "Bearer " + params.token};
        }

        @Override
        public void extendPayload(MutableMap<String, Object> payload, Parameters params) {
            payload.putAll(params.vendorOptions);
            payload.put((Object)"model", (Object)params.model);
        }
    }
}

