/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.ai.text.completion;

import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.collections.api.list.ImmutableList;
import org.neo4j.genai.util.HttpService;
import org.neo4j.genai.util.monitor.Monitors;
import org.neo4j.genai.util.provider.NamedProvider;
import org.neo4j.genai.util.provider.ProviderRow;
import org.neo4j.genai.vector.VectorEncoding;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.procedure.QueryLanguageScope;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Internal;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.Sensitive;
import org.neo4j.procedure.UserFunction;
import org.neo4j.values.virtual.MapValue;

public class TextCompletion {
    private static final String CONF_DESC = "Provider specific configuration, use `CALL ai.text.completion.providers()` to find the configuration needed for each provider. You can specify additional vendor options by adding `vendorOptions` with a map of values that will be passed along in the vendor request.";
    @Context
    public Providers providers;
    @Context
    public Monitors monitors;

    @Internal
    @UserFunction(name="ai.text.completion")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="Complete the specified prompt.")
    public String complete(@Name(value="prompt", description="The prompt to complete.") String prompt, @Name(value="provider", description="The identifier of the provider: 'OpenAI'.") String providerName, @Sensitive @Name(value="configuration", defaultValue="{}", description="Provider specific configuration, use `CALL ai.text.completion.providers()` to find the configuration needed for each provider. You can specify additional vendor options by adding `vendorOptions` with a map of values that will be passed along in the vendor request.") MapValue configuration) {
        Objects.requireNonNull(providerName, "'provider' must not be null");
        Objects.requireNonNull(configuration, "'configuration' must not be null");
        Provider.Implementation provider = (Provider.Implementation)this.providers.byName(providerName);
        this.monitors.textCompletion().textCompletionFunctionCalled(provider.name());
        return prompt == null ? null : provider.complete(prompt, configuration);
    }

    @Internal
    @Procedure(name="ai.text.completion")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="Complete the specified prompts.")
    public Stream<BatchRow> completeBatch(@Name(value="prompts", description="The prompts to complete.") List<String> prompts, @Name(value="provider", description="The identifier of the provider: 'OpenAI'.") String providerName, @Sensitive @Name(value="configuration", defaultValue="{}", description="Provider specific configuration, use `CALL ai.text.completion.providers()` to find the configuration needed for each provider. You can specify additional vendor options by adding `vendorOptions` with a map of values that will be passed along in the vendor request.") MapValue configuration) {
        Objects.requireNonNull(prompts, "'prompts' must not be null");
        Objects.requireNonNull(providerName, "'provider' must not be null");
        Objects.requireNonNull(configuration, "'configuration' must not be null");
        Provider.Implementation provider = (Provider.Implementation)this.providers.byName(providerName);
        this.monitors.textCompletion().textCompletionProcedureCalled(provider.name());
        return IntStream.range(0, prompts.size()).mapToObj(i -> {
            String prompt = (String)prompts.get(i);
            String completion = prompt == null ? null : provider.complete(prompt, configuration);
            return new BatchRow(i, completion);
        });
    }

    @Internal
    @Procedure(name="ai.text.completion.providers")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="Lists the available text completion providers.")
    public Stream<VectorEncoding.ProviderRow> listCompletionProviders() {
        return this.providers.providers().stream().map(ProviderRow::from);
    }

    public static interface Providers
    extends NamedProvider.Lookup<Provider, Provider.Implementation> {

        public record Impl(ImmutableList<Provider> providers, HttpService httpService) implements Providers
        {
            @Override
            public Provider.Implementation implementation(Provider provider) {
                return provider.implementation(this.httpService);
            }
        }
    }

    public static interface Provider
    extends NamedProvider {
        public Implementation implementation(HttpService var1);

        public static interface Implementation
        extends NamedProvider.Implementation {
            public String complete(String var1, MapValue var2);
        }
    }

    public record BatchRow(@Description(value="The index of the corresponding element in the input list.") long index, @Description(value="The text completion.") String completion) {
    }
}

