/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai;

import java.util.function.Supplier;
import org.neo4j.genai.HttpServiceProvider;
import org.neo4j.genai.ProcedureProvider;
import org.neo4j.genai.ServiceLoadedGlobalProviders;
import org.neo4j.genai.TxtCompProv;
import org.neo4j.genai.ai.text.completion.TextCompletion;
import org.neo4j.genai.util.HttpService;
import org.neo4j.genai.util.provider.GlobalProviders;
import org.neo4j.genai.util.provider.NamedProvider;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.util.VisibleForTesting;

public class GenAiPluginExtension
extends ExtensionFactory<Dependencies> {
    private final Supplier<GlobalProviders> providersSupplier;

    public GenAiPluginExtension() {
        this(new ServiceLoadedGlobalProviders());
    }

    @VisibleForTesting
    public GenAiPluginExtension(NamedProvider ... providers) {
        this(() -> GlobalProviders.from(providers));
    }

    private GenAiPluginExtension(Supplier<GlobalProviders> providersSupplier) {
        super(ExtensionType.GLOBAL, "gen-ai-plugin-extension");
        this.providersSupplier = providersSupplier;
    }

    public Lifecycle newInstance(ExtensionContext context, final Dependencies dependencies) {
        return new LifecycleAdapter(){

            public void init() {
                GlobalProviders providers = GenAiPluginExtension.this.providersSupplier.get();
                HttpServiceProvider httpService = new HttpServiceProvider();
                this.registerSafe(HttpService.class, httpService);
                this.registerSafe(TextCompletion.Providers.class, TxtCompProv.from(httpService, providers));
                dependencies.procedures().registerComponent(GlobalProviders.class, ctx -> providers, false);
            }

            private <T> void registerSafe(Class<T> cls, ProcedureProvider<T> provider) {
                dependencies.procedures().registerComponent(cls, provider, true);
            }
        };
    }

    public static interface Dependencies {
        public GlobalProcedures procedures();
    }
}

