/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.genai.util.GenAIMonitor;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.event.DatabaseEventContext;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.event.DatabaseEventListenerAdapter;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.DatabaseEventListeners;

public final class Monitors {
    private static final Map<String, Object> MONITORS = new ConcurrentHashMap<String, Object>();

    public static <T extends GenAIMonitor> T getMonitor(GraphDatabaseService graphDatabaseService, Class<T> type) {
        String databaseName = graphDatabaseService == null ? "n/a" : graphDatabaseService.databaseName();
        return (T)((GenAIMonitor)MONITORS.computeIfAbsent(databaseName + "-" + type.getCanonicalName(), key -> Monitors.getMonitor0(graphDatabaseService, type)));
    }

    private static void removeMonitorFor(String databaseName) {
        String prefix = databaseName + "-";
        MONITORS.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(prefix));
    }

    private static <T extends GenAIMonitor> T getMonitor0(GraphDatabaseService graphDatabaseService, Class<T> type) {
        org.neo4j.monitoring.Monitors monitors;
        if (graphDatabaseService instanceof GraphDatabaseAPI) {
            GraphDatabaseAPI graphDatabaseAPI = (GraphDatabaseAPI)graphDatabaseService;
            monitors = (org.neo4j.monitoring.Monitors)graphDatabaseAPI.getDependencyResolver().resolveDependency(org.neo4j.monitoring.Monitors.class);
        } else {
            monitors = new org.neo4j.monitoring.Monitors();
        }
        return (T)((GenAIMonitor)monitors.newMonitor(type, new String[0]));
    }

    public static class MonitorsCleaner
    extends ExtensionFactory<Dependencies> {
        public MonitorsCleaner() {
            super("genai-monitors-cleaner");
        }

        public Lifecycle newInstance(ExtensionContext context, final Dependencies dependencies) {
            return new LifecycleAdapter(this){

                public void start() {
                    dependencies.databaseEventListeners().registerDatabaseEventListener((DatabaseEventListener)new DatabaseEventListenerAdapter(this){

                        public void databaseShutdown(DatabaseEventContext eventContext) {
                            Monitors.removeMonitorFor(eventContext.getDatabaseName());
                        }

                        public void databasePanic(DatabaseEventContext eventContext) {
                            Monitors.removeMonitorFor(eventContext.getDatabaseName());
                        }
                    });
                }
            };
        }

        public static interface Dependencies {
            public DatabaseEventListeners databaseEventListeners();
        }
    }
}

