/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.vector.providers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.api.multimap.list.MutableListMultimap;
import org.eclipse.collections.impl.factory.Multimaps;
import org.neo4j.genai.util.HttpService;
import org.neo4j.genai.util.JsonUtils;
import org.neo4j.genai.util.MalformedGenAIResponseException;
import org.neo4j.genai.util.aws.AwsSignatureV4HeaderGenerator;
import org.neo4j.genai.vector.VectorEncoding;

public final class Bedrock
implements VectorEncoding.Provider<Parameters> {
    public static final String NAME = "Bedrock";
    private static final String ENDPOINT_TEMPLATE = "https://bedrock-runtime.${region}.amazonaws.com/model/${model}/invoke";
    static final String DEFAULT_REGION = "us-east-1";
    static final Set<String> SUPPORTED_REGIONS = Set.of("us-east-1", "us-west-2", "ap-southeast-1", "ap-northeast-1", "eu-central-1");
    private static final String STRINGIFIED_SUPPORTED_REGIONS = SUPPORTED_REGIONS.stream().map(s -> "'" + s + "'").collect(Collectors.joining(", ", "[", "]"));
    static final String DEFAULT_MODEL = "amazon.titan-embed-text-v1";
    static final Set<String> SUPPORTED_MODELS = Set.of("amazon.titan-embed-text-v1");
    private static final String STRINGIFIED_SUPPORTED_MODELS = SUPPORTED_MODELS.stream().map(s -> "'" + s + "'").collect(Collectors.joining(", ", "[", "]"));
    private static final TypeReference<float[]> VECTOR_TYPE_REFERENCE = new TypeReference<float[]>(){};

    @Override
    public Class<Parameters> parameterDeclarations() {
        return Parameters.class;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public VectorEncoding.Provider.Encoder configure(Parameters configuration) {
        if (!SUPPORTED_MODELS.contains(configuration.model)) {
            throw new IllegalArgumentException("Provided model '%s' is not supported. Supported models: %s".formatted(configuration.model, STRINGIFIED_SUPPORTED_MODELS));
        }
        if (!SUPPORTED_REGIONS.contains(configuration.region)) {
            throw new IllegalArgumentException("Provided region '%s' is not supported. Supported regions: %s".formatted(configuration.region, STRINGIFIED_SUPPORTED_REGIONS));
        }
        URI endpoint = URI.create(StringSubstitutor.replace((Object)ENDPOINT_TEMPLATE, Map.of("region", configuration.region, "model", configuration.model)));
        return new Encoder(endpoint, configuration);
    }

    public static class Parameters {
        public String accessKeyId;
        public String secretAccessKey;
        public String model = "amazon.titan-embed-text-v1";
        public String region = "us-east-1";
    }

    record Encoder(URI endpoint, Parameters configuration) implements VectorEncoding.Provider.Encoder
    {
        @Override
        public float[] encode(HttpService httpService, String resource) {
            try {
                String body = this.createRequestBody(resource);
                return httpService.request(this.endpoint, builder -> {
                    HttpRequest intermediate = builder.build();
                    MutableListMultimap requestProperties = Multimaps.mutable.list.with((Object)"Host", (Object)this.endpoint.getHost());
                    intermediate.headers().map().forEach((arg_0, arg_1) -> ((MutableListMultimap)requestProperties).putAll(arg_0, arg_1));
                    Multimap<String, String> finalHeaders = new AwsSignatureV4HeaderGenerator(this.configuration.region, this.endpoint, body, (Multimap<String, String>)requestProperties).generate(this.configuration.accessKeyId, this.configuration.secretAccessKey);
                    HttpRequest.Builder newBuilder = HttpRequest.newBuilder(intermediate, (k, v) -> !finalHeaders.containsKey(k));
                    finalHeaders.forEachKeyValue(newBuilder::header);
                    return newBuilder.POST(HttpRequest.BodyPublishers.ofString(body)).build();
                }, Encoder::parseResponse);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        static float[] parseResponse(InputStream inputStream) throws MalformedGenAIResponseException {
            float[] fArray;
            block11: {
                JsonNode tree;
                ObjectMapper objectMapper = JsonUtils.getObjectMapper();
                try {
                    tree = objectMapper.readTree(inputStream);
                }
                catch (IOException e) {
                    throw new MalformedGenAIResponseException("Unexpected error occurred while parsing the API response", e);
                }
                JsonNode embedding = Encoder.getExpectedFrom(tree, "embedding");
                if (!embedding.isArray()) {
                    throw new MalformedGenAIResponseException("Expected embedding to be an array");
                }
                JsonParser parser = embedding.traverse((ObjectCodec)objectMapper);
                try {
                    fArray = (float[])parser.readValueAs(VECTOR_TYPE_REFERENCE);
                    if (parser == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new MalformedGenAIResponseException("Unexpected error occurred while parsing the embedding", e);
                    }
                }
                parser.close();
            }
            return fArray;
        }

        private static JsonNode getExpectedFrom(JsonNode json, String property) throws MalformedGenAIResponseException {
            return JsonUtils.getExpectedFrom(Bedrock.NAME, json, property);
        }

        private String createRequestBody(String resource) throws IOException {
            return JsonUtils.getObjectMapper().writeValueAsString(Map.of("inputText", resource));
        }
    }
}

