/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.dbs.providers;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.neo4j.genai.dbs.RowMappingConfig;
import org.neo4j.genai.dbs.VectorDatabaseProvider;
import org.neo4j.genai.dbs.VectorDatabaseRequest;
import org.neo4j.genai.dbs.VectorDatabases;
import org.neo4j.genai.util.GenAIProcedureException;
import org.neo4j.genai.util.HttpService;
import org.neo4j.genai.util.JsonUtils;

public final class Weaviate
implements VectorDatabaseProvider {
    @Override
    public <T> VectorDatabaseRequest<T> createRequestFor(VectorDatabaseProvider.Command command, String host, String collection, Map<String, Object> configuration, Map<String, Object> additionalArguments) {
        VectorDatabases.ProcedureArguments procedureArguments = (VectorDatabases.ProcedureArguments)additionalArguments.get("procedureArguments");
        String baseUrl = host + "/v1";
        Function<HttpRequest.Builder, HttpRequest.Builder> prep = httpRequestBuilder -> this.addAuthorizationHeader(configuration, (HttpRequest.Builder)httpRequestBuilder);
        if (command == VectorDatabaseProvider.Command.CREATE_COLLECTION) {
            return Weaviate.createCreateCollectionRequest(baseUrl, collection, prep, additionalArguments);
        }
        if (command == VectorDatabaseProvider.Command.GET_COLLECTION_METADATA) {
            return Weaviate.createGetCollectionMetadataRequest(baseUrl, collection, prep);
        }
        if (command == VectorDatabaseProvider.Command.GET) {
            return Weaviate.createGetRequest(baseUrl, collection, prep, additionalArguments, procedureArguments);
        }
        if (command == VectorDatabaseProvider.Command.QUERY) {
            return Weaviate.createQueryRequest(baseUrl, collection, prep, additionalArguments, procedureArguments, configuration);
        }
        if (command == VectorDatabaseProvider.Command.DELETE_COLLECTION) {
            return Weaviate.createDeleteCollectionRequest(baseUrl, collection, prep);
        }
        if (command == VectorDatabaseProvider.Command.DELETE) {
            return Weaviate.createDeleteRequest(baseUrl, collection, prep, additionalArguments);
        }
        if (command == VectorDatabaseProvider.Command.UPSERT) {
            return Weaviate.createCreateRequest(baseUrl, collection, prep, additionalArguments);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> VectorDatabaseRequest<T> handleFailedUpsertRequest(GenAIProcedureException exception, String host, String collection, Map<String, Object> configuration, Map<String, Object> additionalArguments) {
        if (exception.getOptionalHttpCode().filter(code -> code == 422).isPresent() && exception.getMessage().contains("already exists")) {
            additionalArguments = new HashMap<String, Object>(additionalArguments);
            additionalArguments.put("forceUpdate", true);
            return this.createRequestFor(VectorDatabaseProvider.Command.UPSERT, host, collection, configuration, additionalArguments);
        }
        throw exception;
    }

    private static <T> VectorDatabaseRequest<T> createCreateCollectionRequest(String baseUrl, String collection, Function<HttpRequest.Builder, HttpRequest.Builder> prep, Map<String, Object> additionalArguments) {
        Function<HttpRequest.Builder, HttpRequest> requestCustomizer = prep.andThen(httpRequestBuilder -> {
            try {
                String body = JsonUtils.getObjectMapper().writeValueAsString(Map.of("class", collection, "vectorIndexConfig", Map.of("distance", ((String)additionalArguments.get("similarity")).toLowerCase(Locale.ROOT), "size", additionalArguments.get("size"))));
                return httpRequestBuilder.header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body)).build();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        });
        return new VectorDatabaseRequest<Object>(URI.create(baseUrl + "/schema"), requestCustomizer, in -> VectorDatabases.StatusDTO.ok(null));
    }

    private static <T> VectorDatabaseRequest<T> createDeleteRequest(String baseUrl, String collection, Function<HttpRequest.Builder, HttpRequest.Builder> preparingRequestCustomizer, Map<String, Object> additionalArguments) {
        String body;
        Object ids = additionalArguments.get("ids");
        try {
            body = JsonUtils.getObjectMapper().writeValueAsString(Map.of("output", "verbose", "dryRun", false, "match", Map.of("class", collection, "where", Map.of("path", List.of("id"), "operator", "ContainsAny", "valueStringArray", ids))));
        }
        catch (JsonProcessingException e) {
            throw new GenAIProcedureException("Failed to create body for batch deletion of vectors");
        }
        URI target = URI.create(baseUrl + "/batch/objects");
        Function<HttpRequest.Builder, HttpRequest> requestCustomizer = preparingRequestCustomizer.andThen(builder -> {
            builder.header("Content-Type", "application/json");
            return builder.method("DELETE", HttpRequest.BodyPublishers.ofString(body)).build();
        });
        Function<InputStream, VectorDatabases.StatusDTO> responseTransformer = HttpService.DEFAULT_RESPONSE_TO_MAP_TRANSFORMER.andThen(response -> {
            Object successful;
            Map results = (Map)response.get("results");
            Object matches = results.get("matches");
            if (!matches.equals(successful = results.get("successful"))) {
                return VectorDatabases.StatusDTO.failure(results);
            }
            return VectorDatabases.StatusDTO.ok(results);
        });
        return new VectorDatabaseRequest<VectorDatabases.StatusDTO>(target, requestCustomizer, responseTransformer);
    }

    private static <T> VectorDatabaseRequest<T> createGetCollectionMetadataRequest(String baseUrl, String collection, Function<HttpRequest.Builder, HttpRequest.Builder> prep) {
        Function<InputStream, VectorDatabases.InfoDTO> responseTransformer = HttpService.DEFAULT_RESPONSE_TO_MAP_TRANSFORMER.andThen(VectorDatabases.InfoDTO::of);
        return new VectorDatabaseRequest<VectorDatabases.InfoDTO>(URI.create(baseUrl + "/schema/" + collection), prep.andThen(HttpRequest.Builder::build), responseTransformer);
    }

    private static <T> VectorDatabaseRequest<T> createDeleteCollectionRequest(String baseUrl, String collection, Function<HttpRequest.Builder, HttpRequest.Builder> prep) {
        return new VectorDatabaseRequest<Object>(URI.create(baseUrl + "/schema/" + collection), prep.andThen(HttpRequest.Builder::DELETE).andThen(HttpRequest.Builder::build), in -> VectorDatabases.StatusDTO.ok(null));
    }

    private static <T> VectorDatabaseRequest<T> createCreateRequest(String baseUrl, String collection, Function<HttpRequest.Builder, HttpRequest.Builder> prep, Map<String, Object> additionalArguments) {
        Map vector = (Map)additionalArguments.get("vector");
        boolean forceUpdate = Boolean.TRUE.equals(additionalArguments.get("forceUpdate")) && vector.containsKey("id");
        URI target = forceUpdate ? URI.create(baseUrl + "/objects/" + String.valueOf(vector.get("id"))) : URI.create(baseUrl + "/objects");
        Function<HttpRequest.Builder, HttpRequest> requestCustomizer = prep.andThen(httpRequestBuilder -> {
            try {
                HashMap<String, String> body = new HashMap<String, String>();
                body.put("class", collection);
                body.put("properties", (String)vector.get("metadata"));
                vector.forEach((k, v) -> {
                    if (!"metadata".equals(k)) {
                        body.put((String)k, (String)v);
                    }
                });
                return httpRequestBuilder.header("Content-Type", "application/json").method(forceUpdate ? "PUT" : "POST", HttpRequest.BodyPublishers.ofString(JsonUtils.getObjectMapper().writeValueAsString(body))).build();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        });
        return new VectorDatabaseRequest<Object>(target, requestCustomizer, in -> VectorDatabases.StatusDTO.ok(null));
    }

    private static <T> VectorDatabaseRequest<T> createGetRequest(String baseUrl, String collection, Function<HttpRequest.Builder, HttpRequest.Builder> preparingRequestCustomizer, Map<String, Object> additionalArguments, VectorDatabases.ProcedureArguments procedureArguments) {
        Object id = additionalArguments.get("id");
        URI target = URI.create(baseUrl + "/objects/" + collection + "/" + String.valueOf(id) + (procedureArguments.hasVector() ? "?include=vector" : ""));
        Function<HttpRequest.Builder, HttpRequest> requestCustomizer = preparingRequestCustomizer.andThen(HttpRequest.Builder::GET).andThen(HttpRequest.Builder::build);
        RowMappingConfig rowMappingConfig = (RowMappingConfig)additionalArguments.get("rowMappingConfig");
        Function<InputStream, Object> responseTransformer = inputStream -> {
            try {
                Map result = (Map)JsonUtils.getObjectMapper().readValue(inputStream, JsonUtils.TYPE_REF_MAP_STRING_OBJECT);
                HashMap row = new HashMap();
                row.put(rowMappingConfig.idKey(), result.get("id"));
                row.put(rowMappingConfig.metadataKey(), result.get("properties"));
                row.put(rowMappingConfig.vectorKey(), result.get("vector"));
                row.put(rowMappingConfig.scoreKey(), result.get("score"));
                return row;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        return new VectorDatabaseRequest<Object>(target, requestCustomizer, responseTransformer);
    }

    private static <T> VectorDatabaseRequest<T> createQueryRequest(String baseUrl, String collection, Function<HttpRequest.Builder, HttpRequest.Builder> preparingRequestCustomizer, Map<String, Object> additionalArguments, VectorDatabases.ProcedureArguments procedureArguments, Map<String, Object> configuration) {
        RowMappingConfig rowMappingConfig = (RowMappingConfig)additionalArguments.get("rowMappingConfig");
        List vector = (List)additionalArguments.get("vector");
        String filter = ((Optional)additionalArguments.get("filter")).map(f -> ", where: " + String.valueOf(f)).orElse("");
        long limit = (Long)additionalArguments.get("limit");
        String fieldList = String.join((CharSequence)"\n", Objects.requireNonNull(RowMappingConfig.Keys.FIELDS.get(List.class, configuration), "You have to define `field` list of parameter to be returned"));
        String queryTemplate = "{\n  Get {\n    %s(limit: %s, nearVector: {vector: %s } %s) {%s  %s}\n  }\n}";
        String query = queryTemplate.formatted(collection, limit, vector, filter, fieldList, "_additional {id, distance " + (procedureArguments.hasVector() ? ",vector" : "") + "}");
        Function<HttpRequest.Builder, HttpRequest> requestCustomizer = preparingRequestCustomizer.andThen(httpRequestBuilder -> {
            httpRequestBuilder.header("Content-Type", "application/json");
            try {
                httpRequestBuilder.POST(HttpRequest.BodyPublishers.ofString(JsonUtils.getObjectMapper().writeValueAsString(Map.of("query", query))));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            return httpRequestBuilder.build();
        });
        Function<InputStream, Object> responseTransformer = inputStream -> {
            try {
                List errors;
                Map result = (Map)JsonUtils.getObjectMapper().readValue(inputStream, JsonUtils.TYPE_REF_MAP_STRING_OBJECT);
                Object patt0$temp = result.get("errors");
                if (patt0$temp instanceof List && !(errors = (List)patt0$temp).isEmpty()) {
                    StringBuilder message = new StringBuilder();
                    errors.forEach(error -> message.append(((Map)error).get("message")));
                    throw new GenAIProcedureException(message.toString());
                }
                Map dataMap = (Map)result.get("data");
                Map getMap = (Map)dataMap.get("Get");
                List data = (List)getMap.get(collection);
                return data.stream().map(i -> {
                    Map additional = (Map)i.remove("_additional");
                    HashMap row = new HashMap();
                    row.put(rowMappingConfig.metadataKey(), i);
                    row.put(rowMappingConfig.scoreKey(), additional.get("distance"));
                    row.put(rowMappingConfig.idKey(), additional.get("id"));
                    row.put(rowMappingConfig.vectorKey(), additional.get("vector"));
                    return row;
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        return new VectorDatabaseRequest<Object>(URI.create(baseUrl + "/graphql"), requestCustomizer, responseTransformer);
    }

    @Override
    public boolean supportsMultipleGet() {
        return false;
    }

    @Override
    public boolean supportsMultipleUpserts() {
        return false;
    }
}

