/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.dbs.providers;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.genai.dbs.CollectionNotFoundException;
import org.neo4j.genai.dbs.RowMappingConfig;
import org.neo4j.genai.dbs.VectorDatabaseProvider;
import org.neo4j.genai.dbs.VectorDatabaseRequest;
import org.neo4j.genai.dbs.VectorDatabases;
import org.neo4j.genai.util.HttpService;
import org.neo4j.genai.util.JsonUtils;

public final class Milvus
implements VectorDatabaseProvider {
    private static final UnaryOperator<String> CREATE_COLLECTION_BASE_URI = host -> host + "/v2/vectordb/collections";
    private static final UnaryOperator<String> CREATE_VECTOR_BASE_URI = host -> host + "/v2/vectordb/entities";
    private static final String DATA_KEY = "data";
    private static final String IDS_KEY = "ids";
    private static final String ID_KEY = "id";

    @Override
    public <T> VectorDatabaseRequest<T> createRequestFor(VectorDatabaseProvider.Command command, String host, String collection, Map<String, Object> configuration, Map<String, Object> additionalArguments) {
        RowMappingConfig rowMappingConfig = (RowMappingConfig)additionalArguments.get("rowMappingConfig");
        VectorDatabases.ProcedureArguments procedureArguments = (VectorDatabases.ProcedureArguments)additionalArguments.get("procedureArguments");
        Function<HttpRequest.Builder, HttpRequest.Builder> commonRequestBuilder = httpRequestBuilder -> this.addAuthorizationHeader(configuration, (HttpRequest.Builder)httpRequestBuilder);
        if (command == VectorDatabaseProvider.Command.GET_COLLECTION_METADATA) {
            return Milvus.createGetCollectionMetadataRequest(host, collection, commonRequestBuilder);
        }
        if (command == VectorDatabaseProvider.Command.GET) {
            return Milvus.createGetRequest(host, collection, additionalArguments, procedureArguments, rowMappingConfig, commonRequestBuilder);
        }
        if (command == VectorDatabaseProvider.Command.DELETE_COLLECTION) {
            return Milvus.createDeleteCollectionRequest(host, collection, commonRequestBuilder);
        }
        if (command == VectorDatabaseProvider.Command.CREATE_COLLECTION) {
            return Milvus.createCreateCollectionRequest(host, collection, additionalArguments, commonRequestBuilder);
        }
        if (command == VectorDatabaseProvider.Command.UPSERT) {
            return Milvus.createUpsertRequest(host, collection, configuration, additionalArguments, commonRequestBuilder);
        }
        if (command == VectorDatabaseProvider.Command.QUERY) {
            return Milvus.createQueryRequest(host, collection, additionalArguments, procedureArguments, rowMappingConfig, commonRequestBuilder);
        }
        if (command == VectorDatabaseProvider.Command.DELETE) {
            return Milvus.createDeleteRequest(host, collection, configuration, additionalArguments, commonRequestBuilder);
        }
        throw new UnsupportedOperationException();
    }

    private static <T> VectorDatabaseRequest<T> createDeleteRequest(String host, String collection, Map<String, Object> configuration, Map<String, Object> additionalArguments, Function<HttpRequest.Builder, HttpRequest.Builder> commonRequestBuilder) {
        URI target = URI.create((String)CREATE_VECTOR_BASE_URI.apply(host) + "/delete");
        Function<HttpRequest.Builder, HttpRequest> requestCustomizer = httpRequestBuilder -> {
            try {
                String body = JsonUtils.getObjectMapper().writeValueAsString(Map.of("collectionName", collection, "filter", Milvus.createIdFilter((List)additionalArguments.get(IDS_KEY))));
                return httpRequestBuilder.POST(HttpRequest.BodyPublishers.ofString(body)).build();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        };
        return new VectorDatabaseRequest<Object>(target, commonRequestBuilder.andThen(requestCustomizer), in -> {
            String message;
            Object patt0$temp;
            Map result = null;
            try {
                result = (Map)JsonUtils.getObjectMapper().readValue(in, JsonUtils.TYPE_REF_MAP_STRING_OBJECT);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (result.get("message") != null && (patt0$temp = result.get("message")) instanceof String && (message = (String)patt0$temp).contains("can't find collection")) {
                throw new CollectionNotFoundException(collection);
            }
            return VectorDatabases.StatusDTO.ok(null);
        });
    }

    private static String createIdFilter(List<Object> ids) {
        return ids.stream().map(Object::toString).map(stringId -> "id == " + stringId).collect(Collectors.joining(" || "));
    }

    private static <T> VectorDatabaseRequest<T> createQueryRequest(String host, String collection, Map<String, Object> additionalArguments, VectorDatabases.ProcedureArguments procedureArguments, RowMappingConfig rowMappingConfig, Function<HttpRequest.Builder, HttpRequest.Builder> commonRequestBuilder) {
        URI target = URI.create((String)CREATE_VECTOR_BASE_URI.apply(host) + "/search");
        Function<HttpRequest.Builder, HttpRequest> requestCustomizer = httpRequestBuilder -> {
            try {
                HashMap<String, String> requestParameters = new HashMap<String, String>(Map.of("collectionName", collection, "outputFields", List.of("payload", "vector"), DATA_KEY, List.of(additionalArguments.get("vector")), "filter", ((Optional)additionalArguments.get("filter")).orElse(""), "limit", additionalArguments.get("limit")));
                String body = JsonUtils.getObjectMapper().writeValueAsString(requestParameters);
                return httpRequestBuilder.POST(HttpRequest.BodyPublishers.ofString(body)).build();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        };
        Function<InputStream, Object> responseTransformer = inputStream -> {
            try {
                String message;
                Object patt0$temp;
                Map result = (Map)JsonUtils.getObjectMapper().readValue(inputStream, JsonUtils.TYPE_REF_MAP_STRING_OBJECT);
                if (result.get("message") != null && (patt0$temp = result.get("message")) instanceof String && (message = (String)patt0$temp).contains("can't find collection")) {
                    throw new CollectionNotFoundException(collection);
                }
                List data = (List)result.get(DATA_KEY);
                return data.stream().map(i -> {
                    HashMap row = new HashMap();
                    row.put(rowMappingConfig.metadataKey(), i.get("payload"));
                    row.put(rowMappingConfig.scoreKey(), i.get("distance"));
                    Object idValue = i.get(ID_KEY);
                    Long outputIdValue = null;
                    if (idValue instanceof Integer) {
                        Integer integerValue = (Integer)idValue;
                        outputIdValue = integerValue.longValue();
                    } else if (idValue instanceof Long) {
                        Long longValue;
                        outputIdValue = longValue = (Long)idValue;
                    } else {
                        throw new IllegalStateException("Could not convert " + String.valueOf(idValue) + " to a long value.");
                    }
                    row.put(rowMappingConfig.idKey(), outputIdValue);
                    row.put(rowMappingConfig.vectorKey(), i.get("vector"));
                    return row;
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        return new VectorDatabaseRequest<Object>(target, commonRequestBuilder.andThen(requestCustomizer), responseTransformer);
    }

    private static <T> VectorDatabaseRequest<T> createUpsertRequest(String host, String collection, Map<String, Object> configuration, Map<String, Object> additionalArguments, Function<HttpRequest.Builder, HttpRequest.Builder> commonRequestBuilder) {
        URI target = URI.create((String)CREATE_VECTOR_BASE_URI.apply(host) + "/upsert");
        Function<HttpRequest.Builder, HttpRequest> requestCustomizer = httpRequestBuilder -> {
            try {
                ArrayList points = new ArrayList();
                for (Map vector : (List)additionalArguments.get("vectors")) {
                    HashMap point = new HashMap(3);
                    point.put(ID_KEY, vector.get(ID_KEY));
                    point.put("payload", vector.get("metadata"));
                    point.put("vector", vector.get("vector"));
                    points.add(point);
                }
                String body = JsonUtils.getObjectMapper().writeValueAsString(Map.of(DATA_KEY, points, "collectionName", collection));
                return httpRequestBuilder.POST(HttpRequest.BodyPublishers.ofString(body)).build();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        };
        return new VectorDatabaseRequest<Object>(target, commonRequestBuilder.andThen(requestCustomizer), in -> {
            String message;
            Object patt0$temp;
            Map result = null;
            try {
                result = (Map)JsonUtils.getObjectMapper().readValue(in, JsonUtils.TYPE_REF_MAP_STRING_OBJECT);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (result.get("message") != null && (patt0$temp = result.get("message")) instanceof String && (message = (String)patt0$temp).contains("can't find collection")) {
                throw new CollectionNotFoundException(collection);
            }
            return VectorDatabases.StatusDTO.ok(null);
        });
    }

    private static <T> VectorDatabaseRequest<T> createCreateCollectionRequest(String host, String collection, Map<String, Object> additionalArguments, Function<HttpRequest.Builder, HttpRequest.Builder> commonRequestBuilder) {
        URI target = URI.create((String)CREATE_COLLECTION_BASE_URI.apply(host) + "/create");
        Function<HttpRequest.Builder, HttpRequest> requestCustomizer = httpRequestBuilder -> {
            try {
                String body = JsonUtils.getObjectMapper().writeValueAsString(Map.of("collectionName", collection, "dimension", additionalArguments.get("size"), "metricType", additionalArguments.get("similarity").toString().toUpperCase()));
                return httpRequestBuilder.POST(HttpRequest.BodyPublishers.ofString(body)).build();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        };
        return new VectorDatabaseRequest<Object>(target, commonRequestBuilder.andThen(requestCustomizer), in -> {
            String message;
            Object patt0$temp;
            Map result = null;
            try {
                result = (Map)JsonUtils.getObjectMapper().readValue(in, JsonUtils.TYPE_REF_MAP_STRING_OBJECT);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (result.get("message") != null && (patt0$temp = result.get("message")) instanceof String && (message = (String)patt0$temp).contains("can't find collection")) {
                throw new CollectionNotFoundException(collection);
            }
            return VectorDatabases.StatusDTO.ok(null);
        });
    }

    private static <T> VectorDatabaseRequest<T> createDeleteCollectionRequest(String host, String collection, Function<HttpRequest.Builder, HttpRequest.Builder> commonRequestBuilder) {
        URI target = URI.create((String)CREATE_COLLECTION_BASE_URI.apply(host) + "/drop");
        Function<HttpRequest.Builder, HttpRequest> requestCustomizer = httpRequestBuilder -> {
            try {
                return httpRequestBuilder.POST(HttpRequest.BodyPublishers.ofString(JsonUtils.getObjectMapper().writeValueAsString(Map.of("collectionName", collection)))).build();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        };
        return new VectorDatabaseRequest<Object>(target, commonRequestBuilder.andThen(requestCustomizer), in -> {
            String message;
            Object patt0$temp;
            Map result = null;
            try {
                result = (Map)JsonUtils.getObjectMapper().readValue(in, JsonUtils.TYPE_REF_MAP_STRING_OBJECT);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (result.get("message") != null && (patt0$temp = result.get("message")) instanceof String && (message = (String)patt0$temp).contains("can't find collection")) {
                throw new CollectionNotFoundException(collection);
            }
            return VectorDatabases.StatusDTO.ok(null);
        });
    }

    private static <T> VectorDatabaseRequest<T> createGetRequest(String host, String collection, Map<String, Object> additionalArguments, VectorDatabases.ProcedureArguments procedureArguments, RowMappingConfig rowMappingConfig, Function<HttpRequest.Builder, HttpRequest.Builder> commonRequestBuilder) {
        URI target = URI.create((String)CREATE_VECTOR_BASE_URI.apply(host) + "/get");
        Function<HttpRequest.Builder, HttpRequest> requestCustomizer = httpRequestBuilder -> {
            try {
                String body = JsonUtils.getObjectMapper().writeValueAsString(Map.of(ID_KEY, additionalArguments.get(IDS_KEY), "collectionName", collection, "with_payload", true));
                return httpRequestBuilder.POST(HttpRequest.BodyPublishers.ofString(body)).build();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        };
        Result result = new Result(target, commonRequestBuilder.andThen(requestCustomizer));
        Function<InputStream, Stream> resultTransformer = inputStream -> {
            try {
                Map map = (Map)JsonUtils.getObjectMapper().readValue(inputStream, JsonUtils.TYPE_REF_MAP_STRING_OBJECT);
                List resultList = (List)map.get(DATA_KEY);
                return resultList.stream().map(resultEntry -> {
                    String message;
                    Object patt0$temp;
                    if (resultEntry.get("message") != null && (patt0$temp = resultEntry.get("message")) instanceof String && (message = (String)patt0$temp).contains("can't find collection")) {
                        throw new CollectionNotFoundException(collection);
                    }
                    HashMap row = new HashMap();
                    resultEntry.forEach((k, v) -> {
                        if ("payload".equals(k)) {
                            row.put(rowMappingConfig.metadataKey(), v);
                        } else if (!ID_KEY.equals(k) || procedureArguments.allResults()) {
                            if (ID_KEY.equals(k)) {
                                Long outputIdValue = null;
                                if (v instanceof Integer) {
                                    Integer integerValue = (Integer)v;
                                    outputIdValue = integerValue.longValue();
                                } else if (v instanceof Long) {
                                    Long longValue;
                                    outputIdValue = longValue = (Long)v;
                                } else {
                                    throw new IllegalStateException("Could not convert " + String.valueOf(v) + " to a long value.");
                                }
                                row.put(k, outputIdValue);
                            } else {
                                row.put(k, v);
                            }
                        }
                    });
                    return row;
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        return new VectorDatabaseRequest<Stream>(result.target(), result.requestCustomizer(), resultTransformer);
    }

    private static <T> VectorDatabaseRequest<T> createGetCollectionMetadataRequest(String host, String collection, Function<HttpRequest.Builder, HttpRequest.Builder> commonRequestBuilder) {
        URI target = URI.create((String)CREATE_COLLECTION_BASE_URI.apply(host) + "/describe");
        Function<InputStream, VectorDatabases.InfoDTO> responseTransformer = HttpService.DEFAULT_RESPONSE_TO_MAP_TRANSFORMER.andThen(vendor -> {
            String message;
            Object patt0$temp;
            if (vendor.get("message") != null && (patt0$temp = vendor.get("message")) instanceof String && (message = (String)patt0$temp).contains("can't find collection")) {
                throw new CollectionNotFoundException(collection);
            }
            return VectorDatabases.InfoDTO.of(vendor);
        });
        Function<HttpRequest.Builder, HttpRequest> httpRequestCustomizer = httpRequestBuilder -> {
            try {
                return httpRequestBuilder.POST(HttpRequest.BodyPublishers.ofString(JsonUtils.getObjectMapper().writeValueAsString(Map.of("collectionName", collection)))).build();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        };
        return new VectorDatabaseRequest<VectorDatabases.InfoDTO>(target, commonRequestBuilder.andThen(httpRequestCustomizer), responseTransformer);
    }

    private record Result(URI target, Function<HttpRequest.Builder, HttpRequest> requestCustomizer) {
    }
}

