/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.dbs;

import java.util.Map;
import java.util.Optional;
import org.neo4j.genai.dbs.Constants;

public record RowMappingConfig(String idKey, String textKey, String vectorKey, String metadataKey, String scoreKey) {
    private RowMappingConfig(Map<String, Object> config) {
        this(Keys.ID.get(String.class, config), Keys.TEXT.get(String.class, config), Keys.VECTOR.get(String.class, config), Keys.METADATA.get(String.class, config), Keys.SCORE.get(String.class, config));
    }

    static RowMappingConfig of(Map<String, Object> config) {
        return new RowMappingConfig(config == null ? Map.of() : config);
    }

    public static enum Keys implements Constants
    {
        FIELDS("fields"),
        VECTOR("vectorKey", "vector"),
        METADATA("metadataKey", "metadata"),
        SCORE("scoreKey", "score"),
        TEXT("textKey", "text"),
        ID("idKey", "id"),
        MAPPING("mapping", Map.of());

        private final String key;
        private final Object defaultValue;

        private Keys(String value) {
            this(value, null);
        }

        private Keys(String value, Object defaultValue) {
            this.key = value;
            this.defaultValue = defaultValue;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public Optional<Object> defaultValue() {
            return Optional.ofNullable(this.defaultValue);
        }
    }
}

