/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Arrays;
import org.neo4j.internal.schema.IndexBehaviour;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexOrderCapability;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.internal.schema.IndexValueCapability;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.ValueCategory;

class FulltextIndexCapability
implements IndexCapability {
    private static final IndexBehaviour[] EVENTUALLY_CONSISTENT_BEHAVIOUR = new IndexBehaviour[]{IndexBehaviour.EVENTUALLY_CONSISTENT, IndexBehaviour.SKIP_AND_LIMIT};
    private static final IndexBehaviour[] NORMAL_BEHAVIOUR = new IndexBehaviour[]{IndexBehaviour.SKIP_AND_LIMIT};
    private final boolean isEventuallyConsistent;

    FulltextIndexCapability(boolean isEventuallyConsistent) {
        this.isEventuallyConsistent = isEventuallyConsistent;
    }

    public IndexOrderCapability orderCapability(ValueCategory ... valueCategories) {
        return IndexOrderCapability.NONE;
    }

    public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
        return IndexValueCapability.NO;
    }

    public boolean areValueCategoriesAccepted(ValueCategory ... valueCategories) {
        Preconditions.requireNonEmpty((Object[])valueCategories);
        Preconditions.requireNoNullElements((Object[])valueCategories);
        return Arrays.stream(valueCategories).allMatch(arg_0 -> ValueCategory.TEXT.equals(arg_0));
    }

    public boolean isQuerySupported(IndexQuery.IndexQueryType queryType, ValueCategory valueCategory) {
        return queryType == IndexQuery.IndexQueryType.FULLTEXT_SEARCH && this.areValueCategoriesAccepted(valueCategory);
    }

    public double getCostMultiplier(IndexQuery.IndexQueryType ... queryTypes) {
        return 1.0;
    }

    public boolean supportPartitionedScan(IndexQuery ... queries) {
        Preconditions.requireNonEmpty((Object[])queries);
        Preconditions.requireNoNullElements((Object[])queries);
        return false;
    }

    public IndexBehaviour[] behaviours() {
        return this.isEventuallyConsistent ? EVENTUALLY_CONSISTENT_BEHAVIOUR : NORMAL_BEHAVIOUR;
    }
}

