/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.values.storable.Value;

class FulltextIndexProgressor
implements IndexProgressor {
    private final ValuesIterator itr;
    private final IndexProgressor.EntityValueClient client;
    private long limit;

    FulltextIndexProgressor(ValuesIterator itr, IndexProgressor.EntityValueClient client, IndexQueryConstraints constraints) {
        this.itr = itr;
        this.client = client;
        if (constraints.skip().isPresent()) {
            for (long skip = constraints.skip().getAsLong(); skip > 0L && itr.hasNext(); --skip) {
                itr.next();
            }
        }
        this.limit = constraints.limit().isPresent() ? constraints.limit().getAsLong() : Long.MAX_VALUE;
    }

    public boolean next() {
        float score;
        long entityId;
        boolean accepted;
        if (!this.itr.hasNext() || this.limit == 0L) {
            return false;
        }
        while (!(accepted = this.client.acceptEntity(entityId = this.itr.next(), score = this.itr.currentScore(), (Value[])null)) && this.itr.hasNext()) {
        }
        --this.limit;
        return accepted;
    }

    public void close() {
    }
}

