/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.fulltext.DirectSearcherReference;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;

class TransactionStateLuceneIndexWriter
implements LuceneIndexWriter,
Closeable {
    private final Analyzer analyzer;
    private IndexWriter writer;
    private final Directory directory;

    TransactionStateLuceneIndexWriter(Analyzer analyzer) {
        this.analyzer = analyzer;
        this.directory = new RAMDirectory();
    }

    public void addDocument(Document document) throws IOException {
        this.writer.addDocument((Iterable)document);
    }

    public void addDocuments(int numDocs, Iterable<Document> document) throws IOException {
        this.writer.addDocuments(document);
    }

    public void updateDocument(Term term, Document document) throws IOException {
        this.writer.updateDocument(term, (Iterable)document);
    }

    public void deleteDocuments(Term term) throws IOException {
        this.writer.deleteDocuments(new Term[]{term});
    }

    public void deleteDocuments(Query query) throws IOException {
        this.writer.deleteDocuments(new Query[]{query});
    }

    void resetWriterState() throws IOException {
        if (this.writer != null) {
            this.writer.rollback();
        }
        this.openWriter();
    }

    private void openWriter() throws IOException {
        this.writer = new IndexWriter(this.directory, IndexWriterConfigs.transactionState((Analyzer)this.analyzer));
    }

    SearcherReference getNearRealTimeSearcher() throws IOException {
        DirectoryReader directoryReader = DirectoryReader.open((IndexWriter)this.writer);
        IndexSearcher searcher = new IndexSearcher((IndexReader)directoryReader);
        return new DirectSearcherReference(searcher, (Closeable)directoryReader);
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeAll((AutoCloseable[])new Closeable[]{this.writer, this.directory});
    }
}

