/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.neo4j.graphdb.index.fulltext.AnalyzerProvider;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexDescriptor;
import org.neo4j.kernel.api.impl.fulltext.FulltextSchemaDescriptor;
import org.neo4j.kernel.impl.core.TokenHolder;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;

public class FulltextIndexSettings {
    public static final String INDEX_CONFIG_ANALYZER = "analyzer";
    public static final String INDEX_CONFIG_EVENTUALLY_CONSISTENT = "eventually_consistent";
    private static final String INDEX_CONFIG_FILE = "fulltext-index.properties";
    private static final String INDEX_CONFIG_PROPERTY_NAMES = "propertyNames";

    static FulltextIndexDescriptor readOrInitialiseDescriptor(StoreIndexDescriptor descriptor, String defaultAnalyzerName, TokenHolder propertyKeyTokenHolder, File indexFolder, FileSystemAbstraction fileSystem) {
        Properties indexConfiguration = new Properties();
        if (descriptor.schema() instanceof FulltextSchemaDescriptor) {
            FulltextSchemaDescriptor schema = (FulltextSchemaDescriptor)descriptor.schema();
            indexConfiguration.putAll((Map<?, ?>)schema.getIndexConfiguration());
        }
        FulltextIndexSettings.loadPersistedSettings(indexConfiguration, indexFolder, fileSystem);
        boolean eventuallyConsistent = Boolean.parseBoolean(indexConfiguration.getProperty(INDEX_CONFIG_EVENTUALLY_CONSISTENT));
        String analyzerName = indexConfiguration.getProperty(INDEX_CONFIG_ANALYZER, defaultAnalyzerName);
        Analyzer analyzer = FulltextIndexSettings.createAnalyzer(analyzerName);
        ArrayList<String> names = new ArrayList<String>();
        for (int propertyKeyId : descriptor.schema().getPropertyIds()) {
            try {
                names.add(propertyKeyTokenHolder.getTokenById(propertyKeyId).name());
            }
            catch (TokenNotFoundException e) {
                throw new IllegalStateException("Property key id not found.", (Throwable)new PropertyKeyIdNotFoundKernelException(propertyKeyId, (Exception)((Object)e)));
            }
        }
        List<String> propertyNames = Collections.unmodifiableList(names);
        return new FulltextIndexDescriptor(descriptor, propertyNames, analyzer, analyzerName, eventuallyConsistent);
    }

    private static void loadPersistedSettings(Properties settings, File indexFolder, FileSystemAbstraction fs) {
        File settingsFile = new File(indexFolder, INDEX_CONFIG_FILE);
        if (fs.fileExists(settingsFile)) {
            try (Reader reader = fs.openAsReader(settingsFile, StandardCharsets.UTF_8);){
                settings.load(reader);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read persisted fulltext index properties: " + settingsFile, e);
            }
        }
    }

    private static Analyzer createAnalyzer(String analyzerName) {
        try {
            AnalyzerProvider provider = AnalyzerProvider.getProviderByName((String)analyzerName);
            return provider.createAnalyzer();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create fulltext analyzer: " + analyzerName, e);
        }
    }

    static void saveFulltextIndexSettings(FulltextIndexDescriptor descriptor, File indexFolder, FileSystemAbstraction fs) throws IOException {
        File indexConfigFile = new File(indexFolder, INDEX_CONFIG_FILE);
        Properties settings = new Properties();
        settings.setProperty(INDEX_CONFIG_EVENTUALLY_CONSISTENT, Boolean.toString(descriptor.isEventuallyConsistent()));
        settings.setProperty(INDEX_CONFIG_ANALYZER, descriptor.analyzerName());
        settings.setProperty(INDEX_CONFIG_PROPERTY_NAMES, descriptor.propertyNames().stream().collect(Collectors.joining(", ", "[", "]")));
        settings.setProperty("_propertyIds", Arrays.toString(descriptor.properties()));
        settings.setProperty("_name", descriptor.name());
        settings.setProperty("_schema_entityType", descriptor.schema().entityType().name());
        settings.setProperty("_schema_entityTokenIds", Arrays.toString(descriptor.schema().getEntityTokenIds()));
        try (StoreChannel channel = fs.create(indexConfigFile);
             Writer writer = fs.openAsWriter(indexConfigFile, StandardCharsets.UTF_8, false);){
            settings.store(writer, "Auto-generated file. Do not modify!");
            writer.flush();
            channel.force(true);
        }
    }
}

