/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TotalHitCountCollector;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexReader;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextDocumentStructure;
import org.neo4j.kernel.api.impl.fulltext.ScoreEntityIterator;
import org.neo4j.kernel.api.impl.fulltext.SearcherReference;
import org.neo4j.kernel.api.impl.index.collector.DocValuesCollector;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.impl.core.TokenHolder;
import org.neo4j.values.storable.Value;

class SimpleFulltextIndexReader
extends FulltextIndexReader {
    private final SearcherReference searcherRef;
    private final Analyzer analyzer;
    private final TokenHolder propertyKeyTokenHolder;
    private final String[] properties;

    SimpleFulltextIndexReader(SearcherReference searcherRef, String[] properties, Analyzer analyzer, TokenHolder propertyKeyTokenHolder) {
        this.searcherRef = searcherRef;
        this.properties = properties;
        this.analyzer = analyzer;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
    }

    public void close() {
        try {
            this.searcherRef.close();
        }
        catch (IOException e) {
            throw new IndexReaderCloseException(e);
        }
    }

    @Override
    public ScoreEntityIterator query(String queryString) throws ParseException {
        MultiFieldQueryParser multiFieldQueryParser = new MultiFieldQueryParser(this.properties, this.analyzer);
        Query query = multiFieldQueryParser.parse(queryString);
        return this.indexQuery(query);
    }

    private ScoreEntityIterator indexQuery(Query query) {
        try {
            DocValuesCollector docValuesCollector = new DocValuesCollector(true);
            this.getIndexSearcher().search(query, (Collector)docValuesCollector);
            ValuesIterator sortedValuesIterator = docValuesCollector.getSortedValuesIterator("__neo4j__lucene__fulltext__index__internal__id__", Sort.RELEVANCE);
            return new ScoreEntityIterator(sortedValuesIterator);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private IndexSearcher getIndexSearcher() {
        return this.searcherRef.getIndexSearcher();
    }

    public long countIndexedNodes(long nodeId, int[] propertyKeyIds, Value ... propertyValues) {
        try {
            String[] propertyKeys = new String[propertyKeyIds.length];
            for (int i = 0; i < propertyKeyIds.length; ++i) {
                propertyKeys[i] = this.propertyKeyTokenHolder.getTokenById(propertyKeyIds[i]).name();
            }
            Query query = LuceneFulltextDocumentStructure.newCountNodeEntriesQuery(nodeId, propertyKeys, propertyValues);
            TotalHitCountCollector collector = new TotalHitCountCollector();
            this.getIndexSearcher().search(query, (Collector)collector);
            return collector.getTotalHits();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

