/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexDescriptor;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexReader;
import org.neo4j.kernel.api.impl.fulltext.PartitionSearcherReference;
import org.neo4j.kernel.api.impl.fulltext.PartitionedFulltextIndexReader;
import org.neo4j.kernel.api.impl.fulltext.SimpleFulltextIndexReader;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndex;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.partition.IndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.impl.core.TokenHolder;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.schema.IndexDescriptor;

public class LuceneFulltextIndex
extends AbstractLuceneIndex<FulltextIndexReader>
implements Closeable {
    private final Analyzer analyzer;
    private final String identifier;
    private final EntityType type;
    private final Collection<String> properties;
    private final TokenHolder propertyKeyTokenHolder;
    private final File transactionsFolder;

    LuceneFulltextIndex(PartitionedIndexStorage storage, IndexPartitionFactory partitionFactory, FulltextIndexDescriptor descriptor, TokenHolder propertyKeyTokenHolder) {
        super(storage, partitionFactory, (IndexDescriptor)descriptor);
        this.analyzer = descriptor.analyzer();
        this.identifier = descriptor.getName();
        this.type = descriptor.schema().entityType();
        this.properties = descriptor.propertyNames();
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        File indexFolder = storage.getIndexFolder();
        this.transactionsFolder = new File(indexFolder.getParent(), indexFolder.getName() + ".tx");
    }

    public void open() throws IOException {
        super.open();
        this.indexStorage.prepareFolder(this.transactionsFolder);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.indexStorage.cleanupFolder(this.transactionsFolder);
    }

    public String toString() {
        return "LuceneFulltextIndex{analyzer=" + this.analyzer.getClass().getSimpleName() + ", identifier='" + this.identifier + '\'' + ", type=" + this.type + ", properties=" + this.properties + ", descriptor=" + this.descriptor.userDescription(SchemaUtil.idTokenNameLookup) + '}';
    }

    String[] getPropertiesArray() {
        return this.properties.toArray(new String[0]);
    }

    Analyzer getAnalyzer() {
        return this.analyzer;
    }

    TokenHolder getPropertyKeyTokenHolder() {
        return this.propertyKeyTokenHolder;
    }

    protected FulltextIndexReader createSimpleReader(List<AbstractIndexPartition> partitions) throws IOException {
        AbstractIndexPartition singlePartition = this.getFirstPartition(partitions);
        PartitionSearcherReference searcher = new PartitionSearcherReference(singlePartition.acquireSearcher());
        return new SimpleFulltextIndexReader(searcher, this.getPropertiesArray(), this.analyzer, this.propertyKeyTokenHolder);
    }

    protected FulltextIndexReader createPartitionedReader(List<AbstractIndexPartition> partitions) throws IOException {
        List searchers = LuceneFulltextIndex.acquireSearchers(partitions);
        return new PartitionedFulltextIndexReader(searchers, this.getPropertiesArray(), this.analyzer, this.propertyKeyTokenHolder);
    }
}

