/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexAccessor;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexDescriptor;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProvider;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexReader;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexTransactionStateVisitor;
import org.neo4j.kernel.api.impl.fulltext.TransactionStateFulltextIndexReader;
import org.neo4j.kernel.api.impl.fulltext.TransactionStateLuceneIndexWriter;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.logging.Log;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

class FulltextIndexTransactionState
implements Closeable {
    private final FulltextIndexDescriptor descriptor;
    private final List<AutoCloseable> toCloseLater;
    private final MutableLongSet modifiedEntityIdsInThisTransaction;
    private final TransactionStateLuceneIndexWriter writer;
    private final FulltextIndexTransactionStateVisitor txStateVisitor;
    private final boolean visitingNodes;
    private long lastUpdateRevision;
    private FulltextIndexReader currentReader;

    FulltextIndexTransactionState(FulltextIndexProvider provider, Log log, IndexReference indexReference) {
        FulltextIndexAccessor accessor = provider.getOpenOnlineAccessor((StoreIndexDescriptor)indexReference);
        log.debug("Acquired online fulltext schema index accessor, as base accessor for transaction state: %s", new Object[]{accessor});
        this.descriptor = accessor.getDescriptor();
        SchemaDescriptor schema = this.descriptor.schema();
        this.toCloseLater = new ArrayList<AutoCloseable>();
        this.writer = accessor.getTransactionStateIndexWriter();
        this.modifiedEntityIdsInThisTransaction = new LongHashSet();
        this.visitingNodes = schema.entityType() == EntityType.NODE;
        this.txStateVisitor = new FulltextIndexTransactionStateVisitor(this.descriptor, this.modifiedEntityIdsInThisTransaction, this.writer);
    }

    FulltextIndexReader getIndexReader(KernelTransactionImplementation kti) {
        if (this.currentReader == null || this.lastUpdateRevision != kti.getTransactionDataRevision()) {
            if (this.currentReader != null) {
                this.toCloseLater.add((AutoCloseable)((Object)this.currentReader));
            }
            try {
                this.updateReader(kti);
            }
            catch (Exception e) {
                this.currentReader = null;
                throw new RuntimeException("Failed to update the fulltext schema index transaction state.", e);
            }
        }
        return this.currentReader;
    }

    private void updateReader(KernelTransactionImplementation kti) throws Exception {
        this.modifiedEntityIdsInThisTransaction.clear();
        this.writer.resetWriterState();
        AllStoreHolder read = (AllStoreHolder)kti.dataRead();
        TransactionState transactionState = kti.txState();
        try (NodeCursor nodeCursor = this.visitingNodes ? kti.cursors().allocateNodeCursor() : null;
             RelationshipScanCursor relationshipCursor = this.visitingNodes ? null : kti.cursors().allocateRelationshipScanCursor();
             PropertyCursor propertyCursor = kti.cursors().allocatePropertyCursor();){
            transactionState.accept((TxStateVisitor)this.txStateVisitor.init(read, nodeCursor, relationshipCursor, propertyCursor));
        }
        FulltextIndexReader baseReader = (FulltextIndexReader)read.indexReader((IndexReference)this.descriptor, false);
        FulltextIndexReader nearRealTimeReader = this.writer.getNearRealTimeReader();
        this.currentReader = new TransactionStateFulltextIndexReader(baseReader, nearRealTimeReader, this.modifiedEntityIdsInThisTransaction);
        this.lastUpdateRevision = kti.getTransactionDataRevision();
    }

    @Override
    public void close() throws IOException {
        this.toCloseLater.add((AutoCloseable)((Object)this.currentReader));
        this.toCloseLater.add(this.writer);
        IOUtils.closeAll(this.toCloseLater);
    }
}

