/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;

public class ScoreEntityIterator
implements Iterator<ScoreEntry> {
    private final ValuesIterator iterator;
    private final Predicate<ScoreEntry> predicate;
    private ScoreEntry next;

    ScoreEntityIterator(ValuesIterator sortedValuesIterator) {
        this.iterator = sortedValuesIterator;
        this.predicate = null;
    }

    private ScoreEntityIterator(ValuesIterator sortedValuesIterator, Predicate<ScoreEntry> predicate) {
        this.iterator = sortedValuesIterator;
        this.predicate = predicate;
    }

    public Stream<ScoreEntry> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this, 16), false);
    }

    @Override
    public boolean hasNext() {
        while (this.next == null && this.iterator.hasNext()) {
            long entityId = this.iterator.next();
            float score = this.iterator.currentScore();
            ScoreEntry tmp = new ScoreEntry(entityId, score);
            if (this.predicate != null && !this.predicate.test(tmp)) continue;
            this.next = tmp;
        }
        return this.next != null;
    }

    @Override
    public ScoreEntry next() {
        if (this.hasNext()) {
            ScoreEntry tmp = this.next;
            this.next = null;
            return tmp;
        }
        throw new NoSuchElementException("The iterator is exhausted");
    }

    ScoreEntityIterator filter(Predicate<ScoreEntry> predicate) {
        if (this.predicate != null) {
            predicate = this.predicate.and(predicate);
        }
        return new ScoreEntityIterator(this.iterator, predicate);
    }

    static ScoreEntityIterator mergeIterators(List<ScoreEntityIterator> iterators) {
        return new ConcatenatingScoreEntityIterator(iterators);
    }

    static class ScoreEntry {
        private final long entityId;
        private final float score;

        long entityId() {
            return this.entityId;
        }

        float score() {
            return this.score;
        }

        ScoreEntry(long entityId, float score) {
            this.entityId = entityId;
            this.score = score;
        }

        public String toString() {
            return "ScoreEntry[entityId=" + this.entityId + ", score=" + this.score + "]";
        }
    }

    private static class ConcatenatingScoreEntityIterator
    extends ScoreEntityIterator {
        private final List<? extends ScoreEntityIterator> iterators;
        private final ScoreEntry[] buffer;
        private boolean fetched;
        private ScoreEntry nextHead;

        ConcatenatingScoreEntityIterator(List<? extends ScoreEntityIterator> iterators) {
            super(null);
            this.iterators = iterators;
            this.buffer = new ScoreEntry[iterators.size()];
        }

        @Override
        public boolean hasNext() {
            if (!this.fetched) {
                this.fetch();
            }
            return this.nextHead != null;
        }

        private void fetch() {
            int candidateHead = -1;
            for (int i = 0; i < this.iterators.size(); ++i) {
                ScoreEntry entry = this.buffer[i];
                if (entry == null && this.iterators.get(i).hasNext()) {
                    this.buffer[i] = entry = this.iterators.get(i).next();
                }
                if (entry == null || this.nextHead != null && !(entry.score > this.nextHead.score)) continue;
                this.nextHead = entry;
                candidateHead = i;
            }
            if (candidateHead != -1) {
                this.buffer[candidateHead] = null;
            }
            this.fetched = true;
        }

        @Override
        public ScoreEntry next() {
            if (this.hasNext()) {
                this.fetched = false;
                ScoreEntry best = this.nextHead;
                this.nextHead = null;
                return best;
            }
            throw new NoSuchElementException("The iterator is exhausted");
        }
    }
}

