/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.lucene.queryparser.classic.ParseException;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.index.fulltext.AnalyzerProvider;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.fulltext.BadSchemaException;
import org.neo4j.kernel.api.impl.fulltext.DatabaseFulltextIndex;
import org.neo4j.kernel.api.impl.fulltext.FulltextAdapter;
import org.neo4j.kernel.api.impl.fulltext.FulltextAuxiliaryTransactionState;
import org.neo4j.kernel.api.impl.fulltext.FulltextConfig;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexAccessor;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexBuilder;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexCapability;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexDescriptor;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexPopulator;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexReader;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexSettings;
import org.neo4j.kernel.api.impl.fulltext.FulltextSchemaDescriptor;
import org.neo4j.kernel.api.impl.fulltext.IndexUpdateSink;
import org.neo4j.kernel.api.impl.fulltext.ScoreEntityIterator;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.IndexStorageFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.MultiTokenSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.txstate.auxiliary.AuxiliaryTransactionState;
import org.neo4j.kernel.api.txstate.auxiliary.AuxiliaryTransactionStateManager;
import org.neo4j.kernel.api.txstate.auxiliary.AuxiliaryTransactionStateProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.core.TokenHolder;
import org.neo4j.kernel.impl.core.TokenHolders;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.participant.SchemaIndexMigrator;
import org.neo4j.logging.Log;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;

class FulltextIndexProvider
extends IndexProvider
implements FulltextAdapter,
AuxiliaryTransactionStateProvider {
    private static final String TX_STATE_PROVIDER_KEY = "FULLTEXT SCHEMA INDEX TRANSACTION STATE";
    private final FileSystemAbstraction fileSystem;
    private final Config config;
    private final TokenHolders tokenHolders;
    private final OperationalMode operationalMode;
    private final String defaultAnalyzerName;
    private final String defaultEventuallyConsistentSetting;
    private final AuxiliaryTransactionStateManager auxiliaryTransactionStateManager;
    private final Log log;
    private final IndexUpdateSink indexUpdateSink;
    private final ConcurrentMap<StoreIndexDescriptor, FulltextIndexAccessor> openOnlineAccessors;
    private final IndexStorageFactory indexStorageFactory;

    FulltextIndexProvider(IndexProviderDescriptor descriptor, IndexDirectoryStructure.Factory directoryStructureFactory, FileSystemAbstraction fileSystem, Config config, TokenHolders tokenHolders, DirectoryFactory directoryFactory, OperationalMode operationalMode, JobScheduler scheduler, AuxiliaryTransactionStateManager auxiliaryTransactionStateManager, Log log) {
        super(descriptor, directoryStructureFactory);
        this.fileSystem = fileSystem;
        this.config = config;
        this.tokenHolders = tokenHolders;
        this.operationalMode = operationalMode;
        this.auxiliaryTransactionStateManager = auxiliaryTransactionStateManager;
        this.log = log;
        this.defaultAnalyzerName = (String)config.get(FulltextConfig.fulltext_default_analyzer);
        this.defaultEventuallyConsistentSetting = Boolean.toString((Boolean)config.get(FulltextConfig.eventually_consistent));
        this.indexUpdateSink = new IndexUpdateSink(scheduler, (Integer)config.get(FulltextConfig.eventually_consistent_index_update_queue_max_length));
        this.openOnlineAccessors = new ConcurrentHashMap<StoreIndexDescriptor, FulltextIndexAccessor>();
        this.indexStorageFactory = this.buildIndexStorageFactory(fileSystem, directoryFactory);
    }

    private IndexStorageFactory buildIndexStorageFactory(FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory) {
        return new IndexStorageFactory(directoryFactory, fileSystem, this.directoryStructure());
    }

    private boolean indexIsOnline(PartitionedIndexStorage indexStorage, StoreIndexDescriptor descriptor) throws IOException {
        try (SchemaIndex index = ((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((IndexDescriptor)descriptor, (Config)this.config).withIndexStorage(indexStorage)).build();){
            if (index.exists()) {
                index.open();
                boolean bl = index.isOnline();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private PartitionedIndexStorage getIndexStorage(long indexId) {
        return this.indexStorageFactory.indexStorageOf(indexId);
    }

    public void start() throws Throwable {
        super.start();
        this.auxiliaryTransactionStateManager.registerProvider((AuxiliaryTransactionStateProvider)this);
    }

    public void stop() throws Throwable {
        this.auxiliaryTransactionStateManager.unregisterProvider((AuxiliaryTransactionStateProvider)this);
        this.indexStorageFactory.close();
    }

    public IndexCapability getCapability(StoreIndexDescriptor descriptor) {
        if (descriptor instanceof FulltextIndexDescriptor) {
            FulltextIndexDescriptor fulltextIndexDescriptor = (FulltextIndexDescriptor)descriptor;
            return new FulltextIndexCapability(fulltextIndexDescriptor.isEventuallyConsistent());
        }
        SchemaDescriptor schema = descriptor.schema();
        if (schema instanceof FulltextSchemaDescriptor) {
            FulltextSchemaDescriptor fulltextSchemaDescriptor = (FulltextSchemaDescriptor)schema;
            return new FulltextIndexCapability(fulltextSchemaDescriptor.isEventuallyConsistent());
        }
        FulltextIndexAccessor accessor = this.getOpenOnlineAccessor(descriptor);
        if (accessor != null) {
            FulltextIndexDescriptor fulltextIndexDescriptor = accessor.getDescriptor();
            return new FulltextIndexCapability(fulltextIndexDescriptor.isEventuallyConsistent());
        }
        PartitionedIndexStorage indexStorage = this.getIndexStorage(descriptor.getId());
        FulltextIndexDescriptor fulltextIndexDescriptor = FulltextIndexSettings.readOrInitialiseDescriptor(descriptor, this.defaultAnalyzerName, this.tokenHolders.propertyKeyTokens(), indexStorage, this.fileSystem);
        return new FulltextIndexCapability(fulltextIndexDescriptor.isEventuallyConsistent());
    }

    public String getPopulationFailure(StoreIndexDescriptor descriptor) throws IllegalStateException {
        String failure = this.getIndexStorage(descriptor.getId()).getStoredIndexFailure();
        if (failure == null) {
            throw new IllegalStateException("Index " + descriptor.getId() + " isn't failed");
        }
        return failure;
    }

    public InternalIndexState getInitialState(StoreIndexDescriptor descriptor) {
        PartitionedIndexStorage indexStorage = this.getIndexStorage(descriptor.getId());
        String failure = indexStorage.getStoredIndexFailure();
        if (failure != null) {
            return InternalIndexState.FAILED;
        }
        try {
            return this.indexIsOnline(indexStorage, descriptor) ? InternalIndexState.ONLINE : InternalIndexState.POPULATING;
        }
        catch (IOException e) {
            return InternalIndexState.POPULATING;
        }
    }

    public IndexPopulator getPopulator(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        PartitionedIndexStorage indexStorage = this.getIndexStorage(descriptor.getId());
        FulltextIndexDescriptor fulltextIndexDescriptor = FulltextIndexSettings.readOrInitialiseDescriptor(descriptor, this.defaultAnalyzerName, this.tokenHolders.propertyKeyTokens(), indexStorage, this.fileSystem);
        DatabaseFulltextIndex fulltextIndex = ((FulltextIndexBuilder)((FulltextIndexBuilder)((FulltextIndexBuilder)FulltextIndexBuilder.create(fulltextIndexDescriptor, this.config, this.tokenHolders.propertyKeyTokens()).withFileSystem(this.fileSystem)).withOperationalMode(this.operationalMode)).withIndexStorage(indexStorage)).withPopulatingMode(true).build();
        if (fulltextIndex.isReadOnly()) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        this.log.debug("Creating populator for fulltext schema index: %s", new Object[]{descriptor});
        return new FulltextIndexPopulator(fulltextIndexDescriptor, fulltextIndex, (ThrowingAction<IOException>)((ThrowingAction)() -> FulltextIndexSettings.saveFulltextIndexSettings(fulltextIndexDescriptor, indexStorage, this.fileSystem)));
    }

    public IndexAccessor getOnlineAccessor(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        PartitionedIndexStorage indexStorage = this.getIndexStorage(descriptor.getId());
        FulltextIndexDescriptor fulltextIndexDescriptor = FulltextIndexSettings.readOrInitialiseDescriptor(descriptor, this.defaultAnalyzerName, this.tokenHolders.propertyKeyTokens(), indexStorage, this.fileSystem);
        FulltextIndexBuilder fulltextIndexBuilder = ((FulltextIndexBuilder)((FulltextIndexBuilder)((FulltextIndexBuilder)FulltextIndexBuilder.create(fulltextIndexDescriptor, this.config, this.tokenHolders.propertyKeyTokens()).withFileSystem(this.fileSystem)).withOperationalMode(this.operationalMode)).withIndexStorage(indexStorage)).withPopulatingMode(false);
        if (fulltextIndexDescriptor.isEventuallyConsistent()) {
            fulltextIndexBuilder = fulltextIndexBuilder.withIndexUpdateSink(this.indexUpdateSink);
        }
        DatabaseFulltextIndex fulltextIndex = fulltextIndexBuilder.build();
        fulltextIndex.open();
        Runnable onClose = () -> {
            FulltextIndexAccessor cfr_ignored_0 = (FulltextIndexAccessor)((Object)((Object)this.openOnlineAccessors.remove(descriptor)));
        };
        FulltextIndexAccessor accessor = new FulltextIndexAccessor(this.indexUpdateSink, fulltextIndex, fulltextIndexDescriptor, onClose);
        this.openOnlineAccessors.put(descriptor, accessor);
        this.log.debug("Created online accessor for fulltext schema index %s: %s", new Object[]{descriptor, accessor});
        return accessor;
    }

    FulltextIndexAccessor getOpenOnlineAccessor(StoreIndexDescriptor descriptor) {
        return (FulltextIndexAccessor)((Object)this.openOnlineAccessors.get(descriptor));
    }

    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return new SchemaIndexMigrator(fs, (IndexProvider)this);
    }

    @Override
    public SchemaDescriptor schemaFor(EntityType type, String[] entityTokens, Properties indexConfiguration, String ... properties) {
        if (entityTokens.length == 0) {
            throw new BadSchemaException("At least one " + (type == EntityType.NODE ? "label" : "relationship type") + " must be specified when creating a fulltext index.");
        }
        if (properties.length == 0) {
            throw new BadSchemaException("At least one property name must be specified when creating a fulltext index.");
        }
        if (Arrays.asList(properties).contains("__neo4j__lucene__fulltext__index__internal__id__")) {
            throw new BadSchemaException("Unable to index the property, the name is reserved for internal use __neo4j__lucene__fulltext__index__internal__id__");
        }
        int[] entityTokenIds = new int[entityTokens.length];
        if (type == EntityType.NODE) {
            this.tokenHolders.labelTokens().getOrCreateIds(entityTokens, entityTokenIds);
        } else {
            this.tokenHolders.relationshipTypeTokens().getOrCreateIds(entityTokens, entityTokenIds);
        }
        int[] propertyIds = Arrays.stream(properties).mapToInt(arg_0 -> ((TokenHolder)this.tokenHolders.propertyKeyTokens()).getOrCreateId(arg_0)).toArray();
        MultiTokenSchemaDescriptor schema = SchemaDescriptorFactory.multiToken((int[])entityTokenIds, (EntityType)type, (int[])propertyIds);
        indexConfiguration.putIfAbsent("analyzer", this.defaultAnalyzerName);
        indexConfiguration.putIfAbsent("eventually_consistent", this.defaultEventuallyConsistentSetting);
        return new FulltextSchemaDescriptor((SchemaDescriptor)schema, indexConfiguration);
    }

    @Override
    public ScoreEntityIterator query(KernelTransaction ktx, String indexName, String queryString) throws IndexNotFoundKernelException, ParseException {
        FulltextIndexReader fulltextIndexReader;
        KernelTransactionImplementation kti = (KernelTransactionImplementation)ktx;
        AllStoreHolder allStoreHolder = (AllStoreHolder)kti.dataRead();
        IndexReference indexReference = kti.schemaRead().indexGetForName(indexName);
        if (kti.hasTxStateWithChanges() && !((FulltextSchemaDescriptor)indexReference.schema()).isEventuallyConsistent()) {
            FulltextAuxiliaryTransactionState auxiliaryTxState = (FulltextAuxiliaryTransactionState)allStoreHolder.auxiliaryTxState((Object)TX_STATE_PROVIDER_KEY);
            fulltextIndexReader = auxiliaryTxState.indexReader(indexReference, kti);
        } else {
            IndexReader indexReader = allStoreHolder.indexReader(indexReference, false);
            fulltextIndexReader = (FulltextIndexReader)indexReader;
        }
        return fulltextIndexReader.query(queryString);
    }

    @Override
    public void awaitRefresh() {
        this.indexUpdateSink.awaitUpdateApplication();
    }

    @Override
    public Stream<String> listAvailableAnalyzers() {
        Iterable providers = AnalyzerProvider.load(AnalyzerProvider.class);
        Stream<AnalyzerProvider> stream = StreamSupport.stream(providers.spliterator(), false);
        return stream.flatMap(provider -> StreamSupport.stream(provider.getKeys().spliterator(), false));
    }

    public Object getIdentityKey() {
        return TX_STATE_PROVIDER_KEY;
    }

    public AuxiliaryTransactionState createNewAuxiliaryTransactionState() {
        return new FulltextAuxiliaryTransactionState(this, this.log);
    }
}

