/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.kernel.api.impl.fulltext.DatabaseFulltextIndex;
import org.neo4j.kernel.api.impl.fulltext.EventuallyConsistentIndexUpdater;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexDescriptor;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexReader;
import org.neo4j.kernel.api.impl.fulltext.IndexUpdateSink;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextDocumentStructure;
import org.neo4j.kernel.api.impl.fulltext.TransactionStateLuceneIndexWriter;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndexAccessor;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.Value;

public class FulltextIndexAccessor
extends AbstractLuceneIndexAccessor<FulltextIndexReader, DatabaseFulltextIndex> {
    private final IndexUpdateSink indexUpdateSink;
    private final FulltextIndexDescriptor descriptor;
    private final Runnable onClose;

    public FulltextIndexAccessor(IndexUpdateSink indexUpdateSink, DatabaseFulltextIndex luceneIndex, FulltextIndexDescriptor descriptor, Runnable onClose) {
        super((DatabaseIndex)luceneIndex, (IndexDescriptor)descriptor);
        this.indexUpdateSink = indexUpdateSink;
        this.descriptor = descriptor;
        this.onClose = onClose;
    }

    public FulltextIndexDescriptor getDescriptor() {
        return this.descriptor;
    }

    public IndexUpdater getIndexUpdater(IndexUpdateMode mode) {
        Object indexUpdater = new FulltextIndexUpdater(mode.requiresIdempotency(), mode.requiresRefresh());
        if (this.descriptor.isEventuallyConsistent()) {
            indexUpdater = new EventuallyConsistentIndexUpdater((DatabaseIndex<? extends IndexReader>)this.luceneIndex, (IndexUpdater)indexUpdater, this.indexUpdateSink);
        }
        return indexUpdater;
    }

    public void close() {
        try {
            if (this.descriptor.isEventuallyConsistent()) {
                this.indexUpdateSink.awaitUpdateApplication();
            }
            super.close();
        }
        finally {
            this.onClose.run();
        }
    }

    public BoundedIterable<Long> newAllEntriesReader() {
        return super.newAllEntriesReader(LuceneFulltextDocumentStructure::getNodeId);
    }

    public void verifyDeferredConstraints(NodePropertyAccessor propertyAccessor) {
    }

    public TransactionStateLuceneIndexWriter getTransactionStateIndexWriter() {
        try {
            return ((DatabaseFulltextIndex)this.luceneIndex).getTransactionalIndexWriter();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public class FulltextIndexUpdater
    extends AbstractLuceneIndexAccessor.AbstractLuceneIndexUpdater {
        private FulltextIndexUpdater(boolean idempotent, boolean refresh) {
            super((AbstractLuceneIndexAccessor)FulltextIndexAccessor.this, idempotent, refresh);
        }

        protected void addIdempotent(long entityId, Value[] values) {
            try {
                FulltextIndexAccessor.this.writer.updateDocument(LuceneFulltextDocumentStructure.newTermForChangeOrRemove(entityId), LuceneFulltextDocumentStructure.documentRepresentingProperties(entityId, FulltextIndexAccessor.this.descriptor.propertyNames(), values));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void add(long entityId, Value[] values) {
            try {
                FulltextIndexAccessor.this.writer.addDocument(LuceneFulltextDocumentStructure.documentRepresentingProperties(entityId, FulltextIndexAccessor.this.descriptor.propertyNames(), values));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        protected void change(long entityId, Value[] values) {
            try {
                FulltextIndexAccessor.this.writer.updateDocument(LuceneFulltextDocumentStructure.newTermForChangeOrRemove(entityId), LuceneFulltextDocumentStructure.documentRepresentingProperties(entityId, FulltextIndexAccessor.this.descriptor.propertyNames(), values));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        protected void remove(long entityId) {
            try {
                FulltextIndexAccessor.this.writer.deleteDocuments(LuceneFulltextDocumentStructure.newTermForChangeOrRemove(entityId));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

