/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.FulltextSettings;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.fulltext.EventuallyConsistentIndexUpdater;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexReader;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexSettings;
import org.neo4j.kernel.api.impl.fulltext.IndexUpdateSink;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextDocumentStructure;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndexAccessor;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.index.IndexEntriesReader;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.values.storable.Value;

public class FulltextIndexAccessor
extends AbstractLuceneIndexAccessor<FulltextIndexReader, DatabaseIndex<FulltextIndexReader>> {
    private final IndexUpdateSink indexUpdateSink;
    private final IndexDescriptor index;
    private final String[] propertyNames;
    private final AtomicBoolean needsRefresh = new AtomicBoolean();
    private final JobScheduler jobScheduler;
    private final Duration eventuallyConsistentRefreshInterval;

    FulltextIndexAccessor(IndexUpdateSink indexUpdateSink, DatabaseIndex<FulltextIndexReader> luceneIndex, IndexDescriptor index, String[] propertyNames, IndexUpdateIgnoreStrategy ignoreStrategy, Config config, JobScheduler jobScheduler) {
        super(luceneIndex, index, ignoreStrategy);
        this.indexUpdateSink = indexUpdateSink;
        this.index = index;
        this.propertyNames = propertyNames;
        this.eventuallyConsistentRefreshInterval = (Duration)config.get(FulltextSettings.eventually_consistent_refresh_interval);
        this.jobScheduler = jobScheduler;
    }

    public IndexUpdater getIndexUpdater(IndexUpdateMode mode) {
        boolean eventuallyConsistent = FulltextIndexSettings.isEventuallyConsistent(this.index);
        Runnable refreshAction = mode.requiresRefresh() ? (eventuallyConsistent && !this.eventuallyConsistentRefreshInterval.isZero() ? () -> this.needsRefresh.set(true) : () -> ((FulltextIndexAccessor)this).refresh()) : () -> {};
        Object indexUpdater = new FulltextIndexUpdater(mode.requiresIdempotency(), refreshAction);
        if (FulltextIndexSettings.isEventuallyConsistent(this.index)) {
            indexUpdater = new EventuallyConsistentIndexUpdater((DatabaseIndex<? extends IndexReader>)this.luceneIndex, (IndexUpdater)indexUpdater, this.indexUpdateSink);
        }
        return indexUpdater;
    }

    public void close() {
        if (FulltextIndexSettings.isEventuallyConsistent(this.index)) {
            this.indexUpdateSink.awaitUpdateApplication();
        }
        super.close();
    }

    public BoundedIterable<Long> newAllEntriesValueReader(long fromIdInclusive, long toIdExclusive, CursorContext cursorContext) {
        return super.newAllEntriesReader(LuceneFulltextDocumentStructure::getNodeId, fromIdInclusive, toIdExclusive);
    }

    public IndexEntriesReader[] newAllEntriesValueReader(int partitions, CursorContext cursorContext) {
        return super.newAllEntriesValueReader(LuceneFulltextDocumentStructure::getNodeId, partitions);
    }

    public Map<String, Value> indexConfig() {
        return this.index.getIndexConfig().asMap();
    }

    public void maintenance() {
        if (this.needsRefresh.compareAndSet(true, false)) {
            this.jobScheduler.schedule(Group.INDEX_REFRESHING, () -> ((FulltextIndexAccessor)this).refresh());
        }
    }

    public class FulltextIndexUpdater
    extends AbstractLuceneIndexAccessor.AbstractLuceneIndexUpdater {
        private FulltextIndexUpdater(boolean idempotent, Runnable refreshAction) {
            super((AbstractLuceneIndexAccessor)FulltextIndexAccessor.this, idempotent, refreshAction);
        }

        protected void addIdempotent(long entityId, Value[] values) {
            try {
                Document document = LuceneFulltextDocumentStructure.documentRepresentingProperties(entityId, FulltextIndexAccessor.this.propertyNames, values);
                FulltextIndexAccessor.this.writer.updateOrDeleteDocument(LuceneFulltextDocumentStructure.newTermForChangeOrRemove(entityId), document);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void add(long entityId, Value[] values) {
            try {
                Document document = LuceneFulltextDocumentStructure.documentRepresentingProperties(entityId, FulltextIndexAccessor.this.propertyNames, values);
                FulltextIndexAccessor.this.writer.nullableAddDocument(document);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        protected void change(long entityId, Value[] values) {
            try {
                Term term = LuceneFulltextDocumentStructure.newTermForChangeOrRemove(entityId);
                Document document = LuceneFulltextDocumentStructure.documentRepresentingProperties(entityId, FulltextIndexAccessor.this.propertyNames, values);
                FulltextIndexAccessor.this.writer.updateOrDeleteDocument(term, document);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        protected void remove(long entityId) {
            try {
                Term term = LuceneFulltextDocumentStructure.newTermForChangeOrRemove(entityId);
                FulltextIndexAccessor.this.writer.deleteDocuments(term);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

