/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.Clause;
import org.neo4j.cypher.internal.ast.ConditionalQueryBranch;
import org.neo4j.cypher.internal.ast.ConditionalQueryWhen;
import org.neo4j.cypher.internal.ast.SingleQuery;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.ast.prettifier.ExpressionStringifier$;
import org.neo4j.cypher.internal.ast.prettifier.Prettifier;
import org.neo4j.cypher.internal.ast.prettifier.Prettifier$;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.Pattern;
import org.neo4j.cypher.internal.expressions.PatternElement;
import org.neo4j.cypher.internal.expressions.PatternPart;
import org.neo4j.cypher.internal.expressions.RelationshipPattern;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.AprioriScope;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.Declarations;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.ExpressionResult$;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.ExpressionScope;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.NoResult$;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.OmittedResult$;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.PatternIncomingContext;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.PatternScope;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.RegularContext;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.Result;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.StatementScope;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.TableResult;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.TableResultWithNotYetKnownColumns$;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.UnexpectedAstNodeScopingError;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.WorkingContext;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.WorkingScope;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.util.Block;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.util.BoxedBlock$;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.util.BoxedBlockPositionInSequence$First$;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.util.BoxedBlockPositionInSequence$Last$;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.util.BoxedBlockPositionInSequence$Middle$;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.util.EpsilonBlock$;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.util.EpsilonSpan$;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.util.Span;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.util.Span$;
import org.neo4j.cypher.internal.frontend.phases.parserTransformers.scoping.util.Text;
import org.neo4j.cypher.internal.label_expressions.LabelExpression;
import org.neo4j.cypher.internal.util.ASTNode;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.InputPosition$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class WorkingScopeStringRenderer$ {
    public static final WorkingScopeStringRenderer$ MODULE$ = new WorkingScopeStringRenderer$();
    private static final Prettifier prettifier = new Prettifier(ExpressionStringifier$.MODULE$.apply(ExpressionStringifier$.MODULE$.apply$default$1(), ExpressionStringifier$.MODULE$.apply$default$2(), ExpressionStringifier$.MODULE$.apply$default$3(), ExpressionStringifier$.MODULE$.apply$default$4(), ExpressionStringifier$.MODULE$.apply$default$5()), Prettifier$.MODULE$.apply$default$2(), Prettifier$.MODULE$.apply$default$3());

    public String apply(Option<WorkingScope> workingScopeOpt) {
        Text renderedText = (Text)workingScopeOpt.map((Function1 & Serializable)workingScope -> MODULE$.render((WorkingScope)workingScope)).getOrElse((Function0 & Serializable)() -> Span$.MODULE$.apply("\u2014 no scope found \u2014"));
        String renderedString = renderedText.render(renderedText.render$default$1());
        return renderedString;
    }

    public String apply(WorkingScope workingScope) {
        Text qual$1 = this.render(workingScope);
        int x$1 = qual$1.render$default$1();
        return qual$1.render(x$1);
    }

    private Text render(WorkingScope workingScope) {
        WorkingScope workingScope2 = workingScope;
        if (workingScope2 instanceof StatementScope) {
            StatementScope statementScope = (StatementScope)workingScope2;
            ASTNode astNode = statementScope.astNode();
            RegularContext incoming = statementScope.incoming();
            Set<LogicalVariable> referenced = statementScope.referenced();
            Declarations declared = statementScope.declared();
            RegularContext outgoing = statementScope.outgoing();
            Result result = statementScope.result();
            Seq<WorkingScope> children = statementScope.children();
            return new Block((Seq<Text>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Text[]{this.renderIncoming(incoming), this.renderAst(astNode), this.renderReferenced(referenced), this.renderDeclaration(declared), this.renderChildren(children), this.renderResult(result), this.renderOutgoing(result, outgoing)}));
        }
        if (workingScope2 instanceof ExpressionScope) {
            ExpressionScope expressionScope = (ExpressionScope)workingScope2;
            ASTNode astNode = expressionScope.astNode();
            RegularContext patternIncoming = expressionScope.incoming();
            Set<LogicalVariable> referenced = expressionScope.referenced();
            Declarations declared = expressionScope.declared();
            Seq<WorkingScope> children = expressionScope.children();
            return new Block((Seq<Text>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Text[]{this.renderIncoming(patternIncoming), this.renderAst(astNode), this.renderReferenced(referenced), this.renderDeclaration(declared), this.renderChildren(children)}));
        }
        if (workingScope2 instanceof PatternScope) {
            PatternScope patternScope = (PatternScope)workingScope2;
            ASTNode astNode = patternScope.astNode();
            PatternIncomingContext patternIncoming = patternScope.patternIncoming();
            Set<LogicalVariable> referenced = patternScope.referenced();
            Declarations declared = patternScope.declared();
            TableResult result = patternScope.result();
            Seq<WorkingScope> children = patternScope.children();
            return new Block((Seq<Text>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Text[]{this.renderIncoming(patternIncoming), this.renderAst(astNode), this.renderReferenced(referenced), this.renderDeclaration(declared), this.renderChildren(children), this.renderResult(result)}));
        }
        if (workingScope2 instanceof AprioriScope) {
            AprioriScope aprioriScope = (AprioriScope)workingScope2;
            RegularContext outgoing = aprioriScope.outgoing();
            return new Block((Seq<Text>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Text[]{Span$.MODULE$.apply("\u2014 apriori \u2014"), Span$.MODULE$.apply(String.valueOf(this.renderWorkingContext(outgoing)))}));
        }
        if (workingScope2 instanceof UnexpectedAstNodeScopingError) {
            UnexpectedAstNodeScopingError unexpectedAstNodeScopingError = (UnexpectedAstNodeScopingError)workingScope2;
            ASTNode astNode = unexpectedAstNodeScopingError.astNode();
            RegularContext incoming = unexpectedAstNodeScopingError.incoming();
            return new Block((Seq<Text>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Text[]{Span$.MODULE$.apply(String.valueOf(this.renderWorkingContext(incoming))), Span$.MODULE$.apply((Seq<Span>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Span[]{Span$.MODULE$.apply("\u2014 unexpected syntax: "), Span$.MODULE$.shrinkAtEnd(this.renderAstString(astNode)), Span$.MODULE$.apply(" \u2014")}))}));
        }
        throw new MatchError((Object)workingScope2);
    }

    private Span renderIncoming(WorkingContext incoming) {
        return Span$.MODULE$.apply("In " + this.renderWorkingContext(incoming));
    }

    private Span renderAst(ASTNode astNode) {
        return Span$.MODULE$.shrinkInMiddle(this.renderAstString(astNode));
    }

    private Text renderDeclaration(Declarations declarations) {
        Declarations declarations2 = declarations;
        if (declarations2 != null) {
            Seq<LogicalVariable> constants = declarations2.constants();
            Seq<LogicalVariable> variables = declarations2.variables();
            if (constants.isEmpty() && variables.isEmpty()) {
                return EpsilonSpan$.MODULE$;
            }
        }
        if (declarations2 != null) {
            Seq<LogicalVariable> constants = declarations2.constants();
            Seq<LogicalVariable> variables = declarations2.variables();
            return Span$.MODULE$.apply("Decl Const: " + this.renderVariableSeq(constants) + " | Var: " + this.renderVariableSeq(variables));
        }
        throw new MatchError((Object)declarations2);
    }

    private Text renderReferenced(Set<LogicalVariable> referenced) {
        if (referenced.isEmpty()) {
            return EpsilonSpan$.MODULE$;
        }
        return Span$.MODULE$.apply("Ref: " + this.renderVariableSet(referenced));
    }

    private Text renderChildren(Seq<WorkingScope> children) {
        Option option;
        SeqOps seqOps;
        Seq<WorkingScope> seq = children;
        if (Nil$.MODULE$.equals(seq)) {
            return EpsilonBlock$.MODULE$;
        }
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            WorkingScope child = (WorkingScope)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            return BoxedBlock$.MODULE$.apply((Seq<Text>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Text[]{this.render(child)}));
        }
        if (seq != null && !(option = package$.MODULE$.$colon$plus().unapply(seq)).isEmpty()) {
            Option option2;
            Seq seq2 = (Seq)((Tuple2)option.get())._1();
            WorkingScope lastChild = (WorkingScope)((Tuple2)option.get())._2();
            if (seq2 != null && !(option2 = package$.MODULE$.$plus$colon().unapply((SeqOps)seq2)).isEmpty()) {
                WorkingScope firstChild = (WorkingScope)((Tuple2)option2.get())._1();
                Seq middleChildren = (Seq)((Tuple2)option2.get())._2();
                return new Block((Seq<Text>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Text[]{BoxedBlock$.MODULE$.apply(BoxedBlockPositionInSequence$First$.MODULE$, (Seq<Text>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Text[]{this.render(firstChild)})), new Block((Seq<Text>)((Seq)middleChildren.map((Function1 & Serializable)m -> BoxedBlock$.MODULE$.apply(BoxedBlockPositionInSequence$Middle$.MODULE$, (Seq<Text>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Text[]{MODULE$.render((WorkingScope)m)}))))), BoxedBlock$.MODULE$.apply(BoxedBlockPositionInSequence$Last$.MODULE$, (Seq<Text>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Text[]{this.render(lastChild)}))}));
            }
        }
        return EpsilonBlock$.MODULE$;
    }

    private Text renderResult(Result result) {
        Result result2 = result;
        if (result2 instanceof TableResult) {
            TableResult tableResult = (TableResult)result2;
            Seq<LogicalVariable> columns = tableResult.columns();
            return Span$.MODULE$.apply("Result columns: " + this.renderVariableSeq(columns));
        }
        if (TableResultWithNotYetKnownColumns$.MODULE$.equals(result2)) {
            return Span$.MODULE$.apply("Not yet known result columns");
        }
        if (OmittedResult$.MODULE$.equals(result2)) {
            return Span$.MODULE$.apply("Omitted result");
        }
        if (NoResult$.MODULE$.equals(result2)) {
            return EpsilonSpan$.MODULE$;
        }
        if (ExpressionResult$.MODULE$.equals(result2)) {
            return EpsilonSpan$.MODULE$;
        }
        throw new MatchError((Object)result2);
    }

    private Text renderOutgoing(Result result, WorkingContext outgoing) {
        Result result2 = result;
        if (result2 instanceof TableResult) {
            return EpsilonSpan$.MODULE$;
        }
        if (TableResultWithNotYetKnownColumns$.MODULE$.equals(result2)) {
            return EpsilonSpan$.MODULE$;
        }
        if (OmittedResult$.MODULE$.equals(result2)) {
            return Span$.MODULE$.apply("Out " + this.renderWorkingContext(outgoing));
        }
        if (NoResult$.MODULE$.equals(result2)) {
            return Span$.MODULE$.apply("Out " + this.renderWorkingContext(outgoing));
        }
        if (ExpressionResult$.MODULE$.equals(result2)) {
            return EpsilonSpan$.MODULE$;
        }
        throw new MatchError((Object)result2);
    }

    private String renderWorkingContext(WorkingContext workingContext) {
        WorkingContext workingContext2 = workingContext;
        if (workingContext2 instanceof RegularContext) {
            RegularContext regularContext = (RegularContext)workingContext2;
            Set<LogicalVariable> constants = regularContext.constants();
            Set<LogicalVariable> variables = regularContext.variables();
            return "Const: " + this.renderVariableSet(constants) + "; Var: " + this.renderVariableSet(variables);
        }
        if (workingContext2 instanceof PatternIncomingContext) {
            PatternIncomingContext patternIncomingContext = (PatternIncomingContext)workingContext2;
            Set<LogicalVariable> topologicalConstants = patternIncomingContext.topologicalConstants();
            Set<LogicalVariable> predicateConstants = patternIncomingContext.predicateConstants();
            Set<LogicalVariable> pathConstants = patternIncomingContext.pathConstants();
            Set<LogicalVariable> groupConstants = patternIncomingContext.groupConstants();
            return "Topo: " + this.renderVariableSet(topologicalConstants) + "; Pred: " + this.renderVariableSet(predicateConstants) + "; Path: " + this.renderVariableSet(pathConstants) + "; Group: " + this.renderVariableSet(groupConstants);
        }
        throw new MatchError((Object)workingContext2);
    }

    private String renderVariableSet(Set<LogicalVariable> variables) {
        return this.renderVariableSeq((Seq<LogicalVariable>)((Seq)variables.toSeq().sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)WorkingScopeStringRenderer$.$anonfun$renderVariableSet$1(x$1)), (Ordering)Ordering.Int$.MODULE$)));
    }

    private String renderVariableSeq(Seq<LogicalVariable> variables) {
        if (variables.isEmpty()) {
            return "\u2014";
        }
        return ((IterableOnceOps)variables.map((Function1 & Serializable)variable -> MODULE$.renderVariable((LogicalVariable)variable))).mkString(", ");
    }

    private String renderVariable(LogicalVariable variable) {
        return variable.name();
    }

    private Prettifier prettifier() {
        return prettifier;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String renderAstString(ASTNode astNode) {
        Option option;
        String string;
        boolean bl = false;
        ConditionalQueryBranch conditionalQueryBranch = null;
        ASTNode aSTNode = astNode;
        if (aSTNode instanceof Statement) {
            Statement statement = (Statement)aSTNode;
            string = this.prettifier().asString(statement);
            return this.whitespaceNormalization(string);
        }
        if (aSTNode instanceof Clause) {
            Clause clause = (Clause)aSTNode;
            string = this.prettifier().asString((Statement)new SingleQuery((Seq)new .colon.colon((Object)clause, (List)Nil$.MODULE$), (InputPosition)InputPosition$.MODULE$.NONE()));
            return this.whitespaceNormalization(string);
        }
        if (aSTNode instanceof Expression) {
            Expression expression = (Expression)aSTNode;
            string = this.prettifier().expr().apply(expression);
            return this.whitespaceNormalization(string);
        }
        if (aSTNode instanceof Pattern) {
            Pattern pattern = (Pattern)aSTNode;
            string = this.prettifier().expr().patterns().apply(pattern);
            return this.whitespaceNormalization(string);
        }
        if (aSTNode instanceof PatternPart) {
            PatternPart patternPart = (PatternPart)aSTNode;
            string = this.prettifier().expr().patterns().apply(patternPart);
            return this.whitespaceNormalization(string);
        }
        if (aSTNode instanceof PatternElement) {
            PatternElement patternElement = (PatternElement)aSTNode;
            string = this.prettifier().expr().patterns().apply(patternElement);
            return this.whitespaceNormalization(string);
        }
        if (aSTNode instanceof RelationshipPattern) {
            RelationshipPattern relationshipPattern = (RelationshipPattern)aSTNode;
            string = this.prettifier().expr().patterns().apply(relationshipPattern);
            return this.whitespaceNormalization(string);
        }
        if (aSTNode instanceof LabelExpression) {
            LabelExpression labelExpression = (LabelExpression)aSTNode;
            string = this.prettifier().expr().stringifyLabelExpression(labelExpression);
            return this.whitespaceNormalization(string);
        }
        if (aSTNode instanceof ConditionalQueryBranch) {
            bl = true;
            conditionalQueryBranch = (ConditionalQueryBranch)aSTNode;
            Option option2 = conditionalQueryBranch.predicate();
            if (option2 instanceof Some) {
                string = this.prettifier().asString((Statement)new ConditionalQueryWhen((Seq)new .colon.colon((Object)conditionalQueryBranch, (List)Nil$.MODULE$), (Option)None$.MODULE$, (InputPosition)InputPosition$.MODULE$.NONE()));
                return this.whitespaceNormalization(string);
            }
        }
        if (bl && None$.MODULE$.equals(option = conditionalQueryBranch.predicate())) {
            string = this.prettifier().asString((Statement)new ConditionalQueryWhen((Seq)Nil$.MODULE$, (Option)new Some((Object)conditionalQueryBranch), (InputPosition)InputPosition$.MODULE$.NONE()));
            return this.whitespaceNormalization(string);
        }
        string = aSTNode.toString();
        return this.whitespaceNormalization(string);
    }

    private String whitespaceNormalization(String cypher) {
        return cypher.trim().replaceAll("\\s+", " ");
    }

    public static final /* synthetic */ int $anonfun$renderVariableSet$1(LogicalVariable x$1) {
        return x$1.position().offset();
    }

    private WorkingScopeStringRenderer$() {
    }
}

