/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.phases;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.ast.UnresolvedCall;
import org.neo4j.cypher.internal.expressions.FunctionInvocation;
import org.neo4j.cypher.internal.expressions.FunctionTypeSignature;
import org.neo4j.cypher.internal.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.phases.DeprecationInfo;
import org.neo4j.cypher.internal.frontend.phases.FieldSignature;
import org.neo4j.cypher.internal.frontend.phases.Phase;
import org.neo4j.cypher.internal.frontend.phases.ProcedureAndFunctionDeprecationWarnings$;
import org.neo4j.cypher.internal.frontend.phases.ProcedureSignature;
import org.neo4j.cypher.internal.frontend.phases.QualifiedName;
import org.neo4j.cypher.internal.frontend.phases.ResolvedCall;
import org.neo4j.cypher.internal.frontend.phases.ResolvedFunctionInvocation;
import org.neo4j.cypher.internal.frontend.phases.Transformer;
import org.neo4j.cypher.internal.frontend.phases.UserFunctionSignature;
import org.neo4j.cypher.internal.frontend.phases.VisitorPhase;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.cypher.internal.util.DeprecatedFunctionNotification;
import org.neo4j.cypher.internal.util.Foldable;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.StepSequencer;
import org.neo4j.exceptions.InternalException;
import org.neo4j.notifications.DeprecatedFunctionFieldNotification;
import org.neo4j.notifications.DeprecatedProcedureFieldNotification;
import org.neo4j.notifications.DeprecatedProcedureNotification;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class ProcedureAndFunctionDeprecationWarnings$
implements VisitorPhase<BaseContext, BaseState>,
Product,
Serializable {
    public static final ProcedureAndFunctionDeprecationWarnings$ MODULE$ = new ProcedureAndFunctionDeprecationWarnings$();

    static {
        Transformer.$init$(MODULE$);
        Phase.$init$(MODULE$);
        VisitorPhase.$init$(MODULE$);
        Product.$init$((Product)MODULE$);
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public Object process(Object from, BaseContext context) {
        return VisitorPhase.process$(this, from, context);
    }

    @Override
    public Set<StepSequencer.Condition> postConditions() {
        return VisitorPhase.postConditions$(this);
    }

    @Override
    public Object transform(Object from, BaseContext context) {
        return Phase.transform$(this, from, context);
    }

    @Override
    public String name() {
        return Phase.name$(this);
    }

    @Override
    public <D extends BaseContext, TO2> Transformer<D, BaseState, TO2> andThen(Transformer<D, BaseState, TO2> other) {
        return Transformer.andThen$(this, other);
    }

    @Override
    public Set<StepSequencer.Condition> invalidatedConditions() {
        return Transformer.invalidatedConditions$(this);
    }

    @Override
    public final boolean checkConditions(Object state, Set<StepSequencer.Condition> conditions, CancellationChecker cancellationChecker) {
        return Transformer.checkConditions$(this, state, conditions, cancellationChecker);
    }

    @Override
    public void visit(BaseState value, BaseContext context) {
        Set<InternalNotification> warnings = this.findDeprecations(value.statement());
        InternalNotificationLogger internalNotificationLogger = context.notificationLogger();
        warnings.foreach((Function1 & Serializable)notification -> {
            internalNotificationLogger.log(notification);
            return BoxedUnit.UNIT;
        });
    }

    private Set<InternalNotification> findDeprecations(Statement statement) {
        return (Set)statement.folder().treeFold((Object)Predef$.MODULE$.Set().empty(), (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ProcedureSignature procedureSignature;
                boolean bl = false;
                ResolvedCall resolvedCall = null;
                boolean bl2 = false;
                ResolvedFunctionInvocation resolvedFunctionInvocation = null;
                A1 A1 = x1;
                if (A1 instanceof ResolvedCall) {
                    bl = true;
                    resolvedCall = (ResolvedCall)A1;
                    ProcedureSignature procedureSignature2 = resolvedCall.signature();
                    if (procedureSignature2 != null) {
                        Some some;
                        DeprecationInfo deprecationInfo;
                        QualifiedName name = procedureSignature2.name();
                        IndexedSeq<FieldSignature> inputFields = procedureSignature2.inputSignature();
                        Option<DeprecationInfo> option = procedureSignature2.deprecationInfo();
                        if (option instanceof Some && (deprecationInfo = (DeprecationInfo)(some = (Some)option).value()) != null) {
                            boolean bl3 = deprecationInfo.isDeprecated();
                            Option<String> deprecatedBy = deprecationInfo.deprecatedBy();
                            if (bl3) {
                                return (B1)(Function1 & Serializable)seq -> new Foldable.TraverseChildren((Object)((SetOps)seq.$plus$plus((IterableOnce)((IterableOnceOps)((IndexedSeqOps)inputFields.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)anonfun.findDeprecations.1.$anonfun$applyOrElse$2(x$1)))).map((Function1 & Serializable)inputField -> new DeprecatedProcedureFieldNotification(resolvedCall.position(), name.toString(), inputField.name()))).toSet())).$plus((Object)new DeprecatedProcedureNotification(resolvedCall.position(), name.toString(), deprecatedBy)));
                            }
                        }
                    }
                }
                if (bl && (procedureSignature = resolvedCall.signature()) != null) {
                    QualifiedName name = procedureSignature.name();
                    IndexedSeq<FieldSignature> inputFields = procedureSignature.inputSignature();
                    if (inputFields.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)anonfun.findDeprecations.1.$anonfun$applyOrElse$4(x$2)))) {
                        return (B1)(Function1 & Serializable)seq -> new Foldable.TraverseChildren((Object)seq.$plus$plus((IterableOnce)((IterableOnceOps)((IndexedSeqOps)inputFields.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)anonfun.findDeprecations.1.$anonfun$applyOrElse$6(x$3)))).map((Function1 & Serializable)inputField -> new DeprecatedProcedureFieldNotification(resolvedCall.position(), name.toString(), inputField.name()))).toSet()));
                    }
                }
                if (A1 instanceof ResolvedFunctionInvocation) {
                    Some some;
                    UserFunctionSignature userFunctionSignature;
                    bl2 = true;
                    resolvedFunctionInvocation = (ResolvedFunctionInvocation)A1;
                    Option<UserFunctionSignature> option = resolvedFunctionInvocation.fcnSignature();
                    if (option instanceof Some && (userFunctionSignature = (UserFunctionSignature)(some = (Some)option).value()) != null) {
                        Some some2;
                        DeprecationInfo deprecationInfo;
                        QualifiedName name = userFunctionSignature.name();
                        IndexedSeq<FieldSignature> inputFields = userFunctionSignature.inputSignature();
                        Option<DeprecationInfo> option2 = userFunctionSignature.deprecationInfo();
                        if (option2 instanceof Some && (deprecationInfo = (DeprecationInfo)(some2 = (Some)option2).value()) != null) {
                            boolean bl4 = deprecationInfo.isDeprecated();
                            Option<String> deprecatedBy = deprecationInfo.deprecatedBy();
                            if (bl4) {
                                return (B1)(Function1 & Serializable)seq -> new Foldable.TraverseChildren((Object)((SetOps)seq.$plus$plus((IterableOnce)((IterableOnceOps)((IndexedSeqOps)inputFields.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)anonfun.findDeprecations.1.$anonfun$applyOrElse$9(x$4)))).map((Function1 & Serializable)inputField -> new DeprecatedFunctionFieldNotification(resolvedFunctionInvocation.position(), name.toString(), inputField.name()))).toSet())).$plus((Object)new DeprecatedFunctionNotification(resolvedFunctionInvocation.position(), name.toString(), deprecatedBy)));
                            }
                        }
                    }
                }
                if (bl2) {
                    IndexedSeq<FieldSignature> inputFields;
                    Some some;
                    UserFunctionSignature userFunctionSignature;
                    QualifiedName name = resolvedFunctionInvocation.qualifiedName();
                    Option<UserFunctionSignature> option = resolvedFunctionInvocation.fcnSignature();
                    if (option instanceof Some && (userFunctionSignature = (UserFunctionSignature)(some = (Some)option).value()) != null && (inputFields = userFunctionSignature.inputSignature()).exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)anonfun.findDeprecations.1.$anonfun$applyOrElse$11(x$5)))) {
                        return (B1)(Function1 & Serializable)seq -> new Foldable.TraverseChildren((Object)seq.$plus$plus((IterableOnce)((IterableOnceOps)((IndexedSeqOps)inputFields.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)anonfun.findDeprecations.1.$anonfun$applyOrElse$13(x$6)))).map((Function1 & Serializable)inputField -> new DeprecatedFunctionFieldNotification(resolvedFunctionInvocation.position(), name.toString(), inputField.name()))).toSet()));
                    }
                }
                if (A1 instanceof FunctionInvocation) {
                    FunctionInvocation functionInvocation = (FunctionInvocation)A1;
                    Seq deprecationWarnings = (Seq)((IterableOps)((IterableOps)functionInvocation.function().signatures().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)anonfun.findDeprecations.1.$anonfun$applyOrElse$15(functionInvocation, x0$1)))).map((Function1 & Serializable)x$7 -> x$7)).map((Function1 & Serializable)fts -> new DeprecatedFunctionNotification(functionInvocation.position(), functionInvocation.function().name(), fts.deprecatedBy()));
                    return (B1)(Function1 & Serializable)seq -> new Foldable.TraverseChildren((Object)seq.$plus$plus((IterableOnce)deprecationWarnings.toSet()));
                }
                if (A1 instanceof UnresolvedCall) {
                    throw new InternalException("Expected procedures to have been resolved already");
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                IndexedSeq<FieldSignature> inputFields;
                Some some;
                UserFunctionSignature userFunctionSignature;
                Option<UserFunctionSignature> option;
                IndexedSeq<FieldSignature> inputFields2;
                ProcedureSignature procedureSignature;
                boolean bl = false;
                ResolvedCall resolvedCall = null;
                boolean bl2 = false;
                ResolvedFunctionInvocation resolvedFunctionInvocation = null;
                Object object = x1;
                if (object instanceof ResolvedCall) {
                    boolean bl3;
                    Some some2;
                    DeprecationInfo deprecationInfo;
                    Option<DeprecationInfo> option2;
                    bl = true;
                    resolvedCall = (ResolvedCall)object;
                    ProcedureSignature procedureSignature2 = resolvedCall.signature();
                    if (procedureSignature2 != null && (option2 = procedureSignature2.deprecationInfo()) instanceof Some && (deprecationInfo = (DeprecationInfo)(some2 = (Some)option2).value()) != null && (bl3 = deprecationInfo.isDeprecated())) {
                        return true;
                    }
                }
                if (bl && (procedureSignature = resolvedCall.signature()) != null && (inputFields2 = procedureSignature.inputSignature()).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)anonfun.findDeprecations.1.$anonfun$isDefinedAt$1(x$2)))) {
                    return true;
                }
                if (object instanceof ResolvedFunctionInvocation) {
                    boolean bl4;
                    Some some3;
                    DeprecationInfo deprecationInfo;
                    Option<DeprecationInfo> option3;
                    Some some4;
                    UserFunctionSignature userFunctionSignature2;
                    bl2 = true;
                    resolvedFunctionInvocation = (ResolvedFunctionInvocation)object;
                    Option<UserFunctionSignature> option4 = resolvedFunctionInvocation.fcnSignature();
                    if (option4 instanceof Some && (userFunctionSignature2 = (UserFunctionSignature)(some4 = (Some)option4).value()) != null && (option3 = userFunctionSignature2.deprecationInfo()) instanceof Some && (deprecationInfo = (DeprecationInfo)(some3 = (Some)option3).value()) != null && (bl4 = deprecationInfo.isDeprecated())) {
                        return true;
                    }
                }
                if (bl2 && (option = resolvedFunctionInvocation.fcnSignature()) instanceof Some && (userFunctionSignature = (UserFunctionSignature)(some = (Some)option).value()) != null && (inputFields = userFunctionSignature.inputSignature()).exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)anonfun.findDeprecations.1.$anonfun$isDefinedAt$2(x$5)))) {
                    return true;
                }
                if (object instanceof FunctionInvocation) {
                    return true;
                }
                return object instanceof UnresolvedCall;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$2(FieldSignature x$1) {
                return x$1.deprecated();
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$4(FieldSignature x$2) {
                return x$2.deprecated();
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$6(FieldSignature x$3) {
                return x$3.deprecated();
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$9(FieldSignature x$4) {
                return x$4.deprecated();
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$11(FieldSignature x$5) {
                return x$5.deprecated();
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$13(FieldSignature x$6) {
                return x$6.deprecated();
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$15(FunctionInvocation x72$1, FunctionTypeSignature x0$1) {
                FunctionTypeSignature functionTypeSignature = x0$1;
                if (functionTypeSignature != null) {
                    IndexedSeq argumentTypes = functionTypeSignature.argumentTypes();
                    boolean deprecated = functionTypeSignature.deprecated();
                    return deprecated && argumentTypes.length() == x72$1.arguments().length();
                }
                return false;
            }

            public static final /* synthetic */ boolean $anonfun$isDefinedAt$1(FieldSignature x$2) {
                return x$2.deprecated();
            }

            public static final /* synthetic */ boolean $anonfun$isDefinedAt$2(FieldSignature x$5) {
                return x$5.deprecated();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(scala.collection.immutable.IndexedSeq org.neo4j.cypher.internal.frontend.phases.ResolvedCall org.neo4j.cypher.internal.frontend.phases.QualifiedName scala.Option scala.collection.immutable.Set ), $anonfun$applyOrElse$10(org.neo4j.cypher.internal.frontend.phases.ResolvedFunctionInvocation org.neo4j.cypher.internal.frontend.phases.QualifiedName org.neo4j.cypher.internal.frontend.phases.FieldSignature ), $anonfun$applyOrElse$11$adapted(org.neo4j.cypher.internal.frontend.phases.FieldSignature ), $anonfun$applyOrElse$12(scala.collection.immutable.IndexedSeq org.neo4j.cypher.internal.frontend.phases.ResolvedFunctionInvocation org.neo4j.cypher.internal.frontend.phases.QualifiedName scala.collection.immutable.Set ), $anonfun$applyOrElse$13$adapted(org.neo4j.cypher.internal.frontend.phases.FieldSignature ), $anonfun$applyOrElse$14(org.neo4j.cypher.internal.frontend.phases.ResolvedFunctionInvocation org.neo4j.cypher.internal.frontend.phases.QualifiedName org.neo4j.cypher.internal.frontend.phases.FieldSignature ), $anonfun$applyOrElse$15$adapted(org.neo4j.cypher.internal.expressions.FunctionInvocation org.neo4j.cypher.internal.expressions.FunctionTypeSignature ), $anonfun$applyOrElse$16(org.neo4j.cypher.internal.expressions.FunctionTypeSignature ), $anonfun$applyOrElse$17(org.neo4j.cypher.internal.expressions.FunctionInvocation org.neo4j.cypher.internal.expressions.FunctionTypeSignature ), $anonfun$applyOrElse$18(scala.collection.immutable.Seq scala.collection.immutable.Set ), $anonfun$applyOrElse$2$adapted(org.neo4j.cypher.internal.frontend.phases.FieldSignature ), $anonfun$applyOrElse$3(org.neo4j.cypher.internal.frontend.phases.ResolvedCall org.neo4j.cypher.internal.frontend.phases.QualifiedName org.neo4j.cypher.internal.frontend.phases.FieldSignature ), $anonfun$applyOrElse$4$adapted(org.neo4j.cypher.internal.frontend.phases.FieldSignature ), $anonfun$applyOrElse$5(scala.collection.immutable.IndexedSeq org.neo4j.cypher.internal.frontend.phases.ResolvedCall org.neo4j.cypher.internal.frontend.phases.QualifiedName scala.collection.immutable.Set ), $anonfun$applyOrElse$6$adapted(org.neo4j.cypher.internal.frontend.phases.FieldSignature ), $anonfun$applyOrElse$7(org.neo4j.cypher.internal.frontend.phases.ResolvedCall org.neo4j.cypher.internal.frontend.phases.QualifiedName org.neo4j.cypher.internal.frontend.phases.FieldSignature ), $anonfun$applyOrElse$8(scala.collection.immutable.IndexedSeq org.neo4j.cypher.internal.frontend.phases.ResolvedFunctionInvocation org.neo4j.cypher.internal.frontend.phases.QualifiedName scala.Option scala.collection.immutable.Set ), $anonfun$applyOrElse$9$adapted(org.neo4j.cypher.internal.frontend.phases.FieldSignature ), $anonfun$isDefinedAt$1$adapted(org.neo4j.cypher.internal.frontend.phases.FieldSignature ), $anonfun$isDefinedAt$2$adapted(org.neo4j.cypher.internal.frontend.phases.FieldSignature )}, serializedLambda);
            }
        });
    }

    @Override
    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.DEPRECATION_WARNINGS;
    }

    public String productPrefix() {
        return "ProcedureAndFunctionDeprecationWarnings";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ProcedureAndFunctionDeprecationWarnings$;
    }

    public int hashCode() {
        return 1948933679;
    }

    public String toString() {
        return "ProcedureAndFunctionDeprecationWarnings";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ProcedureAndFunctionDeprecationWarnings$.class);
    }

    private ProcedureAndFunctionDeprecationWarnings$() {
    }
}

