/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.config;

import java.time.Duration;
import java.util.function.Supplier;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;

public class FabricConfig {
    private final Supplier<Duration> transactionTimeout;
    private final DataStream dataStream;
    private final boolean routingEnabled;
    private final boolean enabledByDefault;

    public FabricConfig(Supplier<Duration> transactionTimeout, DataStream dataStream, boolean routingEnabled, boolean enabledByDefault) {
        this.transactionTimeout = transactionTimeout;
        this.dataStream = dataStream;
        this.routingEnabled = routingEnabled;
        this.enabledByDefault = enabledByDefault;
    }

    public Duration getTransactionTimeout() {
        return this.transactionTimeout.get();
    }

    public DataStream getDataStream() {
        return this.dataStream;
    }

    public boolean isRoutingEnabled() {
        return this.routingEnabled;
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public static FabricConfig from(Config config) {
        int syncBatchSize = 50;
        DataStream dataStream = new DataStream(0, 0, syncBatchSize, 0);
        boolean enabledByDefault = true;
        return new FabricConfig(() -> (Duration)config.get(GraphDatabaseSettings.transaction_timeout), dataStream, false, enabledByDefault);
    }

    public static class DataStream {
        private final int bufferLowWatermark;
        private final int bufferSize;
        private final int batchSize;
        private final int concurrency;

        public DataStream(int bufferLowWatermark, int bufferSize, int batchSize, int concurrency) {
            this.bufferLowWatermark = bufferLowWatermark > bufferSize ? bufferSize : bufferLowWatermark;
            this.bufferSize = bufferSize;
            this.batchSize = batchSize;
            this.concurrency = concurrency;
        }

        public int getBufferLowWatermark() {
            return this.bufferLowWatermark;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public int getConcurrency() {
            return this.concurrency;
        }
    }
}

