/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.bookmark;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.neo4j.fabric.bolt.FabricBookmark;
import org.neo4j.fabric.bookmark.RemoteBookmark;
import org.neo4j.fabric.executor.FabricException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.io.PackstreamBuf;

public class BookmarkStateSerializer {
    public static String serialize(FabricBookmark fabricBookmark) {
        try {
            Packer packer = new Packer(fabricBookmark);
            String p = packer.pack();
            return p;
        }
        catch (IOException exception) {
            throw new IllegalStateException("Failed to serialize bookmark", exception);
        }
    }

    public static FabricBookmark deserialize(String serializedBookmark) {
        try {
            Unpacker unpacker = new Unpacker(serializedBookmark);
            return unpacker.unpack();
        }
        catch (IOException exception) {
            throw new FabricException((Status)Status.Transaction.InvalidBookmark, "Failed to deserialize bookmark", exception);
        }
    }

    private static class Packer {
        final PackstreamBuf buf = PackstreamBuf.allocUnpooled();
        final FabricBookmark fabricBookmark;

        Packer(FabricBookmark fabricBookmark) {
            this.fabricBookmark = fabricBookmark;
        }

        String pack() throws IOException {
            this.packInternalGraphs(this.fabricBookmark.getInternalGraphStates());
            this.packExternalGraphs(this.fabricBookmark.getExternalGraphStates());
            byte[] heap = new byte[this.buf.getTarget().readableBytes()];
            this.buf.getTarget().readBytes(heap);
            return Base64.getEncoder().encodeToString(heap);
        }

        void packInternalGraphs(List<FabricBookmark.InternalGraphState> internalGraphStates) {
            this.buf.writeList(internalGraphStates, this::packInternalGraph);
        }

        void packInternalGraph(PackstreamBuf buf, FabricBookmark.InternalGraphState internalGraphState) {
            this.packUuid(buf, internalGraphState.getGraphUuid());
            buf.writeInt(internalGraphState.getTransactionId());
        }

        void packExternalGraphs(List<FabricBookmark.ExternalGraphState> externalGraphStates) {
            this.buf.writeList(externalGraphStates, this::packExternalGraph);
        }

        void packExternalGraph(PackstreamBuf buf, FabricBookmark.ExternalGraphState externalGraphState) {
            this.packUuid(buf, externalGraphState.getGraphUuid());
            buf.writeList(externalGraphState.getBookmarks(), (b, bookmark) -> b.writeString(bookmark.getSerialisedState()));
        }

        void packUuid(PackstreamBuf buf, UUID uuid) {
            buf.writeBytes(Unpooled.buffer((int)16).writeLong(uuid.getMostSignificantBits()).writeLong(uuid.getLeastSignificantBits()));
        }
    }

    private static class Unpacker {
        final PackstreamBuf buf;

        Unpacker(String serializedBookmark) {
            byte[] bytes = Base64.getDecoder().decode(serializedBookmark);
            this.buf = PackstreamBuf.wrap((ByteBuf)Unpooled.wrappedBuffer((byte[])bytes));
        }

        FabricBookmark unpack() throws IOException {
            try {
                List<FabricBookmark.InternalGraphState> internalGraphs = this.unpackInternalGraphs();
                List<FabricBookmark.ExternalGraphState> externalGraphs = this.unpackExternalGraphs();
                return new FabricBookmark(internalGraphs, externalGraphs);
            }
            catch (PackstreamReaderException ex) {
                throw new IOException(ex);
            }
        }

        List<FabricBookmark.InternalGraphState> unpackInternalGraphs() throws IOException {
            return this.buf.readList(this::unpackInternalGraph);
        }

        FabricBookmark.InternalGraphState unpackInternalGraph(PackstreamBuf buf) throws PackstreamReaderException {
            UUID graphUuid = this.unpackUuid(buf);
            long txId = buf.readInt();
            return new FabricBookmark.InternalGraphState(graphUuid, txId);
        }

        List<FabricBookmark.ExternalGraphState> unpackExternalGraphs() throws IOException {
            return this.buf.readList(this::unpackExternalGraph);
        }

        FabricBookmark.ExternalGraphState unpackExternalGraph(PackstreamBuf buf) throws PackstreamReaderException {
            UUID graphUuid = this.unpackUuid(buf);
            List<RemoteBookmark> remoteBookmarks = buf.readList(PackstreamBuf::readString).stream().map(RemoteBookmark::new).collect(Collectors.toList());
            return new FabricBookmark.ExternalGraphState(graphUuid, remoteBookmarks);
        }

        UUID unpackUuid(PackstreamBuf buf) throws PackstreamReaderException {
            ByteBuf uuidBytes = buf.readBytes();
            long high = uuidBytes.readLong();
            long low = uuidBytes.readLong();
            return new UUID(high, low);
        }
    }
}

