/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.cypher.internal.FullyParsedQuery;
import org.neo4j.cypher.internal.ast.SubqueryCall;
import org.neo4j.cypher.internal.expressions.ExplicitParameter;
import org.neo4j.cypher.internal.expressions.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.logical.plans.TransactionForeach$;
import org.neo4j.exceptions.ParameterNotFoundException;
import org.neo4j.fabric.eval.Catalog;
import org.neo4j.fabric.eval.UseEvaluation;
import org.neo4j.fabric.executor.CallInTransactionsExecutorUtil;
import org.neo4j.fabric.executor.ExecutionOptions;
import org.neo4j.fabric.executor.FabricException;
import org.neo4j.fabric.executor.FragmentResult;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.executor.QueryStatementLifecycles;
import org.neo4j.fabric.executor.SingleQueryFragmentExecutor;
import org.neo4j.fabric.planning.FabricPlan;
import org.neo4j.fabric.planning.FabricPlanner;
import org.neo4j.fabric.planning.Fragment;
import org.neo4j.fabric.planning.Fragment$Apply$;
import org.neo4j.fabric.stream.Prefetcher;
import org.neo4j.fabric.stream.Record;
import org.neo4j.fabric.stream.Records;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.stream.summary.MergedQueryStatistics;
import org.neo4j.fabric.transaction.FabricTransaction;
import org.neo4j.fabric.transaction.TransactionMode;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.GqlStatusObject;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.query.QueryRoutingMonitor;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NoValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import scala.jdk.javaapi.CollectionConverters;

class CallInTransactionsExecutor
extends SingleQueryFragmentExecutor {
    private final Fragment.Apply callInTransactions;
    private final Fragment.Exec innerFragment;
    private final int batchSize;
    private final List<BufferedInputRow> inputRowsBuffer;
    private Catalog.Graph batchGraph;
    private TransactionMode batchTransactionMode;
    private OnErrorBreakContext onErrorBreakContext;

    CallInTransactionsExecutor(Fragment.Apply callInTransactions, FabricPlanner.PlannerInstance plannerInstance, Executor fabricWorkerExecutor, FabricTransaction.FabricExecutionContext ctx, UseEvaluation.Instance useEvaluator, FabricPlan plan, MapValue queryParams, AccessMode accessMode, Set<Notification> notifications, Set<GqlStatusObject> gqlStatusObjects, AtomicReference<Collection<GqlStatusObject>> lastAddedGqlStatusObjects, QueryStatementLifecycles.StatementLifecycle lifecycle, Prefetcher prefetcher, QueryRoutingMonitor queryRoutingMonitor, MergedQueryStatistics statistics, SingleQueryFragmentExecutor.Tracer tracer, SingleQueryFragmentExecutor.FragmentExecutor fragmentExecutor) {
        super(plannerInstance, fabricWorkerExecutor, ctx, useEvaluator, plan, queryParams, accessMode, notifications, gqlStatusObjects, lastAddedGqlStatusObjects, lifecycle, prefetcher, queryRoutingMonitor, statistics, tracer, fragmentExecutor);
        this.callInTransactions = callInTransactions;
        this.innerFragment = (Fragment.Exec)callInTransactions.inner();
        this.batchSize = this.batchSize();
        this.inputRowsBuffer = new ArrayList<BufferedInputRow>(this.batchSize);
        this.onErrorBreakContext = this.onErrorBreakContext();
    }

    private OnErrorBreakContext onErrorBreakContext() {
        SubqueryCall.InTransactionsParameters parameters = (SubqueryCall.InTransactionsParameters)this.callInTransactions.inTransactionsParameters().get();
        if (!CallInTransactionsExecutorUtil.isOnErrorBreak(parameters)) {
            return null;
        }
        int variableOffset = this.extractBreakReportVariableOffset(parameters);
        return new OnErrorBreakContext(variableOffset, parameters.reportParams().isEmpty(), false);
    }

    private int extractBreakReportVariableOffset(SubqueryCall.InTransactionsParameters parameters) {
        String variableName = (String)parameters.reportParams().map(reportParameters -> reportParameters.reportAs().name()).getOrElse(Fragment$Apply$.MODULE$::REPORT_VARIABLE);
        List columns = CollectionConverters.asJava(this.innerFragment.outputColumns());
        for (int i = 0; i < columns.size(); ++i) {
            if (!((String)columns.get(i)).equals(variableName)) continue;
            return i;
        }
        throw new IllegalStateException("Report variable not found among columns: " + String.valueOf(columns));
    }

    Flux<Record> run(Record argument) {
        Flux<Record> input = this.fragmentExecutor().run(this.callInTransactions.input(), argument).records();
        Flux resultPipe = input.flatMap(this::processInputRecord, 1, 1);
        return Flux.concat((Publisher[])new Publisher[]{resultPipe, Flux.defer(this::processBufferedInputRows)});
    }

    private int batchSize() {
        return (Integer)this.callInTransactions.inTransactionsParameters().flatMap(SubqueryCall.InTransactionsParameters::batchParams).map(SubqueryCall.InTransactionsBatchParameters::batchSize).map(expression -> {
            if (expression instanceof SignedDecimalIntegerLiteral) {
                SignedDecimalIntegerLiteral literal = (SignedDecimalIntegerLiteral)expression;
                return literal.value().intValue();
            }
            if (expression instanceof ExplicitParameter) {
                ExplicitParameter parameter = (ExplicitParameter)expression;
                return this.batchSizeFromParam(parameter);
            }
            throw new IllegalArgumentException("Unexpected batch size expression: " + String.valueOf(expression));
        }).getOrElse(() -> (int)TransactionForeach$.MODULE$.defaultBatchSize());
    }

    private int batchSizeFromParam(ExplicitParameter parameter) {
        AnyValue paramValue = this.queryParams().get(parameter.name());
        if (paramValue instanceof LongValue) {
            LongValue longValue = (LongValue)paramValue;
            return (int)longValue.value();
        }
        if (paramValue instanceof IntegralValue) {
            IntegralValue integralValue = (IntegralValue)paramValue;
            return integralValue.intValue();
        }
        if (paramValue instanceof NoValue) {
            throw new ParameterNotFoundException("Expected parameter(s): " + parameter.name());
        }
        throw new FabricException((Status)Status.Statement.SyntaxError, "Type mismatch for parameter '%s': expected Integer but was %s".formatted(parameter.name(), paramValue.getTypeName()), new Object[0]);
    }

    private Flux<Record> processInputRecord(Record argument) {
        if (this.onErrorBreakContext != null && this.onErrorBreakContext.breakExecution) {
            return this.produceBreakOutput(argument);
        }
        SingleQueryFragmentExecutor.PrepareResult prepareResult = this.prepare(this.innerFragment, argument);
        if (this.batchGraph == null) {
            this.batchGraph = prepareResult.graph();
            this.batchTransactionMode = prepareResult.transactionMode();
        }
        if (!this.batchGraph.equals(prepareResult.graph())) {
            Flux<Record> result = this.processBufferedInputRows();
            this.batchGraph = prepareResult.graph();
            this.batchTransactionMode = prepareResult.transactionMode();
            this.inputRowsBuffer.add(new BufferedInputRow(prepareResult.argumentValues(), argument));
            return result;
        }
        this.inputRowsBuffer.add(new BufferedInputRow(prepareResult.argumentValues(), argument));
        if (this.inputRowsBuffer.size() == this.batchSize) {
            return this.processBufferedInputRows();
        }
        return Flux.empty();
    }

    private Flux<Record> produceBreakOutput(Record argument) {
        List columns = CollectionConverters.asJava(this.innerFragment.outputColumns());
        int columnCount = columns.size() - this.addedColumnsCount();
        ArrayList<AnyValue> values = new ArrayList<AnyValue>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            if (i == this.onErrorBreakContext.reportVariableOffset) {
                MapValueBuilder builder = new MapValueBuilder(4);
                builder.add("started", (AnyValue)BooleanValue.FALSE);
                builder.add("committed", (AnyValue)BooleanValue.FALSE);
                builder.add("transactionId", (AnyValue)NoValue.NO_VALUE);
                builder.add("errorMessage", (AnyValue)NoValue.NO_VALUE);
                values.add((AnyValue)builder.build());
                continue;
            }
            values.add((AnyValue)NoValue.NO_VALUE);
        }
        return Flux.just((Object)Records.join(argument, Records.of(values)));
    }

    private Flux<Record> processBufferedInputRows() {
        if (this.inputRowsBuffer.isEmpty()) {
            return Flux.empty();
        }
        MapValue params = this.addParamsFromInputRows();
        FragmentResult result = this.doExecuteFragment(this.innerFragment, params, this.batchGraph, this.batchTransactionMode, () -> new FragmentResult((Flux<Record>)Flux.just((Object)Records.empty()), (Mono<ExecutionPlanDescription>)Mono.empty(), (Mono<QueryExecutionType>)Mono.empty()));
        ArrayList<BufferedInputRow> inputRecords = new ArrayList<BufferedInputRow>(this.inputRowsBuffer);
        Flux resultStream = result.records();
        if (this.onErrorBreakContext != null) {
            resultStream = resultStream.map(this::checkBreakCondition);
        }
        resultStream = this.callInTransactions.outputColumns().isEmpty() ? resultStream.map(outputRecord -> this.getMatchingInputRecord((Record)outputRecord, (List<BufferedInputRow>)inputRecords)) : resultStream.map(outputRecord -> Records.join(this.getMatchingInputRecord((Record)outputRecord, (List<BufferedInputRow>)inputRecords), this.stripAddedColumns((Record)outputRecord)));
        this.batchGraph = null;
        this.batchTransactionMode = null;
        this.inputRowsBuffer.clear();
        return resultStream;
    }

    private Record getMatchingInputRecord(Record outputRecord, List<BufferedInputRow> inputRecords) {
        int rowIdColumn = this.innerFragment.outputColumns().size() - 1;
        IntegralValue rowId = (IntegralValue)outputRecord.getValue(rowIdColumn);
        int rowIdAsInt = rowId instanceof LongValue ? (int)((LongValue)rowId).value() : rowId.intValue();
        return inputRecords.get((int)rowIdAsInt).record;
    }

    private Record stripAddedColumns(Record record) {
        int columnCount = record.size() - this.addedColumnsCount();
        AnyValue[] values = new AnyValue[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            values[i] = record.getValue(i);
        }
        return Records.of(values);
    }

    private int addedColumnsCount() {
        int addedColumnsCount = 1;
        if (this.onErrorBreakContext != null && this.onErrorBreakContext.reportVariableAdded) {
            ++addedColumnsCount;
        }
        return addedColumnsCount;
    }

    private Record checkBreakCondition(Record outputRecord) {
        AnyValue value = outputRecord.getValue(this.onErrorBreakContext.reportVariableOffset);
        MapValue mapValue = (MapValue)value;
        if (mapValue.get("errorMessage") != NoValue.NO_VALUE) {
            this.onErrorBreakContext = new OnErrorBreakContext(this.onErrorBreakContext.reportVariableOffset, this.onErrorBreakContext.reportVariableAdded, true);
        }
        return outputRecord;
    }

    private MapValue addParamsFromInputRows() {
        List bindings = CollectionConverters.asJava(this.innerFragment.argumentColumns());
        ListValueBuilder rowListBuilder = ListValueBuilder.newListBuilder((int)this.inputRowsBuffer.size());
        for (int i = 0; i < this.inputRowsBuffer.size(); ++i) {
            MapValue rowParams = this.rowToParams(this.inputRowsBuffer.get(i), bindings, i);
            rowListBuilder.add((AnyValue)rowParams);
        }
        ListValue rows = rowListBuilder.build();
        MapValueBuilder builder = new MapValueBuilder(this.queryParams().size() + 1);
        this.queryParams().foreach((arg_0, arg_1) -> ((MapValueBuilder)builder).add(arg_0, arg_1));
        builder.add(Fragment$Apply$.MODULE$.CALL_IN_TX_ROWS(), (AnyValue)rows);
        return builder.build();
    }

    private MapValue rowToParams(BufferedInputRow inputRow, List<String> bindings, int rowId) {
        MapValueBuilder builder = new MapValueBuilder(bindings.size() + 1);
        bindings.forEach(var -> builder.add(var, this.validateValue(inputRow.argumentValues().get(var))));
        builder.add(Fragment$Apply$.MODULE$.CALL_IN_TX_ROW_ID(), (AnyValue)Values.intValue((int)rowId));
        return builder.build();
    }

    @Override
    Mono<StatementResult> runRemote(Location.Remote location, ExecutionOptions options, String query, TransactionMode transactionMode, MapValue params) {
        return Mono.just((Object)this.ctx().getRemote().runInAutocommitTransaction(location, options, query, transactionMode, params));
    }

    @Override
    StatementResult runLocal(Location.Local location, TransactionMode transactionMode, QueryStatementLifecycles.StatementLifecycle parentLifecycle, FullyParsedQuery query, MapValue params, Flux<Record> input, ExecutionOptions executionOptions, Boolean targetsComposite) {
        return this.ctx().getLocal().runInAutocommitTransaction(location, parentLifecycle, query, params, input, executionOptions);
    }

    private record OnErrorBreakContext(int reportVariableOffset, boolean reportVariableAdded, boolean breakExecution) {
    }

    private record BufferedInputRow(Map<String, AnyValue> argumentValues, Record record) {
    }
}

