/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.bolt;

import java.util.List;
import org.neo4j.bolt.dbapi.BoltQueryExecution;
import org.neo4j.cypher.internal.javacompat.ResultSubscriber;
import org.neo4j.fabric.config.FabricConfig;
import org.neo4j.fabric.executor.Exceptions;
import org.neo4j.fabric.stream.Record;
import org.neo4j.fabric.stream.Rx2SyncStream;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.stream.summary.Summary;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.GqlStatusObject;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import reactor.core.publisher.Mono;

public class BoltQueryExecutionImpl
implements BoltQueryExecution {
    private final QueryExecutionImpl queryExecution;
    private final QuerySubscriber subscriber;

    public BoltQueryExecutionImpl(StatementResult statementResult, QuerySubscriber subscriber, FabricConfig fabricConfig) {
        this.subscriber = subscriber;
        FabricConfig.DataStream config = fabricConfig.getDataStream();
        Rx2SyncStream rx2SyncStream = new Rx2SyncStream(statementResult.records(), config.getBatchSize());
        this.queryExecution = new QueryExecutionImpl(rx2SyncStream, subscriber, statementResult.columns(), statementResult.summary(), statementResult.executionType());
    }

    public void initialize() throws Exception {
        boolean triggerArtificialDemand;
        boolean isWriteOnly = this.queryExecution.executionType().queryType() == QueryExecutionType.QueryType.WRITE;
        boolean isReadOnly = this.queryExecution.executionType().queryType() == QueryExecutionType.QueryType.READ_ONLY;
        boolean isExplain = this.queryExecution.executionType().isExplained();
        boolean noResult = this.queryExecution.fieldNames().length == 0;
        boolean bl = triggerArtificialDemand = isWriteOnly || isExplain || noResult;
        if (triggerArtificialDemand) {
            this.queryExecution.request(1L);
            this.queryExecution.await();
        }
        if (this.subscriber instanceof ResultSubscriber && (!isReadOnly || isExplain)) {
            ((ResultSubscriber)this.subscriber).materialize((QueryExecution)this.queryExecution);
        }
    }

    public QueryExecution queryExecution() {
        return this.queryExecution;
    }

    public void close() {
        this.queryExecution.cancel();
    }

    public void terminate() {
        this.queryExecution.cancel();
    }

    private static class QueryExecutionImpl
    implements QueryExecution {
        private final Rx2SyncStream rx2SyncStream;
        private final QuerySubscriber subscriber;
        private boolean hasMore = true;
        private boolean initialised;
        private final Mono<Summary> summary;
        private final Mono<QueryExecutionType> queryExecutionType;
        private final List<String> columns;

        private QueryExecutionImpl(Rx2SyncStream rx2SyncStream, QuerySubscriber subscriber, List<String> columns, Mono<Summary> summary, Mono<QueryExecutionType> queryExecutionType) {
            this.rx2SyncStream = rx2SyncStream;
            this.subscriber = subscriber;
            this.summary = summary;
            this.queryExecutionType = queryExecutionType;
            this.columns = columns;
        }

        private Summary getSummary() {
            return (Summary)this.summary.cache().block();
        }

        public QueryExecutionType executionType() {
            return (QueryExecutionType)this.queryExecutionType.cache().block();
        }

        public ExecutionPlanDescription executionPlanDescription() {
            return this.getSummary().executionPlanDescription();
        }

        public Iterable<Notification> getNotifications() {
            return this.getSummary().getNotifications();
        }

        public Iterable<GqlStatusObject> getGqlStatusObjects() {
            return this.getSummary().getGqlStatusObjects();
        }

        public String[] fieldNames() {
            return this.columns.toArray(new String[0]);
        }

        public void request(long numberOfRecords) throws Exception {
            if (!this.hasMore) {
                return;
            }
            if (!this.initialised) {
                this.initialised = true;
                this.subscriber.onResult(this.columns.size());
            }
            try {
                int i = 0;
                while ((long)i < numberOfRecords) {
                    Record record = this.rx2SyncStream.readRecord();
                    if (record == null) {
                        this.hasMore = false;
                        this.subscriber.onResultCompleted(this.getSummary().getQueryStatistics());
                        return;
                    }
                    this.subscriber.onRecord();
                    this.publishFields(record);
                    this.subscriber.onRecordCompleted();
                    ++i;
                }
                if (this.rx2SyncStream.completed()) {
                    this.hasMore = false;
                    this.subscriber.onResultCompleted(this.getSummary().getQueryStatistics());
                }
            }
            catch (Exception e) {
                throw Exceptions.transformUnexpectedError((Status)Status.Statement.ExecutionFailed, e);
            }
        }

        private void publishFields(Record record) throws Exception {
            for (int i = 0; i < this.columns.size(); ++i) {
                this.subscriber.onField(i, record.getValue(i));
            }
        }

        public void cancel() {
            this.rx2SyncStream.close();
        }

        public boolean await() {
            return this.hasMore;
        }
    }
}

