/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.stream.summary;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.fabric.stream.summary.MergedQueryStatistics;
import org.neo4j.fabric.stream.summary.Summary;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.GqlStatusObject;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.notifications.StandardGqlStatusObject;
import reactor.core.publisher.Mono;

public class MergedSummary
implements Summary {
    private final MergedQueryStatistics statistics;
    private final Set<Notification> notifications;
    private final Set<GqlStatusObject> gqlStatusObjects;
    private final AtomicReference<Collection<GqlStatusObject>> lastUpdatedGqlStatusObjects;
    private Mono<ExecutionPlanDescription> executionPlanDescription;

    public MergedSummary(Mono<ExecutionPlanDescription> executionPlanDescription, MergedQueryStatistics statistics, Set<Notification> notifications, Set<GqlStatusObject> gqlStatusObjects, AtomicReference<Collection<GqlStatusObject>> lastUpdatedGqlStatusObjects) {
        this.executionPlanDescription = executionPlanDescription;
        this.statistics = statistics;
        this.notifications = notifications;
        this.gqlStatusObjects = gqlStatusObjects;
        this.lastUpdatedGqlStatusObjects = lastUpdatedGqlStatusObjects;
    }

    @Override
    public ExecutionPlanDescription executionPlanDescription() {
        return (ExecutionPlanDescription)this.executionPlanDescription.cache().block();
    }

    @Override
    public Collection<Notification> getNotifications() {
        return this.notifications;
    }

    @Override
    public Collection<GqlStatusObject> getGqlStatusObjects() {
        if (this.lastUpdatedGqlStatusObjects.get() != null) {
            this.gqlStatusObjects.removeIf(gso -> StandardGqlStatusObject.isStandardGqlStatusCode((String)gso.gqlStatus()));
            this.gqlStatusObjects.addAll(this.lastUpdatedGqlStatusObjects.get());
        }
        return this.gqlStatusObjects;
    }

    @Override
    public QueryStatistics getQueryStatistics() {
        return this.statistics;
    }
}

