/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.stream;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.neo4j.fabric.executor.FabricException;
import org.neo4j.fabric.executor.LocalExecutionSummary;
import org.neo4j.fabric.stream.Record;
import org.neo4j.fabric.stream.Records;
import org.neo4j.fabric.stream.SourceTagging;
import org.neo4j.fabric.stream.summary.EmptySummary;
import org.neo4j.fabric.stream.summary.Summary;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeReference;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Mono;

public interface QuerySubject
extends QuerySubscriber,
Publisher<Record> {
    public void setQueryExecution(QueryExecution var1);

    public Mono<Summary> getSummary();

    public static class CompositeQuerySubject
    extends BasicQuerySubject
    implements QuerySubject {
        private final long sourceTagId;
        private final long sourceId;

        public CompositeQuerySubject(long sourceId) {
            this.sourceTagId = SourceTagging.makeSourceTag(sourceId);
            this.sourceId = sourceId;
        }

        @Override
        public void onField(int offset, AnyValue value) {
            AnyValue compositeDatabaseValue = this.toCompositeDatabaseValue(value);
            super.onField(offset, compositeDatabaseValue);
        }

        private AnyValue toCompositeDatabaseValue(AnyValue value) {
            if (value instanceof VirtualNodeValue) {
                if (value instanceof NodeValue) {
                    NodeValue node = (NodeValue)value;
                    return this.toCompositeDatabaseValue(node);
                }
                throw CompositeQuerySubject.unableToTagError(value);
            }
            if (value instanceof VirtualRelationshipValue) {
                if (value instanceof RelationshipValue) {
                    RelationshipValue rel = (RelationshipValue)value;
                    return this.toCompositeDatabaseValue(rel);
                }
                throw CompositeQuerySubject.unableToTagError(value);
            }
            if (value instanceof PathValue) {
                return this.toCompositeDatabaseValue((PathValue)value);
            }
            if (value instanceof ListValue) {
                return this.toCompositeDatabaseValue((ListValue)value);
            }
            if (value instanceof MapValue) {
                return this.toCompositeDatabaseValue((MapValue)value);
            }
            return value;
        }

        private NodeValue toCompositeDatabaseValue(NodeValue n) {
            return VirtualValues.compositeGraphNodeValue((long)this.tag(n.id()), (String)n.elementId(), (long)this.sourceId, (TextArray)n.labels(), (MapValue)n.properties());
        }

        private RelationshipValue toCompositeDatabaseValue(RelationshipValue r) {
            return VirtualValues.compositeGraphRelationshipValue((long)r.id(), (String)r.elementId(), (long)this.sourceId, (VirtualNodeReference)VirtualValues.node((long)this.tag(r.startNodeId()), (String)r.startNode().elementId(), (long)this.sourceId), (VirtualNodeReference)VirtualValues.node((long)this.tag(r.endNodeId()), (String)r.endNode().elementId(), (long)this.sourceId), (TextValue)r.type(), (MapValue)r.properties());
        }

        private PathValue toCompositeDatabaseValue(PathValue pathValue) {
            return VirtualValues.path((NodeValue[])((NodeValue[])Arrays.stream(pathValue.nodes()).map(this::toCompositeDatabaseValue).toArray(NodeValue[]::new)), (RelationshipValue[])((RelationshipValue[])Arrays.stream(pathValue.relationships()).map(this::toCompositeDatabaseValue).toArray(RelationshipValue[]::new)));
        }

        private ListValue toCompositeDatabaseValue(ListValue listValue) {
            return VirtualValues.list((AnyValue[])((AnyValue[])Arrays.stream(listValue.asArray()).map(this::toCompositeDatabaseValue).toArray(AnyValue[]::new)));
        }

        private MapValue toCompositeDatabaseValue(MapValue mapValue) {
            if (mapValue.isEmpty()) {
                return mapValue;
            }
            MapValueBuilder builder = new MapValueBuilder(mapValue.size());
            mapValue.foreach((key, value) -> builder.add(key, this.toCompositeDatabaseValue((AnyValue)value)));
            return builder.build();
        }

        private long tag(long id) {
            return SourceTagging.tagId(id, this.sourceTagId);
        }

        private static FabricException unableToTagError(AnyValue value) {
            return new FabricException((Status)Status.General.UnknownError, "Unable to add graph id to entity of type " + value.getTypeName(), new Object[0]);
        }
    }

    public static abstract class RecordQuerySubscriber
    implements QuerySubscriber {
        private int numberOfFields;
        private AnyValue[] fields;

        public void onResult(int numberOfFields) {
            this.numberOfFields = numberOfFields;
        }

        public void onRecord() {
            this.fields = new AnyValue[this.numberOfFields];
        }

        public void onField(int offset, AnyValue value) {
            this.fields[offset] = value;
        }

        public void onRecordCompleted() {
            this.onNext(Records.of(this.fields));
        }

        abstract void onNext(Record var1);
    }

    public static class BasicQuerySubject
    extends RecordQuerySubscriber
    implements QuerySubject {
        private final CompletableFuture<Summary> summaryFuture = new CompletableFuture();
        private Subscriber<? super Record> subscriber;
        private QueryExecution queryExecution;
        private QueryStatistics statistics;
        private Throwable cachedError;
        private boolean cachedCompleted;
        private boolean errorReceived;

        @Override
        public void setQueryExecution(QueryExecution queryExecution) {
            this.queryExecution = queryExecution;
        }

        @Override
        public Mono<Summary> getSummary() {
            return Mono.fromFuture(this.summaryFuture);
        }

        @Override
        public void onNext(Record record) {
            this.subscriber.onNext((Object)record);
        }

        public void onError(Throwable throwable) {
            this.errorReceived = true;
            if (this.subscriber == null) {
                this.cachedError = throwable;
            } else {
                this.subscriber.onError(throwable);
            }
            this.summaryFuture.completeExceptionally(throwable);
        }

        public void onResultCompleted(QueryStatistics statistics) {
            this.statistics = statistics;
            if (this.subscriber == null) {
                this.cachedCompleted = true;
            } else {
                this.subscriber.onComplete();
                this.completeSummary();
            }
        }

        private void completeSummary() {
            this.summaryFuture.complete(new LocalExecutionSummary(this.queryExecution, this.statistics));
        }

        public void subscribe(final Subscriber<? super Record> subscriber) {
            if (this.subscriber != null) {
                throw new FabricException((Status)Status.General.UnknownError, "Already subscribed", new Object[0]);
            }
            this.subscriber = subscriber;
            Subscription subscription = new Subscription(){
                private final Object requestLock = new Object();
                private long pendingRequests;
                private boolean producing;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void request(long size) {
                    Object object = this.requestLock;
                    synchronized (object) {
                        this.pendingRequests += size;
                        if (this.producing) {
                            return;
                        }
                        this.producing = true;
                    }
                    try {
                        while (true) {
                            long toRequest;
                            Object object2 = this.requestLock;
                            synchronized (object2) {
                                block19: {
                                    toRequest = this.pendingRequests;
                                    if (toRequest != 0L) break block19;
                                    return;
                                }
                                this.pendingRequests = 0L;
                            }
                            this.doRequest(toRequest);
                        }
                    }
                    finally {
                        Object object3 = this.requestLock;
                        synchronized (object3) {
                            this.producing = false;
                        }
                    }
                }

                private void doRequest(long size) {
                    this.maybeSendCachedEvents();
                    try {
                        queryExecution.request(size);
                        boolean hasMore = queryExecution.await();
                        if (!hasMore) {
                            cachedCompleted = true;
                            this.maybeSendCachedEvents();
                        }
                    }
                    catch (Exception e) {
                        subscriber.onError((Throwable)e);
                    }
                }

                public void cancel() {
                    try {
                        queryExecution.cancel();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!summaryFuture.isDone()) {
                        summaryFuture.complete(new EmptySummary());
                    }
                }
            };
            subscriber.onSubscribe(subscription);
            this.maybeSendCachedEvents();
        }

        private void maybeSendCachedEvents() {
            if (this.cachedError != null) {
                this.subscriber.onError(this.cachedError);
                this.cachedError = null;
            } else if (this.cachedCompleted) {
                this.subscriber.onComplete();
                this.cachedCompleted = false;
                this.completeSummary();
            }
        }
    }
}

