/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [https://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package org.neo4j.fabric.executor;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.graphdb.ExecutionPlanDescription;

public class TaggingPlanDescriptionWrapper implements ExecutionPlanDescription {
    private final ExecutionPlanDescription innerPlanDescription;
    private final String graphName;

    public TaggingPlanDescriptionWrapper(ExecutionPlanDescription innerPlanDescription, String graphName) {
        this.innerPlanDescription = innerPlanDescription;
        this.graphName = graphName;
    }

    @Override
    public String getName() {
        return innerPlanDescription.getName() + "@" + graphName;
    }

    @Override
    public List<ExecutionPlanDescription> getChildren() {
        return innerPlanDescription.getChildren().stream()
                .map(child -> new TaggingPlanDescriptionWrapper(child, graphName))
                .collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> getArguments() {
        return innerPlanDescription.getArguments();
    }

    @Override
    public Set<String> getIdentifiers() {
        return innerPlanDescription.getIdentifiers();
    }

    @Override
    public boolean hasProfilerStatistics() {
        return innerPlanDescription.hasProfilerStatistics();
    }

    @Override
    public ProfilerStatistics getProfilerStatistics() {
        return innerPlanDescription.getProfilerStatistics();
    }

    public ExecutionPlanDescription getInnerPlanDescription() {
        return innerPlanDescription;
    }

    @Override
    public String toString() {
        return innerPlanDescription.toString();
    }
}
