/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.util;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.CatalogName;
import org.neo4j.cypher.internal.ast.semantics.FeatureError;
import org.neo4j.cypher.internal.ast.semantics.FeatureError$;
import org.neo4j.cypher.internal.ast.semantics.SemanticError;
import org.neo4j.cypher.internal.ast.semantics.SemanticError$;
import org.neo4j.cypher.internal.ast.semantics.SemanticErrorDef;
import org.neo4j.cypher.internal.util.ASTNode;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.InputPosition$;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.exceptions.EntityNotFoundException;
import org.neo4j.exceptions.InvalidSemanticsException;
import org.neo4j.exceptions.SyntaxException;
import org.neo4j.fabric.eval.Catalog;
import org.neo4j.fabric.util.Errors;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.Nothing$;

public final class Errors$ {
    public static final Errors$ MODULE$ = new Errors$();

    public SemanticError openCypherSemantic(String msg, ASTNode node) {
        return SemanticError$.MODULE$.apply(msg, node.position());
    }

    public Nothing$ openCypherFailure(Seq<SemanticErrorDef> errors) {
        throw new Errors.EvaluationFailedException(errors);
    }

    public Nothing$ openCypherFailure(SemanticErrorDef error) {
        return this.openCypherFailure((Seq<SemanticErrorDef>)new .colon.colon((Object)error, (List)Nil$.MODULE$));
    }

    public Nothing$ wrongType(String exp, String got) {
        throw new CypherTypeException("Wrong type. Expected " + exp + ", got " + got);
    }

    public Nothing$ wrongArity(int exp, int got) {
        return this.syntax("Wrong arity. Expected " + exp + " argument(s), got " + got + " argument(s)");
    }

    public Nothing$ syntax(String msg) {
        throw new SyntaxException(msg);
    }

    public Nothing$ syntax(String msg, String query, InputPosition pos) {
        throw new SyntaxException(msg, query, pos.offset());
    }

    public Nothing$ semantic(String message) {
        throw new InvalidSemanticsException(message);
    }

    public Nothing$ entityNotFound(String kind, String needle) {
        throw new EntityNotFoundException(kind + " not found: " + needle);
    }

    public <T> T errorContext(String query, ASTNode node, Function0<T> block) {
        Object object;
        try {
            object = block.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof Errors.HasErrors) {
                Errors.HasErrors hasErrors = (Errors.HasErrors)((Object)throwable2);
                throw (Throwable)((Object)hasErrors.update((Function1<SemanticErrorDef, SemanticErrorDef>)(Function1 & Serializable)x0$1 -> {
                    Option option;
                    Option option2;
                    Option option3;
                    boolean bl = false;
                    FeatureError featureError = null;
                    SemanticErrorDef semanticErrorDef = x0$1;
                    if (semanticErrorDef != null && !(option3 = SemanticError$.MODULE$.unapply(semanticErrorDef)).isEmpty()) {
                        String msg = (String)((Tuple2)option3.get())._1();
                        InputPosition inputPosition = (InputPosition)((Tuple2)option3.get())._2();
                        InputPosition inputPosition2 = InputPosition$.MODULE$.NONE();
                        InputPosition inputPosition3 = inputPosition;
                        if (!(inputPosition2 != null ? !inputPosition2.equals(inputPosition3) : inputPosition3 != null)) {
                            throw MODULE$.syntax(msg, query, node.position());
                        }
                    }
                    if (semanticErrorDef != null && !(option2 = SemanticError$.MODULE$.unapply(semanticErrorDef)).isEmpty()) {
                        String msg = (String)((Tuple2)option2.get())._1();
                        InputPosition pos = (InputPosition)((Tuple2)option2.get())._2();
                        throw MODULE$.syntax(msg, query, pos);
                    }
                    if (semanticErrorDef instanceof FeatureError) {
                        bl = true;
                        featureError = (FeatureError)semanticErrorDef;
                        Option option4 = FeatureError$.MODULE$.unapply(featureError);
                        if (!option4.isEmpty()) {
                            String msg = (String)((Tuple3)option4.get())._1();
                            InputPosition inputPosition = (InputPosition)((Tuple3)option4.get())._3();
                            InputPosition inputPosition4 = InputPosition$.MODULE$.NONE();
                            InputPosition inputPosition5 = inputPosition;
                            if (!(inputPosition4 != null ? !inputPosition4.equals(inputPosition5) : inputPosition5 != null)) {
                                throw MODULE$.syntax(msg, query, node.position());
                            }
                        }
                    }
                    if (bl && !(option = FeatureError$.MODULE$.unapply(featureError)).isEmpty()) {
                        String msg = (String)((Tuple3)option.get())._1();
                        InputPosition pos = (InputPosition)((Tuple3)option.get())._3();
                        throw MODULE$.syntax(msg, query, pos);
                    }
                    return semanticErrorDef;
                }));
            }
            throw throwable;
        }
        return (T)object;
    }

    public String show(CatalogName n) {
        return n.parts().mkString(".");
    }

    public String show(AnyValue av) {
        AnyValue anyValue = av;
        if (anyValue instanceof Value) {
            Value value = (Value)anyValue;
            return value.prettyPrint();
        }
        return anyValue.getTypeName();
    }

    public String show(Catalog.Arg<?> a) {
        return a.name() + ": " + a.tpe().getSimpleName();
    }

    public String show(Seq<Object> seq) {
        return ((IterableOnceOps)seq.map((Function1 & Serializable)x0$1 -> {
            Object object = x0$1;
            if (object instanceof AnyValue) {
                AnyValue anyValue = (AnyValue)object;
                return MODULE$.show(anyValue);
            }
            if (object instanceof Catalog.Arg) {
                Catalog.Arg arg = (Catalog.Arg)object;
                return MODULE$.show(arg);
            }
            throw new MatchError(object);
        })).mkString(",");
    }

    private Errors$() {
    }
}

